/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.transformer.impl;

import com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.constraints.ImmutableHomomorphism;
import it.unibz.inf.ontop.constraints.ImmutableHomomorphismIterator;
import it.unibz.inf.ontop.constraints.impl.ImmutableCQContainmentCheckUnderLIDs;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.tools.UnionBasedQueryMerger;
import it.unibz.inf.ontop.model.atom.RDFAtomPredicate;
import it.unibz.inf.ontop.model.atom.RelationPredicate;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.spec.mapping.transformer.impl.IQ2CQ;
import it.unibz.inf.ontop.spec.mapping.transformer.impl.TMappingRule;
import it.unibz.inf.ontop.spec.mapping.utils.MappingTools;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Stream;

public class TMappingEntry {
    private ImmutableList<TMappingRule> rules;
    private final TermFactory termFactory;

    public TMappingEntry(ImmutableList<TMappingRule> rules, TermFactory termFactory) {
        this.rules = rules;
        this.termFactory = termFactory;
    }

    public TMappingEntry createCopy(Function<TMappingRule, TMappingRule> headReplacer) {
        return new TMappingEntry((ImmutableList<TMappingRule>)((ImmutableList)this.rules.stream().map(headReplacer).collect(ImmutableCollectors.toList())), this.termFactory);
    }

    public IQ asIQ(IntermediateQueryFactory iqFactory, UnionBasedQueryMerger queryMerger) {
        return (IQ)queryMerger.mergeDefinitions((Collection)this.rules.stream().map(r -> r.asIQ(iqFactory)).collect(ImmutableCollectors.toList())).get();
    }

    public boolean isEmpty() {
        return this.rules.isEmpty();
    }

    public MappingTools.RDFPredicateInfo getPredicateInfo() {
        return ((TMappingRule)this.rules.iterator().next()).getPredicateInfo();
    }

    public RDFAtomPredicate getRDFAtomPredicate() {
        return ((TMappingRule)this.rules.iterator().next()).getRDFAtomPredicate();
    }

    public String toString() {
        return "TME: " + this.getPredicateInfo() + ": " + this.rules.toString();
    }

    public static Collector<TMappingRule, BuilderWithCQC, TMappingEntry> toTMappingEntry(ImmutableCQContainmentCheckUnderLIDs<RelationPredicate> cqc, TermFactory termFactory) {
        return Collector.of(() -> new BuilderWithCQC(cqc, termFactory), BuilderWithCQC::add, (b1, b2) -> b1.addAll((Iterator<TMappingRule>)b2.build().rules.iterator()), BuilderWithCQC::build, Collector.Characteristics.UNORDERED);
    }

    private static final class BuilderWithCQC {
        private final List<TMappingRule> rules = new ArrayList<TMappingRule>();
        private final ImmutableCQContainmentCheckUnderLIDs<RelationPredicate> cqc;
        private final TermFactory termFactory;

        BuilderWithCQC(ImmutableCQContainmentCheckUnderLIDs<RelationPredicate> cqc, TermFactory termFactory) {
            this.cqc = cqc;
            this.termFactory = termFactory;
        }

        public BuilderWithCQC add(TMappingRule rule) {
            this.mergeMappingsWithCQC(rule);
            return this;
        }

        public BuilderWithCQC addAll(Iterator<TMappingRule> rs) {
            while (rs.hasNext()) {
                this.mergeMappingsWithCQC(rs.next());
            }
            return this;
        }

        public TMappingEntry build() {
            return new TMappingEntry((ImmutableList<TMappingRule>)ImmutableList.copyOf(this.rules), this.termFactory);
        }

        private void mergeMappingsWithCQC(TMappingRule assertion) {
            if (this.rules.contains(assertion)) {
                return;
            }
            if (assertion.getDatabaseAtoms().isEmpty() && assertion.getConditions().isEmpty()) {
                this.rules.add(assertion);
                return;
            }
            Iterator<TMappingRule> mappingIterator = this.rules.iterator();
            while (mappingIterator.hasNext()) {
                Optional<ImmutableHomomorphism> from;
                TMappingRule current = mappingIterator.next();
                boolean couldIgnore = false;
                Optional<ImmutableHomomorphism> to = this.fixHeadTermMapping(current.getHeadTerms(), assertion.getHeadTerms()).map(h -> this.cqc.homomorphismIterator(h, IQ2CQ.toDataAtoms(current.getDatabaseAtoms()), IQ2CQ.toDataAtoms(assertion.getDatabaseAtoms()))).filter(ImmutableHomomorphismIterator::hasNext).map(ImmutableHomomorphismIterator::next);
                if (to.isPresent() && (current.getConditions().isEmpty() || current.getConditions().size() == 1 && assertion.getConditions().size() == 1 && ((ImmutableList)current.getConditions().get(0)).stream().map(atom -> ((ImmutableHomomorphism)to.get()).applyToBooleanExpression(atom, this.termFactory)).allMatch(atom -> ((ImmutableList)assertion.getConditions().get(0)).contains(atom)))) {
                    if (assertion.getDatabaseAtoms().size() < current.getDatabaseAtoms().size()) {
                        couldIgnore = true;
                    } else {
                        return;
                    }
                }
                if ((from = this.fixHeadTermMapping(assertion.getHeadTerms(), current.getHeadTerms()).map(h -> this.cqc.homomorphismIterator(h, IQ2CQ.toDataAtoms(assertion.getDatabaseAtoms()), IQ2CQ.toDataAtoms(current.getDatabaseAtoms()))).filter(ImmutableHomomorphismIterator::hasNext).map(ImmutableHomomorphismIterator::next)).isPresent() && (assertion.getConditions().isEmpty() || assertion.getConditions().size() == 1 && current.getConditions().size() == 1 && ((ImmutableList)assertion.getConditions().get(0)).stream().map(atom -> ((ImmutableHomomorphism)from.get()).applyToBooleanExpression(atom, this.termFactory)).allMatch(atom -> ((ImmutableList)current.getConditions().get(0)).contains(atom)))) {
                    mappingIterator.remove();
                    continue;
                }
                if (couldIgnore) {
                    return;
                }
                if (!to.isPresent() || !from.isPresent()) continue;
                ImmutableList newf = (ImmutableList)((ImmutableList)assertion.getConditions().get(0)).stream().map(atom -> ((ImmutableHomomorphism)from.get()).applyToBooleanExpression(atom, this.termFactory)).collect(ImmutableCollectors.toList());
                if (current.getConditions().stream().anyMatch(f -> newf.containsAll((Collection)f))) {
                    return;
                }
                mappingIterator.remove();
                this.rules.add(new TMappingRule(current, (ImmutableList<ImmutableList<ImmutableExpression>>)((ImmutableList)Stream.concat(current.getConditions().stream().filter(f -> !f.containsAll((Collection)newf)), Stream.of(newf)).collect(ImmutableCollectors.toList()))));
                return;
            }
            this.rules.add(assertion);
        }

        private Optional<ImmutableHomomorphism> fixHeadTermMapping(ImmutableList<ImmutableTerm> fromHead, ImmutableList<ImmutableTerm> toHead) {
            ImmutableHomomorphism.Builder builder = ImmutableHomomorphism.builder();
            for (int i = 0; i < fromHead.size(); ++i) {
                if (builder.extend((ImmutableTerm)fromHead.get(i), (ImmutableTerm)toHead.get(i)).isValid()) continue;
                return Optional.empty();
            }
            return Optional.of(builder.build());
        }
    }
}

