/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.transformer.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.injection.QueryTransformerFactory;
import it.unibz.inf.ontop.injection.SpecificationFactory;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.transform.QueryRenamer;
import it.unibz.inf.ontop.model.atom.RDFAtomPredicate;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.spec.mapping.Mapping;
import it.unibz.inf.ontop.spec.mapping.transformer.MappingVariableNameNormalizer;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.rdf.api.IRI;

@Singleton
public class MappingVariableNameNormalizerImpl
implements MappingVariableNameNormalizer {
    private final SpecificationFactory specificationFactory;
    private final QueryTransformerFactory transformerFactory;
    private final SubstitutionFactory substitutionFactory;
    private final TermFactory termFactory;

    @Inject
    private MappingVariableNameNormalizerImpl(SpecificationFactory specificationFactory, QueryTransformerFactory transformerFactory, SubstitutionFactory substitutionFactory, TermFactory termFactory) {
        this.specificationFactory = specificationFactory;
        this.transformerFactory = transformerFactory;
        this.substitutionFactory = substitutionFactory;
        this.termFactory = termFactory;
    }

    @Override
    public Mapping normalize(Mapping mapping) {
        AtomicInteger i = new AtomicInteger(0);
        ImmutableTable<RDFAtomPredicate, IRI, IQ> newPropertyTable = this.normalize((ImmutableSet<Table.Cell<RDFAtomPredicate, IRI, IQ>>)mapping.getRDFPropertyQueries(), i);
        ImmutableTable<RDFAtomPredicate, IRI, IQ> newClassTable = this.normalize((ImmutableSet<Table.Cell<RDFAtomPredicate, IRI, IQ>>)mapping.getRDFClassQueries(), i);
        return this.specificationFactory.createMapping(mapping.getMetadata(), newPropertyTable, newClassTable);
    }

    private ImmutableTable<RDFAtomPredicate, IRI, IQ> normalize(ImmutableSet<Table.Cell<RDFAtomPredicate, IRI, IQ>> queryCells, AtomicInteger i) {
        return (ImmutableTable)queryCells.stream().map(c -> Tables.immutableCell((Object)c.getRowKey(), (Object)c.getColumnKey(), (Object)this.appendSuffixToVariableNames((IQ)c.getValue(), i.incrementAndGet()))).collect(ImmutableCollectors.toTable());
    }

    private IQ appendSuffixToVariableNames(IQ query, int suffix) {
        Map<Variable, Variable> substitutionMap = query.getTree().getKnownVariables().stream().collect(Collectors.toMap(v -> v, v -> this.termFactory.getVariable(v.getName() + "m" + suffix)));
        QueryRenamer queryRenamer = this.transformerFactory.createRenamer(this.substitutionFactory.getInjectiveVar2VarSubstitution(substitutionMap));
        return queryRenamer.transform(query);
    }
}

