/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.transformer.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Tables;
import com.google.inject.Inject;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.injection.OntopMappingSettings;
import it.unibz.inf.ontop.injection.QueryTransformerFactory;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.tools.UnionBasedQueryMerger;
import it.unibz.inf.ontop.iq.transform.QueryRenamer;
import it.unibz.inf.ontop.model.atom.AtomFactory;
import it.unibz.inf.ontop.model.atom.AtomPredicate;
import it.unibz.inf.ontop.model.atom.DistinctVariableOnlyDataAtom;
import it.unibz.inf.ontop.model.atom.RDFAtomPredicate;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.vocabulary.OWL;
import it.unibz.inf.ontop.spec.mapping.Mapping;
import it.unibz.inf.ontop.spec.mapping.transformer.MappingSameAsInverseRewriter;
import it.unibz.inf.ontop.substitution.InjectiveVar2VarSubstitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Stream;

public class MappingSameAsInverseRewriterImpl
implements MappingSameAsInverseRewriter {
    private final AtomFactory atomFactory;
    private final IntermediateQueryFactory iqFactory;
    private final QueryTransformerFactory transformerFactory;
    private final SubstitutionFactory substitutionFactory;
    private final UnionBasedQueryMerger queryMerger;
    private final boolean enabled;

    @Inject
    private MappingSameAsInverseRewriterImpl(AtomFactory atomFactory, IntermediateQueryFactory iqFactory, QueryTransformerFactory transformerFactory, SubstitutionFactory substitutionFactory, UnionBasedQueryMerger queryMerger, OntopMappingSettings settings) {
        this.atomFactory = atomFactory;
        this.iqFactory = iqFactory;
        this.transformerFactory = transformerFactory;
        this.substitutionFactory = substitutionFactory;
        this.queryMerger = queryMerger;
        this.enabled = settings.isSameAsInMappingsEnabled();
    }

    @Override
    public Mapping rewrite(Mapping mapping) {
        if (!this.enabled) {
            return mapping;
        }
        ImmutableTable mappingUpdate = (ImmutableTable)mapping.getRDFAtomPredicates().stream().flatMap(p -> mapping.getRDFPropertyDefinition(p, OWL.SAME_AS).map(sameAsDef -> this.completeSameAsDefinition((IQ)sameAsDef, (RDFAtomPredicate)p)).map(sameAsDef -> Tables.immutableCell((Object)p, (Object)OWL.SAME_AS, (Object)sameAsDef)).map(Stream::of).orElseGet(Stream::empty)).collect(ImmutableCollectors.toTable());
        return mapping.update(mappingUpdate, ImmutableTable.of());
    }

    private IQ completeSameAsDefinition(IQ originalDefinition, RDFAtomPredicate rdfAtomPredicate) {
        ImmutableList originalProjectedVariables = originalDefinition.getProjectionAtom().getArguments();
        Variable originalSubject = (Variable)rdfAtomPredicate.getSubject(originalProjectedVariables);
        Variable originalObject = (Variable)rdfAtomPredicate.getObject(originalProjectedVariables);
        VariableGenerator originalVariableGenerator = originalDefinition.getVariableGenerator();
        Variable newSubject = originalVariableGenerator.generateNewVariableFromVar(originalSubject);
        Variable newObject = originalVariableGenerator.generateNewVariableFromVar(originalObject);
        DistinctVariableOnlyDataAtom newProjectionAtom = this.atomFactory.getDistinctVariableOnlyDataAtom((AtomPredicate)rdfAtomPredicate, rdfAtomPredicate.updateSO(originalProjectedVariables, (ImmutableTerm)newSubject, (ImmutableTerm)newObject));
        InjectiveVar2VarSubstitution renamingSubstitution = this.substitutionFactory.getInjectiveVar2VarSubstitution((Map)ImmutableMap.of((Object)originalSubject, (Object)newObject, (Object)originalObject, (Object)newSubject));
        QueryRenamer queryRenamer = this.transformerFactory.createRenamer(renamingSubstitution);
        IQ inversedDefinition = this.iqFactory.createIQ(newProjectionAtom, queryRenamer.transform(originalDefinition).getTree());
        return ((IQ)this.queryMerger.mergeDefinitions((Collection)ImmutableList.of((Object)originalDefinition, (Object)inversedDefinition)).get()).normalizeForOptimization();
    }
}

