/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.transformer.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.google.inject.Inject;
import it.unibz.inf.ontop.exception.MappingMergingException;
import it.unibz.inf.ontop.injection.SpecificationFactory;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.tools.UnionBasedQueryMerger;
import it.unibz.inf.ontop.model.atom.RDFAtomPredicate;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.spec.mapping.Mapping;
import it.unibz.inf.ontop.spec.mapping.MappingMetadata;
import it.unibz.inf.ontop.spec.mapping.PrefixManager;
import it.unibz.inf.ontop.spec.mapping.impl.SimplePrefixManager;
import it.unibz.inf.ontop.spec.mapping.transformer.MappingMerger;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.commons.rdf.api.IRI;

public class MappingMergerImpl
implements MappingMerger {
    private final SpecificationFactory specificationFactory;
    private final UnionBasedQueryMerger queryMerger;
    private final TermFactory termFactory;

    @Inject
    private MappingMergerImpl(SpecificationFactory specificationFactory, UnionBasedQueryMerger queryMerger, TermFactory termFactory) {
        this.specificationFactory = specificationFactory;
        this.queryMerger = queryMerger;
        this.termFactory = termFactory;
    }

    @Override
    public Mapping merge(Mapping ... mappings) {
        return this.merge((ImmutableSet<Mapping>)ImmutableSet.copyOf((Object[])mappings));
    }

    @Override
    public Mapping merge(ImmutableSet<Mapping> mappings) {
        if (mappings.isEmpty()) {
            throw new IllegalArgumentException("The set of mappings is assumed to be nonempty");
        }
        MappingMetadata metadata = this.mergeMetadata(mappings);
        ImmutableTable<RDFAtomPredicate, IRI, IQ> propertyTable = this.mergeMappingPropertyTables(mappings);
        ImmutableTable<RDFAtomPredicate, IRI, IQ> classTable = this.mergeMappingClassTables(mappings);
        return this.specificationFactory.createMapping(metadata, propertyTable, classTable);
    }

    private MappingMetadata mergeMetadata(ImmutableSet<Mapping> mappings) {
        PrefixManager prefixManager = this.mergePrefixManagers(mappings);
        return this.specificationFactory.createMetadata(prefixManager);
    }

    private PrefixManager mergePrefixManagers(ImmutableSet<Mapping> mappings) {
        ImmutableMap prefixToUris = ((ImmutableMultimap)mappings.stream().flatMap(m -> m.getMetadata().getPrefixManager().getPrefixMap().entrySet().stream()).collect(ImmutableCollectors.toMultimap())).asMap();
        ImmutableMap prefixToUri = (ImmutableMap)prefixToUris.entrySet().stream().collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> this.flattenURIList((String)e.getKey(), (Collection)e.getValue())));
        return new SimplePrefixManager(prefixToUri);
    }

    private String flattenURIList(String prefix, Collection<String> uris) {
        if (ImmutableSet.copyOf(uris).size() == 1) {
            return uris.iterator().next();
        }
        throw new MappingMergingException("Conflicting URIs for prefix " + prefix + ": " + uris);
    }

    private ImmutableTable<RDFAtomPredicate, IRI, IQ> mergeMappingPropertyTables(ImmutableSet<Mapping> mappings) {
        ImmutableMap multiTable = ((ImmutableMultimap)mappings.stream().flatMap(m -> this.extractCellStream((Mapping)m, p -> m.getRDFProperties(p).stream(), (p, i) -> (IQ)m.getRDFPropertyDefinition(p, i).get())).collect(ImmutableCollectors.toMultimap(c -> Maps.immutableEntry((Object)c.getRowKey(), (Object)c.getColumnKey()), Table.Cell::getValue))).asMap();
        return (ImmutableTable)multiTable.entrySet().stream().map(e -> Tables.immutableCell(((Map.Entry)e.getKey()).getKey(), ((Map.Entry)e.getKey()).getValue(), (Object)this.mergeDefinitions((Collection)e.getValue()))).collect(ImmutableCollectors.toTable());
    }

    private Stream<Table.Cell<RDFAtomPredicate, IRI, IQ>> extractCellStream(Mapping m, Function<RDFAtomPredicate, Stream<IRI>> iriExtractor, BiFunction<RDFAtomPredicate, IRI, IQ> iqExtractor) {
        return m.getRDFAtomPredicates().stream().flatMap(p -> ((Stream)iriExtractor.apply((RDFAtomPredicate)p)).map(i -> Tables.immutableCell((Object)p, (Object)i, iqExtractor.apply((RDFAtomPredicate)p, (IRI)i))));
    }

    private ImmutableTable<RDFAtomPredicate, IRI, IQ> mergeMappingClassTables(ImmutableSet<Mapping> mappings) {
        ImmutableMap multiTable = ((ImmutableMultimap)mappings.stream().flatMap(m -> this.extractCellStream((Mapping)m, p -> m.getRDFClasses(p).stream(), (p, i) -> (IQ)m.getRDFClassDefinition(p, i).get())).collect(ImmutableCollectors.toMultimap(c -> Maps.immutableEntry((Object)c.getRowKey(), (Object)c.getColumnKey()), Table.Cell::getValue))).asMap();
        return (ImmutableTable)multiTable.entrySet().stream().map(e -> Tables.immutableCell(((Map.Entry)e.getKey()).getKey(), ((Map.Entry)e.getKey()).getValue(), (Object)this.mergeDefinitions((Collection)e.getValue()))).collect(ImmutableCollectors.toTable());
    }

    private IQ mergeDefinitions(Collection<IQ> queries) {
        return (IQ)this.queryMerger.mergeDefinitions(queries).orElseThrow(() -> new MappingMergingException("The query should be present"));
    }
}

