/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.transformer.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.google.inject.Inject;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.injection.SpecificationFactory;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.DistinctNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.node.UnionNode;
import it.unibz.inf.ontop.model.atom.RDFAtomPredicate;
import it.unibz.inf.ontop.spec.mapping.Mapping;
import it.unibz.inf.ontop.spec.mapping.transformer.MappingDistinctTransformer;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Optional;
import org.apache.commons.rdf.api.IRI;

public class MappingDistinctTransformerImpl
implements MappingDistinctTransformer {
    private final SpecificationFactory specificationFactory;
    private final IntermediateQueryFactory iqFactory;

    @Inject
    private MappingDistinctTransformerImpl(SpecificationFactory specificationFactory, IntermediateQueryFactory iqFactory) {
        this.specificationFactory = specificationFactory;
        this.iqFactory = iqFactory;
    }

    @Override
    public Mapping addDistinct(Mapping mapping) {
        return this.specificationFactory.createMapping(mapping.getMetadata(), this.updateQueries((ImmutableSet<Table.Cell<RDFAtomPredicate, IRI, IQ>>)mapping.getRDFPropertyQueries()), this.updateQueries((ImmutableSet<Table.Cell<RDFAtomPredicate, IRI, IQ>>)mapping.getRDFClassQueries()));
    }

    private ImmutableTable<RDFAtomPredicate, IRI, IQ> updateQueries(ImmutableSet<Table.Cell<RDFAtomPredicate, IRI, IQ>> entry) {
        return (ImmutableTable)entry.stream().map(e -> Tables.immutableCell((Object)e.getRowKey(), (Object)e.getColumnKey(), (Object)this.updateQuery((IQ)e.getValue()))).collect(ImmutableCollectors.toTable());
    }

    private IQ updateQuery(IQ query) {
        VariableGenerator variableGenerator = query.getVariableGenerator();
        IQTree distinctTree = this.iqFactory.createUnaryIQTree((UnaryOperatorNode)this.iqFactory.createDistinctNode(), query.getTree()).normalizeForOptimization(variableGenerator);
        Optional<ConstructionNode> topConstructionNode = Optional.of(distinctTree.getRootNode()).filter(n -> n instanceof ConstructionNode).map(n -> (ConstructionNode)n);
        Optional<IQTree> distinctUnionTree = topConstructionNode.map(n -> ((UnaryIQTree)distinctTree).getChild()).filter(t -> t.getRootNode() instanceof DistinctNode).map(t -> ((UnaryIQTree)t).getChild()).filter(t -> t.getRootNode() instanceof UnionNode).map(t -> ((UnionNode)t.getRootNode()).makeDistinct(t.getChildren()));
        IQTree newTree = distinctUnionTree.map(t -> this.iqFactory.createUnaryIQTree((UnaryOperatorNode)topConstructionNode.get(), t)).map(t -> t.normalizeForOptimization(variableGenerator)).orElse(distinctTree);
        return this.iqFactory.createIQ(query.getProjectionAtom(), newTree);
    }
}

