/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.transformer.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import it.unibz.inf.ontop.exception.OntopInternalBugException;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.injection.OntopMappingSettings;
import it.unibz.inf.ontop.injection.ProvenanceMappingFactory;
import it.unibz.inf.ontop.injection.QueryTransformerFactory;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.node.IntensionalDataNode;
import it.unibz.inf.ontop.iq.node.NaryOperatorNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.optimizer.impl.AbstractIntensionalQueryMerger;
import it.unibz.inf.ontop.iq.tools.UnionBasedQueryMerger;
import it.unibz.inf.ontop.model.atom.AtomFactory;
import it.unibz.inf.ontop.model.atom.AtomPredicate;
import it.unibz.inf.ontop.model.atom.DataAtom;
import it.unibz.inf.ontop.model.atom.DistinctVariableOnlyDataAtom;
import it.unibz.inf.ontop.model.atom.RDFAtomPredicate;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.model.vocabulary.Ontop;
import it.unibz.inf.ontop.spec.mapping.MappingWithProvenance;
import it.unibz.inf.ontop.spec.mapping.pp.PPMappingAssertionProvenance;
import it.unibz.inf.ontop.spec.mapping.transformer.MappingCanonicalTransformer;
import it.unibz.inf.ontop.spec.mapping.utils.MappingTools;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.CoreUtilsFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.rdf.api.IRI;

public class MappingCanonicalTransformerImpl
implements MappingCanonicalTransformer {
    private final IntermediateQueryFactory iqFactory;
    private final ProvenanceMappingFactory provenanceMappingFactory;
    private final QueryTransformerFactory transformerFactory;
    private final SubstitutionFactory substitutionFactory;
    private final AtomFactory atomFactory;
    private final UnionBasedQueryMerger queryMerger;
    private final CoreUtilsFactory coreUtilsFactory;
    private final OntopMappingSettings settings;

    @Inject
    private MappingCanonicalTransformerImpl(IntermediateQueryFactory iqFactory, ProvenanceMappingFactory provenanceMappingFactory, QueryTransformerFactory transformerFactory, SubstitutionFactory substitutionFactory, AtomFactory atomFactory, CoreUtilsFactory coreUtilsFactory, UnionBasedQueryMerger queryMerger, OntopMappingSettings settings) {
        this.coreUtilsFactory = coreUtilsFactory;
        this.settings = settings;
        this.iqFactory = iqFactory;
        this.provenanceMappingFactory = provenanceMappingFactory;
        this.transformerFactory = transformerFactory;
        this.substitutionFactory = substitutionFactory;
        this.atomFactory = atomFactory;
        this.queryMerger = queryMerger;
    }

    @Override
    public MappingWithProvenance transform(MappingWithProvenance mapping) {
        Optional<IQ> canIRIDefinition = this.extractCanIRIDefinition(mapping);
        return canIRIDefinition.isPresent() ? this.transformMapping(mapping, new IntensionalQueryMerger(canIRIDefinition.get())) : mapping;
    }

    private Optional<IQ> extractCanIRIDefinition(MappingWithProvenance mapping) {
        return this.queryMerger.mergeDefinitions((Collection)mapping.getProvenanceMap().keySet().stream().filter(q -> MappingTools.extractRDFPredicate(q).getIri().equals((Object)Ontop.CANONICAL_IRI)).collect(ImmutableCollectors.toList()));
    }

    private MappingWithProvenance transformMapping(MappingWithProvenance mapping, IntensionalQueryMerger intensionalQueryMerger) {
        return this.provenanceMappingFactory.create((ImmutableMap<IQ, PPMappingAssertionProvenance>)((ImmutableMap)mapping.getProvenanceMap().entrySet().stream().filter(e -> !MappingTools.extractRDFPredicate((IQ)e.getKey()).getIri().equals((Object)Ontop.CANONICAL_IRI)).collect(ImmutableCollectors.toMap(e -> this.transformAssertion((IQ)e.getKey(), intensionalQueryMerger), Map.Entry::getValue))), mapping.getMetadata());
    }

    private IQ transformAssertion(IQ assertion, IntensionalQueryMerger intensionalQueryMerger) {
        return this.settings.isCanIRIComplete() ? this.transformAssertionWithJoin(assertion, intensionalQueryMerger) : this.transformAssertionWithLeftJoin(assertion, intensionalQueryMerger);
    }

    private IQ transformAssertionWithLeftJoin(IQ assertion, IntensionalQueryMerger intensionalQueryMerger) {
        throw new RuntimeException("TODO: implement");
    }

    private IQ transformAssertionWithJoin(IQ assertion, IntensionalQueryMerger intensionalQueryMerger) {
        IQ assertionWithCanonizedSubject = this.canonizeWithJoin(assertion, intensionalQueryMerger, Position.SUBJECT);
        return this.canonizeWithJoin(assertionWithCanonizedSubject, intensionalQueryMerger, Position.OBJECT);
    }

    private IQ canonizeWithJoin(IQ assertion, IntensionalQueryMerger intensionalQueryMerger, Position pos) {
        Optional<Variable> replacedVar = this.getReplacedVar(assertion, pos);
        if (replacedVar.isPresent()) {
            Variable newVariable = this.createFreshVariable(assertion, intensionalQueryMerger, replacedVar.get());
            IntensionalDataNode idn = this.getIDN(replacedVar.get(), newVariable);
            RDFAtomPredicate pred = this.getRDFAtomPredicate((DataAtom)assertion.getProjectionAtom());
            DistinctVariableOnlyDataAtom projAtom = this.atomFactory.getDistinctVariableOnlyDataAtom((AtomPredicate)pred, this.replaceProjVars(pred, (ImmutableList<Variable>)assertion.getProjectionAtom().getArguments(), pos, newVariable));
            IQ intensionalCanonizedQuery = this.iqFactory.createIQ(projAtom, this.getIntensionalCanonizedTree(assertion, projAtom, idn));
            IQ canonizedQuery = intensionalQueryMerger.optimize(intensionalCanonizedQuery).normalizeForOptimization();
            return canonizedQuery.getTree().isDeclaredAsEmpty() ? assertion : canonizedQuery;
        }
        return assertion;
    }

    private IQTree getIntensionalCanonizedTree(IQ assertion, DistinctVariableOnlyDataAtom projAtom, IntensionalDataNode intensionalDataNode) {
        return this.iqFactory.createUnaryIQTree((UnaryOperatorNode)this.iqFactory.createConstructionNode(projAtom.getVariables()), (IQTree)this.iqFactory.createNaryIQTree((NaryOperatorNode)this.iqFactory.createInnerJoinNode(), ImmutableList.of((Object)assertion.getTree(), (Object)intensionalDataNode)));
    }

    private Variable createFreshVariable(IQ assertion, IntensionalQueryMerger intensionalQueryMerger, Variable formerVariable) {
        VariableGenerator variableGenerator = this.coreUtilsFactory.createVariableGenerator((Collection)Sets.union((Set)assertion.getTree().getKnownVariables(), intensionalQueryMerger.getKnownVariables()).immutableCopy());
        return variableGenerator.generateNewVariableFromVar(formerVariable);
    }

    private IntensionalDataNode getIDN(Variable formerVariable, Variable newVariable) {
        return this.iqFactory.createIntensionalDataNode(this.atomFactory.getIntensionalTripleAtom((VariableOrGroundTerm)newVariable, Ontop.CANONICAL_IRI, (VariableOrGroundTerm)formerVariable));
    }

    private Optional<Variable> getReplacedVar(IQ assertion, Position pos) {
        switch (pos) {
            case SUBJECT: {
                return Optional.of(this.getVarFromRDFAtom(assertion.getProjectionAtom(), pos));
            }
            case OBJECT: {
                return MappingTools.extractRDFPredicate(assertion).isClass() ? Optional.empty() : Optional.of(this.getVarFromRDFAtom(assertion.getProjectionAtom(), pos));
            }
        }
        throw new UnexpectedPositionException(pos);
    }

    private ImmutableList<Variable> replaceProjVars(RDFAtomPredicate pred, ImmutableList<Variable> arguments, Position pos, Variable replacementVar) {
        switch (pos) {
            case SUBJECT: {
                return pred.updateSubject(arguments, (ImmutableTerm)replacementVar);
            }
            case OBJECT: {
                return pred.updateObject(arguments, (ImmutableTerm)replacementVar);
            }
        }
        throw new UnexpectedPositionException(pos);
    }

    private Optional<IRI> getPropertyIRI(DataAtom atom) {
        AtomPredicate atomPredicate = atom.getPredicate();
        return Optional.of(atomPredicate).filter(p -> p instanceof RDFAtomPredicate).map(p -> (RDFAtomPredicate)p).flatMap(p -> p.getPropertyIRI(atom.getArguments()));
    }

    private Variable getVarFromRDFAtom(DistinctVariableOnlyDataAtom atom, Position position) {
        switch (position) {
            case SUBJECT: {
                return (Variable)this.getRDFAtomPredicate((DataAtom)atom).getSubject(atom.getArguments());
            }
            case OBJECT: {
                return (Variable)this.getRDFAtomPredicate((DataAtom)atom).getObject(atom.getArguments());
            }
            case PROPERTY: {
                return (Variable)this.getRDFAtomPredicate((DataAtom)atom).getProperty(atom.getArguments());
            }
        }
        throw new UnexpectedPositionException(position);
    }

    private RDFAtomPredicate getRDFAtomPredicate(DataAtom atom) {
        return Optional.of(atom.getPredicate()).filter(p -> p instanceof RDFAtomPredicate).map(p -> (RDFAtomPredicate)p).orElseThrow(() -> new CanonicalTransformerException(RDFAtomPredicate.class.getName() + " expected"));
    }

    private class IntensionalQueryMerger
    extends AbstractIntensionalQueryMerger {
        private final IQ definition;

        IntensionalQueryMerger(IQ definition) {
            super(MappingCanonicalTransformerImpl.this.iqFactory);
            this.definition = definition;
        }

        protected AbstractIntensionalQueryMerger.QueryMergingTransformer createTransformer(ImmutableSet<Variable> knownVariables) {
            VariableGenerator variableGenerator = MappingCanonicalTransformerImpl.this.coreUtilsFactory.createVariableGenerator(knownVariables);
            return new QueryMergingTransformer(variableGenerator);
        }

        public ImmutableSet<Variable> getKnownVariables() {
            return this.definition.getTree().getKnownVariables();
        }

        private class UnexpectedPredicateException
        extends OntopInternalBugException {
            UnexpectedPredicateException(AtomPredicate predicate) {
                super("canonical IRI predicate expected instead of :" + predicate);
            }
        }

        private class QueryMergingTransformer
        extends AbstractIntensionalQueryMerger.QueryMergingTransformer {
            QueryMergingTransformer(VariableGenerator variableGenerator) {
                super(variableGenerator, MappingCanonicalTransformerImpl.this.iqFactory, MappingCanonicalTransformerImpl.this.substitutionFactory, MappingCanonicalTransformerImpl.this.transformerFactory);
            }

            protected Optional<IQ> getDefinition(IntensionalDataNode dataNode) {
                if (MappingCanonicalTransformerImpl.this.getPropertyIRI(dataNode.getProjectionAtom()).filter(i -> i.equals((Object)Ontop.CANONICAL_IRI)).isPresent()) {
                    return Optional.of(IntensionalQueryMerger.this.definition);
                }
                throw new UnexpectedPredicateException(dataNode.getProjectionAtom().getPredicate());
            }

            protected IQTree handleIntensionalWithoutDefinition(IntensionalDataNode dataNode) {
                return dataNode;
            }
        }
    }

    private class UnexpectedPositionException
    extends CanonicalTransformerException {
        UnexpectedPositionException(Position pos) {
            super("Unexpected position: " + (Object)((Object)pos));
        }
    }

    private class CanonicalTransformerException
    extends OntopInternalBugException {
        CanonicalTransformerException(String text) {
            super(text);
        }
    }

    private static enum Position {
        SUBJECT,
        PROPERTY,
        OBJECT;

    }
}

