/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.transformer.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import it.unibz.inf.ontop.constraints.ImmutableCQ;
import it.unibz.inf.ontop.constraints.ImmutableCQContainmentCheck;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.ExtensionalDataNode;
import it.unibz.inf.ontop.iq.node.InnerJoinNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.model.atom.RelationPredicate;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.spec.mapping.transformer.MappingCQCOptimizer;
import it.unibz.inf.ontop.spec.mapping.transformer.impl.FilterAbsorber;
import it.unibz.inf.ontop.spec.mapping.transformer.impl.IQ2CQ;
import it.unibz.inf.ontop.spec.mapping.transformer.impl.InnerJoinFlattener;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;

public class MappingCQCOptimizerImpl
implements MappingCQCOptimizer {
    private final IntermediateQueryFactory iqFactory;
    private final TermFactory termFactory;

    @Inject
    public MappingCQCOptimizerImpl(IntermediateQueryFactory iqFactory, TermFactory termFactory) {
        this.iqFactory = iqFactory;
        this.termFactory = termFactory;
    }

    @Override
    public IQ optimize(ImmutableCQContainmentCheck<RelationPredicate> cqContainmentCheck, IQ query) {
        IQTree tree0 = new FilterAbsorber(this.iqFactory, this.termFactory).apply(query.getTree());
        IQTree tree = new InnerJoinFlattener(this.iqFactory, this.termFactory).apply(tree0);
        if (tree.getRootNode() instanceof ConstructionNode && tree.getChildren().size() == 1) {
            ConstructionNode constructionNode = (ConstructionNode)tree.getRootNode();
            IQTree joinTree = (IQTree)tree.getChildren().get(0);
            Optional<ImmutableList<ExtensionalDataNode>> c = IQ2CQ.getExtensionalDataNodes(joinTree);
            if (c.isPresent() && c.get().size() > 1) {
                InnerJoinNode joinNode = (InnerJoinNode)joinTree.getRootNode();
                ImmutableList answerVariables = (ImmutableList)Stream.concat(constructionNode.getSubstitution().getImmutableMap().values().stream().flatMap(ImmutableTerm::getVariableStream), joinNode.getOptionalFilterCondition().map(ImmutableTerm::getVariableStream).orElse(Stream.of(new Variable[0]))).distinct().collect(ImmutableCollectors.toList());
                ImmutableList children = c.get();
                int currentIndex = 0;
                while (currentIndex < children.size()) {
                    ImmutableList.Builder builder = ImmutableList.builder();
                    for (int i = 0; i < children.size(); ++i) {
                        if (i == currentIndex) continue;
                        builder.add(children.get(i));
                    }
                    ImmutableList subChildren = builder.build();
                    if (((ImmutableSet)subChildren.stream().flatMap(a -> a.getVariables().stream()).collect(ImmutableCollectors.toSet())).containsAll((Collection)answerVariables)) {
                        if (cqContainmentCheck.isContainedIn(new ImmutableCQ(answerVariables, IQ2CQ.toDataAtoms((ImmutableList<? extends IQTree>)subChildren)), new ImmutableCQ(answerVariables, IQ2CQ.toDataAtoms(children)))) {
                            children = subChildren;
                            if (children.size() < 2) break;
                            currentIndex = 0;
                            continue;
                        }
                        ++currentIndex;
                        continue;
                    }
                    ++currentIndex;
                }
                return this.iqFactory.createIQ(query.getProjectionAtom(), (IQTree)this.iqFactory.createUnaryIQTree((UnaryOperatorNode)((ConstructionNode)tree.getRootNode()), IQ2CQ.toIQTree(children, joinNode.getOptionalFilterCondition(), this.iqFactory)));
            }
        }
        return this.iqFactory.createIQ(query.getProjectionAtom(), tree);
    }
}

