/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.transformer.impl;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.constraints.LinearInclusionDependencies;
import it.unibz.inf.ontop.constraints.impl.ImmutableCQContainmentCheckUnderLIDs;
import it.unibz.inf.ontop.dbschema.DBMetadata;
import it.unibz.inf.ontop.dbschema.DatabaseRelationDefinition;
import it.unibz.inf.ontop.dbschema.ForeignKeyConstraint;
import it.unibz.inf.ontop.model.atom.AtomFactory;
import it.unibz.inf.ontop.model.atom.AtomPredicate;
import it.unibz.inf.ontop.model.atom.DataAtom;
import it.unibz.inf.ontop.model.atom.RelationPredicate;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.spec.mapping.Mapping;
import it.unibz.inf.ontop.spec.mapping.TMappingExclusionConfig;
import it.unibz.inf.ontop.spec.mapping.transformer.MappingSaturator;
import it.unibz.inf.ontop.spec.mapping.transformer.impl.TMappingProcessor;
import it.unibz.inf.ontop.spec.ontology.ClassifiedTBox;
import it.unibz.inf.ontop.utils.CoreUtilsFactory;
import java.util.Collection;

@Singleton
public class LegacyMappingSaturator
implements MappingSaturator {
    private final TMappingExclusionConfig tMappingExclusionConfig;
    private final TermFactory termFactory;
    private final TMappingProcessor tMappingProcessor;
    private final AtomFactory atomFactory;
    private final CoreUtilsFactory coreUtilsFactory;

    @Inject
    private LegacyMappingSaturator(TMappingExclusionConfig tMappingExclusionConfig, TermFactory termFactory, TMappingProcessor tMappingProcessor, AtomFactory atomFactory, CoreUtilsFactory coreUtilsFactory) {
        this.tMappingExclusionConfig = tMappingExclusionConfig;
        this.termFactory = termFactory;
        this.tMappingProcessor = tMappingProcessor;
        this.atomFactory = atomFactory;
        this.coreUtilsFactory = coreUtilsFactory;
    }

    @Override
    public Mapping saturate(Mapping mapping, DBMetadata dbMetadata, ClassifiedTBox saturatedTBox) {
        LinearInclusionDependencies.Builder b = LinearInclusionDependencies.builder((CoreUtilsFactory)this.coreUtilsFactory, (AtomFactory)this.atomFactory);
        dbMetadata.getDatabaseRelations().stream().map(DatabaseRelationDefinition::getForeignKeys).flatMap(Collection::stream).forEach(fk -> this.getLinearInclusionDependency((LinearInclusionDependencies.Builder<RelationPredicate>)b, (ForeignKeyConstraint)fk));
        LinearInclusionDependencies lids = b.build();
        ImmutableCQContainmentCheckUnderLIDs cqContainmentCheck = new ImmutableCQContainmentCheckUnderLIDs(lids);
        return this.tMappingProcessor.getTMappings(mapping, saturatedTBox, this.tMappingExclusionConfig, (ImmutableCQContainmentCheckUnderLIDs<RelationPredicate>)cqContainmentCheck);
    }

    private void getLinearInclusionDependency(LinearInclusionDependencies.Builder<RelationPredicate> b, ForeignKeyConstraint fk) {
        DatabaseRelationDefinition def1 = fk.getRelation();
        Object[] terms1 = new VariableOrGroundTerm[def1.getAttributes().size()];
        for (int i = 0; i < terms1.length; ++i) {
            terms1[i] = this.termFactory.getVariable("t" + i);
        }
        DatabaseRelationDefinition def2 = fk.getReferencedRelation();
        Object[] terms2 = new VariableOrGroundTerm[def2.getAttributes().size()];
        for (int i = 0; i < terms2.length; ++i) {
            terms2[i] = this.termFactory.getVariable("p" + i);
        }
        for (ForeignKeyConstraint.Component comp : fk.getComponents()) {
            terms1[comp.getAttribute().getIndex() - 1] = terms2[comp.getReference().getIndex() - 1];
        }
        DataAtom head = this.atomFactory.getDataAtom((AtomPredicate)def2.getAtomPredicate(), ImmutableList.copyOf((Object[])terms2));
        DataAtom body = this.atomFactory.getDataAtom((AtomPredicate)def1.getAtomPredicate(), ImmutableList.copyOf((Object[])terms1));
        b.add(head, body);
    }
}

