/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.transformer.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Tables;
import com.google.inject.Inject;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.injection.SpecificationFactory;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.tools.UnionBasedQueryMerger;
import it.unibz.inf.ontop.model.atom.AtomFactory;
import it.unibz.inf.ontop.model.atom.DistinctVariableOnlyDataAtom;
import it.unibz.inf.ontop.model.atom.RDFAtomPredicate;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.vocabulary.RDF;
import it.unibz.inf.ontop.spec.mapping.Mapping;
import it.unibz.inf.ontop.spec.mapping.transformer.ABoxFactIntoMappingConverter;
import it.unibz.inf.ontop.spec.mapping.utils.MappingTools;
import it.unibz.inf.ontop.spec.ontology.OntologyABox;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.CoreUtilsFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Collection;
import java.util.stream.Stream;
import org.apache.commons.rdf.api.IRI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyABoxFactIntoMappingConverter
implements ABoxFactIntoMappingConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(LegacyABoxFactIntoMappingConverter.class);
    private final SpecificationFactory mappingFactory;
    private final TermFactory termFactory;
    private final IntermediateQueryFactory iqFactory;
    private final UnionBasedQueryMerger queryMerger;
    private final SubstitutionFactory substitutionFactory;
    private final DistinctVariableOnlyDataAtom projectionAtom;

    @Inject
    public LegacyABoxFactIntoMappingConverter(SpecificationFactory mappingFactory, AtomFactory atomFactory, TermFactory termFactory, IntermediateQueryFactory iqFactory, UnionBasedQueryMerger queryMerger, CoreUtilsFactory coreUtilsFactory, SubstitutionFactory substitutionFactory) {
        this.mappingFactory = mappingFactory;
        this.termFactory = termFactory;
        this.iqFactory = iqFactory;
        this.queryMerger = queryMerger;
        this.substitutionFactory = substitutionFactory;
        VariableGenerator projectedVariableGenerator = coreUtilsFactory.createVariableGenerator((Collection)ImmutableSet.of());
        this.projectionAtom = atomFactory.getDistinctTripleAtom(projectedVariableGenerator.generateNewVariable(), projectedVariableGenerator.generateNewVariable(), projectedVariableGenerator.generateNewVariable());
    }

    @Override
    public Mapping convert(OntologyABox ontology, boolean isOntologyAnnotationQueryingEnabled) {
        ImmutableMultimap classes = (ImmutableMultimap)ontology.getClassAssertions().stream().collect(ImmutableCollectors.toMultimap(ca -> ca.getConcept().getIRI(), ca -> this.createFact((ImmutableTerm)ca.getIndividual(), this.getIRI(RDF.TYPE), this.getIRI(ca.getConcept().getIRI()))));
        ImmutableMultimap properties = (ImmutableMultimap)Stream.concat(Stream.concat(ontology.getObjectPropertyAssertions().stream().map(pa -> this.createFact((ImmutableTerm)pa.getSubject(), this.getIRI(pa.getProperty().getIRI()), (ImmutableTerm)pa.getObject())), ontology.getDataPropertyAssertions().stream().map(da -> this.createFact((ImmutableTerm)da.getSubject(), this.getIRI(da.getProperty().getIRI()), (ImmutableTerm)da.getValue()))), isOntologyAnnotationQueryingEnabled ? ontology.getAnnotationAssertions().stream().map(aa -> this.createFact((ImmutableTerm)aa.getSubject(), this.getIRI(aa.getProperty().getIRI()), (ImmutableTerm)aa.getValue())) : Stream.of(new IQ[0])).collect(ImmutableCollectors.toMultimap(iq -> MappingTools.extractRDFPredicate(iq).getIri(), iq -> iq));
        LOGGER.debug("Appended {} object property assertions as fact rules", (Object)ontology.getObjectPropertyAssertions().size());
        LOGGER.debug("Appended {} data property assertions as fact rules", (Object)ontology.getDataPropertyAssertions().size());
        LOGGER.debug("Appended {} annotation assertions as fact rules", (Object)ontology.getAnnotationAssertions().size());
        LOGGER.debug("Appended {} class assertions from ontology as fact rules", (Object)ontology.getClassAssertions().size());
        Mapping a = this.mappingFactory.createMapping(this.mappingFactory.createMetadata(this.mappingFactory.createPrefixManager(ImmutableMap.of())), this.getTableRepresentation((ImmutableMultimap<IRI, IQ>)properties), this.getTableRepresentation((ImmutableMultimap<IRI, IQ>)classes));
        return a;
    }

    private ImmutableTable<RDFAtomPredicate, IRI, IQ> getTableRepresentation(ImmutableMultimap<IRI, IQ> index) {
        return (ImmutableTable)index.asMap().entrySet().stream().map(e -> Tables.immutableCell((Object)((RDFAtomPredicate)this.projectionAtom.getPredicate()), e.getKey(), (Object)((IQ)this.queryMerger.mergeDefinitions((Collection)e.getValue()).get()).normalizeForOptimization())).collect(ImmutableCollectors.toTable());
    }

    private IQ createFact(ImmutableTerm subject, ImmutableTerm property, ImmutableTerm object) {
        ConstructionNode topConstructionNode = this.iqFactory.createConstructionNode(this.projectionAtom.getVariables(), this.substitutionFactory.getSubstitution(this.projectionAtom.getTerm(0), subject, this.projectionAtom.getTerm(1), property, this.projectionAtom.getTerm(2), object));
        UnaryIQTree constructionTree = this.iqFactory.createUnaryIQTree((UnaryOperatorNode)topConstructionNode, (IQTree)this.iqFactory.createTrueNode());
        return this.iqFactory.createIQ(this.projectionAtom, (IQTree)constructionTree);
    }

    private ImmutableTerm getIRI(IRI iri) {
        return this.termFactory.getConstantIRI(iri);
    }
}

