/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.transformer.impl;

import com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.node.InnerJoinNode;
import it.unibz.inf.ontop.iq.node.NaryOperatorNode;
import it.unibz.inf.ontop.iq.transform.IQTreeVisitingTransformer;
import it.unibz.inf.ontop.iq.transform.impl.LazyRecursiveIQTreeVisitingTransformer;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.spec.mapping.transformer.impl.IQ2CQ;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public class InnerJoinFlattener {
    private final IntermediateQueryFactory iqFactory;
    private final TermFactory termFactory;

    public InnerJoinFlattener(IntermediateQueryFactory iqFactory, TermFactory termFactory) {
        this.iqFactory = iqFactory;
        this.termFactory = termFactory;
    }

    public IQTree apply(IQTree tree) {
        return tree.acceptTransformer((IQTreeVisitingTransformer)new LazyRecursiveIQTreeVisitingTransformer(this.iqFactory){

            public IQTree transformInnerJoin(IQTree tree, InnerJoinNode rootNode, ImmutableList<IQTree> children) {
                ImmutableList childrenReplacement = this.transformChildren(children);
                ImmutableList newChildren = this.extractChildren(childrenReplacement);
                ImmutableList joinChildren = (ImmutableList)newChildren.stream().filter(c -> c.getRootNode() instanceof InnerJoinNode).collect(ImmutableCollectors.toList());
                if (!joinChildren.isEmpty()) {
                    ImmutableList filters = (ImmutableList)joinChildren.stream().map(c -> ((InnerJoinNode)c.getRootNode()).getOptionalFilterCondition()).filter(Optional::isPresent).map(Optional::get).collect(ImmutableCollectors.toList());
                    return this.iqFactory.createNaryIQTree((NaryOperatorNode)(filters.isEmpty() ? rootNode : this.iqFactory.createInnerJoinNode(IQ2CQ.getConjunction(rootNode.getOptionalFilterCondition(), (List<ImmutableExpression>)filters, InnerJoinFlattener.this.termFactory))), (ImmutableList)Stream.concat(newChildren.stream().filter(c -> !(c.getRootNode() instanceof InnerJoinNode)), joinChildren.stream().flatMap(c -> c.getChildren().stream())).collect(ImmutableCollectors.toList()));
                }
                return childrenReplacement.stream().allMatch(e -> e.getKey() == e.getValue()) ? tree : this.iqFactory.createNaryIQTree((NaryOperatorNode)rootNode, newChildren);
            }
        });
    }
}

