/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.transformer.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.node.DataNode;
import it.unibz.inf.ontop.iq.node.ExtensionalDataNode;
import it.unibz.inf.ontop.iq.node.FilterNode;
import it.unibz.inf.ontop.iq.node.InnerJoinNode;
import it.unibz.inf.ontop.iq.node.NaryOperatorNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.node.TrueNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.model.atom.DataAtom;
import it.unibz.inf.ontop.model.atom.RelationPredicate;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public class IQ2CQ {
    public static ImmutableList<DataAtom<RelationPredicate>> toDataAtoms(ImmutableList<? extends IQTree> nodes) {
        return (ImmutableList)nodes.stream().map(n -> ((DataNode)n.getRootNode()).getProjectionAtom()).collect(ImmutableCollectors.toList());
    }

    public static IQTree toIQTree(ImmutableList<? extends IQTree> extensionalNodes, Optional<ImmutableExpression> joiningConditions, IntermediateQueryFactory iqFactory) {
        switch (extensionalNodes.size()) {
            case 0: {
                return iqFactory.createTrueNode();
            }
            case 1: {
                return joiningConditions.isPresent() ? iqFactory.createUnaryIQTree((UnaryOperatorNode)iqFactory.createFilterNode(joiningConditions.get()), (IQTree)extensionalNodes.get(0)) : (IQTree)extensionalNodes.get(0);
            }
        }
        return iqFactory.createNaryIQTree((NaryOperatorNode)iqFactory.createInnerJoinNode(joiningConditions), (ImmutableList)extensionalNodes.stream().collect(ImmutableCollectors.toList()));
    }

    public static Optional<ImmutableList<ExtensionalDataNode>> getExtensionalDataNodes(IQTree tree) {
        QueryNode node = tree.getRootNode();
        if (node instanceof FilterNode) {
            return Optional.of(ImmutableList.of((Object)((ExtensionalDataNode)tree.getChildren().get(0))));
        }
        if (node instanceof ExtensionalDataNode) {
            return Optional.of(ImmutableList.of((Object)((ExtensionalDataNode)tree)));
        }
        if (node instanceof TrueNode) {
            return Optional.of(ImmutableList.of());
        }
        if (node instanceof InnerJoinNode) {
            if (tree.getChildren().stream().anyMatch(c -> !(c.getRootNode() instanceof ExtensionalDataNode))) {
                return Optional.empty();
            }
            return Optional.of(tree.getChildren().stream().map(n -> (ExtensionalDataNode)n).collect(ImmutableCollectors.toList()));
        }
        return Optional.empty();
    }

    public static ImmutableSet<ImmutableExpression> getFilterExpressions(IQTree tree) {
        QueryNode node = tree.getRootNode();
        if (node instanceof FilterNode) {
            return (ImmutableSet)((ImmutableExpression)((FilterNode)tree.getRootNode()).getOptionalFilterCondition().get()).flattenAND().collect(ImmutableCollectors.toSet());
        }
        if (node instanceof ExtensionalDataNode) {
            return ImmutableSet.of();
        }
        if (node instanceof TrueNode) {
            return ImmutableSet.of();
        }
        if (node instanceof InnerJoinNode) {
            return ((InnerJoinNode)tree.getRootNode()).getOptionalFilterCondition().map(e -> (ImmutableSet)e.flattenAND().collect(ImmutableCollectors.toSet())).orElseGet(ImmutableSet::of);
        }
        throw new IllegalStateException("Use getExtensionalDataNodes first to check whether it's a CQ");
    }

    public static Optional<ImmutableExpression> getConjunction(Optional<ImmutableExpression> optExpression, List<ImmutableExpression> expressions, TermFactory termFactory) {
        if (expressions.isEmpty()) {
            throw new IllegalArgumentException("Nonempty list of filters expected");
        }
        ImmutableExpression result = (optExpression.isPresent() ? Stream.concat(Stream.of(optExpression.get()), expressions.stream()) : expressions.stream()).reduce(null, (a, b) -> a == null ? b : termFactory.getConjunction(a, new ImmutableExpression[]{b}));
        return Optional.of(result);
    }
}

