/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.transformer.impl;

import com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.node.BinaryNonCommutativeOperatorNode;
import it.unibz.inf.ontop.iq.node.FilterNode;
import it.unibz.inf.ontop.iq.node.InnerJoinNode;
import it.unibz.inf.ontop.iq.node.LeftJoinNode;
import it.unibz.inf.ontop.iq.node.NaryOperatorNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.transform.IQTreeVisitingTransformer;
import it.unibz.inf.ontop.iq.transform.impl.LazyRecursiveIQTreeVisitingTransformer;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.spec.mapping.transformer.impl.IQ2CQ;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.List;
import java.util.Optional;

public class FilterAbsorber {
    private final IntermediateQueryFactory iqFactory;
    private final TermFactory termFactory;

    public FilterAbsorber(IntermediateQueryFactory iqFactory, TermFactory termFactory) {
        this.iqFactory = iqFactory;
        this.termFactory = termFactory;
    }

    public IQTree apply(IQTree tree) {
        return tree.acceptTransformer((IQTreeVisitingTransformer)new LazyRecursiveIQTreeVisitingTransformer(this.iqFactory){

            public IQTree transformLeftJoin(IQTree tree, LeftJoinNode rootNode, IQTree leftChild, IQTree rightChild) {
                IQTree newLeftChild = leftChild.acceptTransformer((IQTreeVisitingTransformer)this);
                IQTree newRightChild = rightChild.acceptTransformer((IQTreeVisitingTransformer)this);
                if (newRightChild.getRootNode() instanceof FilterNode) {
                    LeftJoinNode newLeftJoinNode = this.iqFactory.createLeftJoinNode(IQ2CQ.getConjunction(rootNode.getOptionalFilterCondition(), (List<ImmutableExpression>)ImmutableList.of((Object)((FilterNode)newRightChild.getRootNode()).getFilterCondition()), FilterAbsorber.this.termFactory));
                    return this.iqFactory.createBinaryNonCommutativeIQTree((BinaryNonCommutativeOperatorNode)newLeftJoinNode, newLeftChild, ((UnaryIQTree)newRightChild).getChild());
                }
                return leftChild == newLeftChild && rightChild == newRightChild ? tree : this.iqFactory.createBinaryNonCommutativeIQTree((BinaryNonCommutativeOperatorNode)rootNode, newLeftChild, newRightChild);
            }

            public IQTree transformInnerJoin(IQTree tree, InnerJoinNode rootNode, ImmutableList<IQTree> children) {
                ImmutableList childrenReplacement = this.transformChildren(children);
                ImmutableList newChildren = this.extractChildren(childrenReplacement);
                ImmutableList filterChildExpressions = (ImmutableList)newChildren.stream().filter(t -> t.getRootNode() instanceof FilterNode).map(t -> ((FilterNode)t.getRootNode()).getFilterCondition()).collect(ImmutableCollectors.toList());
                if (!filterChildExpressions.isEmpty()) {
                    return this.iqFactory.createNaryIQTree((NaryOperatorNode)this.iqFactory.createInnerJoinNode(IQ2CQ.getConjunction(rootNode.getOptionalFilterCondition(), (List<ImmutableExpression>)filterChildExpressions, FilterAbsorber.this.termFactory)), (ImmutableList)newChildren.stream().map(t -> t.getRootNode() instanceof FilterNode ? ((UnaryIQTree)t).getChild() : t).collect(ImmutableCollectors.toList()));
                }
                return childrenReplacement.stream().allMatch(e -> e.getKey() == e.getValue()) ? tree : this.iqFactory.createNaryIQTree((NaryOperatorNode)rootNode, newChildren);
            }

            public IQTree transformFilter(IQTree tree, FilterNode rootNode, IQTree child) {
                IQTree newChild = child.acceptTransformer((IQTreeVisitingTransformer)this);
                if (newChild.getRootNode() instanceof FilterNode) {
                    return this.iqFactory.createUnaryIQTree((UnaryOperatorNode)this.iqFactory.createFilterNode(IQ2CQ.getConjunction(Optional.of(rootNode.getFilterCondition()), (List<ImmutableExpression>)ImmutableList.of((Object)((FilterNode)newChild.getRootNode()).getFilterCondition()), FilterAbsorber.this.termFactory).get()), ((UnaryIQTree)newChild).getChild());
                }
                if (newChild.getRootNode() instanceof InnerJoinNode) {
                    return this.iqFactory.createNaryIQTree((NaryOperatorNode)this.iqFactory.createInnerJoinNode(IQ2CQ.getConjunction(((InnerJoinNode)newChild.getRootNode()).getOptionalFilterCondition(), (List<ImmutableExpression>)ImmutableList.of((Object)rootNode.getFilterCondition()), FilterAbsorber.this.termFactory)), newChild.getChildren());
                }
                return child == newChild ? tree : this.iqFactory.createUnaryIQTree((UnaryOperatorNode)rootNode, newChild);
            }
        });
    }
}

