/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.transformer.impl;

import com.google.inject.Inject;
import it.unibz.inf.ontop.dbschema.DBMetadata;
import it.unibz.inf.ontop.injection.OntopMappingSettings;
import it.unibz.inf.ontop.injection.OntopModelSettings;
import it.unibz.inf.ontop.injection.SpecificationFactory;
import it.unibz.inf.ontop.spec.OBDASpecification;
import it.unibz.inf.ontop.spec.mapping.Mapping;
import it.unibz.inf.ontop.spec.mapping.transformer.ABoxFactIntoMappingConverter;
import it.unibz.inf.ontop.spec.mapping.transformer.MappingDistinctTransformer;
import it.unibz.inf.ontop.spec.mapping.transformer.MappingMerger;
import it.unibz.inf.ontop.spec.mapping.transformer.MappingSameAsInverseRewriter;
import it.unibz.inf.ontop.spec.mapping.transformer.MappingSaturator;
import it.unibz.inf.ontop.spec.mapping.transformer.MappingTransformer;
import it.unibz.inf.ontop.spec.mapping.transformer.MappingVariableNameNormalizer;
import it.unibz.inf.ontop.spec.ontology.ClassifiedTBox;
import it.unibz.inf.ontop.spec.ontology.Ontology;
import it.unibz.inf.ontop.spec.ontology.impl.OntologyBuilderImpl;
import java.util.Optional;
import org.apache.commons.rdf.api.RDF;

public class DefaultMappingTransformer
implements MappingTransformer {
    private final MappingVariableNameNormalizer mappingNormalizer;
    private final MappingSaturator mappingSaturator;
    private final ABoxFactIntoMappingConverter factConverter;
    private final MappingMerger mappingMerger;
    private final OntopMappingSettings settings;
    private final MappingSameAsInverseRewriter sameAsInverseRewriter;
    private final SpecificationFactory specificationFactory;
    private final RDF rdfFactory;
    private MappingDistinctTransformer mappingDistinctTransformer;

    @Inject
    private DefaultMappingTransformer(MappingVariableNameNormalizer mappingNormalizer, MappingSaturator mappingSaturator, ABoxFactIntoMappingConverter inserter, MappingMerger mappingMerger, OntopMappingSettings settings, MappingSameAsInverseRewriter sameAsInverseRewriter, SpecificationFactory specificationFactory, RDF rdfFactory, MappingDistinctTransformer mappingDistinctTransformer) {
        this.mappingNormalizer = mappingNormalizer;
        this.mappingSaturator = mappingSaturator;
        this.factConverter = inserter;
        this.mappingMerger = mappingMerger;
        this.settings = settings;
        this.sameAsInverseRewriter = sameAsInverseRewriter;
        this.specificationFactory = specificationFactory;
        this.rdfFactory = rdfFactory;
        this.mappingDistinctTransformer = mappingDistinctTransformer;
    }

    @Override
    public OBDASpecification transform(Mapping mapping, DBMetadata dbMetadata, Optional<Ontology> ontology) {
        if (ontology.isPresent()) {
            Mapping factsAsMapping = this.factConverter.convert(ontology.get().abox(), this.settings.isOntologyAnnotationQueryingEnabled());
            Mapping mappingWithFacts = this.mappingMerger.merge(mapping, factsAsMapping);
            return this.createSpecification(mappingWithFacts, dbMetadata, ontology.get().tbox());
        }
        ClassifiedTBox emptyTBox = OntologyBuilderImpl.builder((RDF)this.rdfFactory).build().tbox();
        return this.createSpecification(mapping, dbMetadata, emptyTBox);
    }

    OBDASpecification createSpecification(Mapping mapping, DBMetadata dbMetadata, ClassifiedTBox tbox) {
        Mapping sameAsOptimizedMapping = this.sameAsInverseRewriter.rewrite(mapping);
        Mapping saturatedMapping = this.mappingSaturator.saturate(sameAsOptimizedMapping, dbMetadata, tbox);
        Mapping normalizedMapping = this.mappingNormalizer.normalize(saturatedMapping);
        Mapping finalMapping = this.settings.getCardinalityPreservationMode() == OntopModelSettings.CardinalityPreservationMode.LOOSE ? normalizedMapping : this.mappingDistinctTransformer.addDistinct(normalizedMapping);
        return this.specificationFactory.createSpecification(finalMapping, dbMetadata, tbox);
    }
}

