/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.parser.impl;

import com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.injection.OntopMappingSettings;
import it.unibz.inf.ontop.model.atom.TargetAtom;
import it.unibz.inf.ontop.model.atom.TargetAtomFactory;
import it.unibz.inf.ontop.model.term.IRIConstant;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.model.vocabulary.RDFS;
import it.unibz.inf.ontop.model.vocabulary.XSD;
import it.unibz.inf.ontop.spec.mapping.parser.impl.TurtleOBDABaseVisitor;
import it.unibz.inf.ontop.spec.mapping.parser.impl.TurtleOBDAParser;
import it.unibz.inf.ontop.spec.mapping.parser.impl.TurtleOBDAVisitor;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.RuleNode;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.RDF;

public abstract class AbstractTurtleOBDAVisitor
extends TurtleOBDABaseVisitor
implements TurtleOBDAVisitor {
    private static final Pattern varPattern = Pattern.compile("\\{([^\\}]+)\\}");
    private static final Pattern constantBnodePattern = Pattern.compile("^_:(.*)");
    private HashMap<String, String> directives = new HashMap();
    private ImmutableTerm currentSubject;
    protected String error = "";
    private final TermFactory termFactory;
    private final RDF rdfFactory;
    private final TypeFactory typeFactory;
    private final TargetAtomFactory targetAtomFactory;
    private final OntopMappingSettings settings;

    protected abstract boolean validateAttributeName(String var1);

    protected AbstractTurtleOBDAVisitor(TermFactory termFactory, TypeFactory typeFactory, TargetAtomFactory targetAtomFactory, RDF rdfFactory, OntopMappingSettings settings) {
        this.typeFactory = typeFactory;
        this.targetAtomFactory = targetAtomFactory;
        this.rdfFactory = rdfFactory;
        this.termFactory = termFactory;
        this.settings = settings;
    }

    public String getError() {
        return this.error;
    }

    private String removeBrackets(String text) {
        return text.substring(1, text.length() - 1);
    }

    private ImmutableTerm typeTerm(String text, IRI datatype) {
        return this.termFactory.getRDFLiteralConstant(text, datatype);
    }

    protected ImmutableTerm constructIRI(String text) {
        IRIConstant toReturn = null;
        String PLACEHOLDER = "{}";
        List<FormatString> tokens = this.parseIRI(text);
        int size = tokens.size();
        if (size == 1) {
            FormatString token = tokens.get(0);
            if (token instanceof FixedString) {
                IRI iri = this.rdfFactory.createIRI(token.toString());
                toReturn = this.termFactory.getConstantIRI(iri);
            } else if (token instanceof ColumnString) {
                Variable column = this.termFactory.getVariable(token.toString());
                toReturn = this.termFactory.getIRIFunctionalTerm(column, true);
            }
        } else {
            StringBuilder sb = new StringBuilder();
            ArrayList<ImmutableFunctionalTerm> terms = new ArrayList<ImmutableFunctionalTerm>();
            for (FormatString token : tokens) {
                if (token instanceof FixedString) {
                    sb.append(token.toString());
                    continue;
                }
                if (!(token instanceof ColumnString)) continue;
                sb.append("{}");
                Variable column = this.termFactory.getVariable(token.toString());
                terms.add(this.termFactory.getPartiallyDefinedToStringCast(column));
            }
            String iriTemplate = sb.toString();
            toReturn = this.termFactory.getIRIFunctionalTerm(iriTemplate, ImmutableList.copyOf(terms));
        }
        return toReturn;
    }

    private List<FormatString> parseIRI(String text) {
        ArrayList<FormatString> toReturn = new ArrayList<FormatString>();
        Matcher m = varPattern.matcher(text);
        int i = 0;
        while (i < text.length()) {
            if (m.find(i)) {
                String value;
                if (m.start() != i) {
                    toReturn.add(new FixedString(text.substring(i, m.start())));
                }
                if (!this.validateAttributeName(value = m.group(1))) continue;
                toReturn.add(new ColumnString(value));
                i = m.end();
                continue;
            }
            toReturn.add(new FixedString(text.substring(i)));
            break;
        }
        return toReturn;
    }

    private ImmutableTerm constructConstantBNode(String text) {
        Matcher m = constantBnodePattern.matcher(text);
        return this.termFactory.getConstantBNode(m.group(1));
    }

    private ImmutableTerm constructBnodeFunction(String text) {
        ImmutableList.Builder args = ImmutableList.builder();
        Matcher m = varPattern.matcher(text);
        while (m.find()) {
            args.add((Object)this.termFactory.getVariable(m.group(1)));
        }
        return this.termFactory.getFreshBnodeFunctionalTerm(args.build());
    }

    private int getIndexOfCurlyB(String str) {
        int i = str.indexOf("{");
        int j = str.indexOf("\\{");
        while (i - 1 == j && j != -1) {
            i = str.indexOf("{", i + 1);
            j = str.indexOf("\\{", j + 1);
        }
        return i;
    }

    private List<ImmutableTerm> addToTermsList(String str) {
        ArrayList<ImmutableTerm> terms = new ArrayList<ImmutableTerm>();
        str = str.substring(1, str.length() - 1);
        while (str.contains("{")) {
            int i = this.getIndexOfCurlyB(str);
            if (i > 0) {
                String st = str.substring(0, i);
                st = st.replace("\\\\", "");
                terms.add((ImmutableTerm)this.termFactory.getDBStringConstant(st));
                str = str.substring(str.indexOf("{", i), str.length());
                continue;
            }
            if (i != 0) break;
            int j = str.indexOf("}");
            terms.add((ImmutableTerm)this.termFactory.getVariable(str.substring(1, j)));
            str = str.substring(j + 1, str.length());
        }
        if (!str.equals("")) {
            str = str.replace("\\\\", "");
            terms.add((ImmutableTerm)this.termFactory.getDBStringConstant(str));
        }
        return terms;
    }

    private ImmutableTerm getNestedConcat(String str) {
        List<ImmutableTerm> terms = this.addToTermsList(str);
        if (terms.size() == 1) {
            return terms.get(0);
        }
        return this.termFactory.getNullRejectingDBConcatFunctionalTerm(ImmutableList.copyOf(terms));
    }

    private String concatPrefix(String prefixedName) {
        String[] tokens = prefixedName.split(":", 2);
        String uri = this.directives.get(tokens[0]);
        return uri + tokens[1];
    }

    public ImmutableList<TargetAtom> visitParse(TurtleOBDAParser.ParseContext ctx) {
        ctx.directiveStatement().forEach(arg_0 -> ((AbstractTurtleOBDAVisitor)this).visit(arg_0));
        return (ImmutableList)ctx.triplesStatement().stream().flatMap(triplesStatementContext -> this.visitTriplesStatement((TurtleOBDAParser.TriplesStatementContext)((Object)triplesStatementContext))).collect(ImmutableCollectors.toList());
    }

    public Void visitDirectiveStatement(TurtleOBDAParser.DirectiveStatementContext ctx) {
        this.visit((ParseTree)ctx.directive());
        return null;
    }

    public Void visitDirective(TurtleOBDAParser.DirectiveContext ctx) {
        this.visit((ParseTree)ctx.prefixID());
        return null;
    }

    public Stream<TargetAtom> visitTriplesStatement(TurtleOBDAParser.TriplesStatementContext ctx) {
        return this.visitTriples(ctx.triples());
    }

    public Void visitPrefixID(TurtleOBDAParser.PrefixIDContext ctx) {
        String iriref = this.removeBrackets(ctx.IRIREF().getText());
        String ns = ctx.PNAME_NS().getText();
        this.directives.put(ns.substring(0, ns.length() - 1), iriref);
        return null;
    }

    public Object visitBase(TurtleOBDAParser.BaseContext ctx) {
        String iriRef = this.removeBrackets(ctx.IRIREF().getText());
        this.directives.put("", iriRef);
        return null;
    }

    public Stream<TargetAtom> visitTriples(TurtleOBDAParser.TriplesContext ctx) {
        this.currentSubject = this.visitSubject(ctx.subject());
        return this.visitPredicateObjectList(ctx.predicateObjectList());
    }

    public Stream<TargetAtom> visitPredicateObjectList(TurtleOBDAParser.PredicateObjectListContext ctx) {
        return ctx.predicateObject().stream().flatMap(predicateObjectContext -> this.visitPredicateObject((TurtleOBDAParser.PredicateObjectContext)((Object)predicateObjectContext)));
    }

    public Stream<TargetAtom> visitPredicateObject(TurtleOBDAParser.PredicateObjectContext ctx) {
        return this.visitObjectList(ctx.objectList()).map(t -> this.targetAtomFactory.getTripleTargetAtom(this.currentSubject, this.visitVerb(ctx.verb()), t));
    }

    public ImmutableTerm visitVerb(TurtleOBDAParser.VerbContext ctx) {
        TurtleOBDAParser.ResourceContext rc = ctx.resource();
        if (rc != null) {
            return this.visitResource(rc);
        }
        return this.termFactory.getConstantIRI(it.unibz.inf.ontop.model.vocabulary.RDF.TYPE);
    }

    public Stream<ImmutableTerm> visitObjectList(TurtleOBDAParser.ObjectListContext ctx) {
        return ctx.object().stream().map(this::visitObject);
    }

    public ImmutableTerm visitSubject(TurtleOBDAParser.SubjectContext ctx) {
        TurtleOBDAParser.ResourceContext rc = ctx.resource();
        if (rc != null) {
            return this.visitResource(rc);
        }
        TurtleOBDAParser.VariableContext vc = ctx.variable();
        if (vc != null) {
            return this.termFactory.getIRIFunctionalTerm(this.visitVariable(vc), true);
        }
        TurtleOBDAParser.BlankContext bc = ctx.blank();
        if (bc != null) {
            return this.visitBlank(bc);
        }
        return null;
    }

    public ImmutableTerm visitObject(TurtleOBDAParser.ObjectContext ctx) {
        ImmutableTerm term = (ImmutableTerm)this.visit((ParseTree)ctx.children.iterator().next());
        return term instanceof Variable ? this.termFactory.getRDFLiteralFunctionalTerm((ImmutableTerm)this.termFactory.getPartiallyDefinedToStringCast((Variable)term), RDFS.LITERAL) : term;
    }

    public ImmutableTerm visitResource(TurtleOBDAParser.ResourceContext ctx) {
        if (ctx.iriExt() != null) {
            return this.visitIriExt(ctx.iriExt());
        }
        return this.constructIRI(this.visitIri(ctx.iri()).getIRIString());
    }

    public ImmutableTerm visitIriExt(TurtleOBDAParser.IriExtContext ctx) {
        if (ctx.IRIREF_EXT() != null) {
            return this.constructIRI(this.removeBrackets(ctx.IRIREF_EXT().getText()));
        }
        return this.constructIRI(this.concatPrefix(ctx.PREFIXED_NAME_EXT().getText()));
    }

    public ImmutableFunctionalTerm visitVariableLiteral_1(TurtleOBDAParser.VariableLiteral_1Context ctx) {
        ImmutableFunctionalTerm lexicalTerm = this.termFactory.getPartiallyDefinedToStringCast(this.visitVariable(ctx.variable()));
        return this.termFactory.getRDFLiteralFunctionalTerm((ImmutableTerm)lexicalTerm, this.visitLanguageTag(ctx.languageTag()));
    }

    public ImmutableFunctionalTerm visitVariableLiteral_2(TurtleOBDAParser.VariableLiteral_2Context ctx) {
        ImmutableFunctionalTerm lexicalTerm = this.termFactory.getPartiallyDefinedToStringCast(this.visitVariable(ctx.variable()));
        IRI iri = this.visitIri(ctx.iri());
        if (!this.settings.areAbstractDatatypesToleratedInMapping() && this.typeFactory.getDatatype(iri).isAbstract()) {
            throw new IllegalArgumentException("The datatype of a literal must not be abstract: " + iri + "\nSet the property " + "ontop.tolerateAbstractDatatype" + " to true to tolerate them.");
        }
        return this.termFactory.getRDFLiteralFunctionalTerm((ImmutableTerm)lexicalTerm, iri);
    }

    public IRI visitIri(TurtleOBDAParser.IriContext ctx) {
        TerminalNode token = ctx.PREFIXED_NAME();
        return this.rdfFactory.createIRI(token != null ? this.concatPrefix(token.getText()) : this.removeBrackets(ctx.IRIREF().getText()));
    }

    public Variable visitVariable(TurtleOBDAParser.VariableContext ctx) {
        String variableName = this.removeBrackets(ctx.STRING_WITH_CURLY_BRACKET().getText());
        this.validateAttributeName(variableName);
        return this.termFactory.getVariable(variableName);
    }

    public ImmutableTerm visitBlank(TurtleOBDAParser.BlankContext ctx) {
        if (ctx.BLANK_NODE_FUNCTION() != null) {
            return this.constructBnodeFunction(ctx.BLANK_NODE_FUNCTION().getText());
        }
        if (ctx.BLANK_NODE_LABEL() != null) {
            return this.constructConstantBNode(ctx.BLANK_NODE_LABEL().getText());
        }
        throw new IllegalArgumentException("Anonymous blank nodes not supported yet in mapping targets");
    }

    public String visitLanguageTag(TurtleOBDAParser.LanguageTagContext ctx) {
        return ctx.LANGTAG().getText().substring(1).toLowerCase();
    }

    public ImmutableTerm visitUntypedStringLiteral(TurtleOBDAParser.UntypedStringLiteralContext ctx) {
        TurtleOBDAParser.LitStringContext lsc = ctx.litString();
        ImmutableTerm literal = this.visitLitString(lsc);
        TurtleOBDAParser.LanguageTagContext lc = ctx.languageTag();
        if (lc != null) {
            return this.termFactory.getRDFLiteralFunctionalTerm(literal, this.visitLanguageTag(lc));
        }
        return this.termFactory.getRDFLiteralFunctionalTerm(literal, XSD.STRING).simplify();
    }

    public ImmutableTerm visitLitString(TurtleOBDAParser.LitStringContext ctx) {
        String str = ctx.STRING_LITERAL_QUOTE().getText();
        if (str.contains("{")) {
            return this.getNestedConcat(str);
        }
        return this.termFactory.getDBStringConstant(str.substring(1, str.length() - 1));
    }

    public ImmutableTerm visitTypedLiteral(TurtleOBDAParser.TypedLiteralContext ctx) {
        ImmutableTerm stringValue = this.visitLitString(ctx.litString());
        IRI iriRef = this.visitIri(ctx.iri());
        return this.termFactory.getRDFLiteralFunctionalTerm(stringValue, iriRef).simplify();
    }

    public ImmutableTerm visitUntypedNumericLiteral(TurtleOBDAParser.UntypedNumericLiteralContext ctx) {
        return (ImmutableTerm)this.visitChildren((RuleNode)ctx);
    }

    public ImmutableTerm visitUntypedBooleanLiteral(TurtleOBDAParser.UntypedBooleanLiteralContext ctx) {
        return this.typeTerm(ctx.BOOLEAN_LITERAL().getText(), XSD.BOOLEAN);
    }

    public ImmutableTerm visitNumericUnsigned(TurtleOBDAParser.NumericUnsignedContext ctx) {
        TerminalNode token = ctx.INTEGER();
        if (token != null) {
            return this.typeTerm(token.getText(), XSD.INTEGER);
        }
        token = ctx.DOUBLE();
        if (token != null) {
            return this.typeTerm(token.getText(), XSD.DOUBLE);
        }
        return this.typeTerm(ctx.DECIMAL().getText(), XSD.DECIMAL);
    }

    public ImmutableTerm visitNumericPositive(TurtleOBDAParser.NumericPositiveContext ctx) {
        TerminalNode token = ctx.INTEGER_POSITIVE();
        if (token != null) {
            return this.typeTerm(token.getText(), XSD.INTEGER);
        }
        token = ctx.DOUBLE_POSITIVE();
        if (token != null) {
            return this.typeTerm(token.getText(), XSD.DOUBLE);
        }
        return this.typeTerm(ctx.DECIMAL_POSITIVE().getText(), XSD.DECIMAL);
    }

    public ImmutableTerm visitNumericNegative(TurtleOBDAParser.NumericNegativeContext ctx) {
        TerminalNode token = ctx.INTEGER_NEGATIVE();
        if (token != null) {
            return this.typeTerm(token.getText(), XSD.INTEGER);
        }
        token = ctx.DOUBLE_NEGATIVE();
        if (token != null) {
            return this.typeTerm(token.getText(), XSD.DOUBLE);
        }
        return this.typeTerm(ctx.DECIMAL_NEGATIVE().getText(), XSD.DECIMAL);
    }

    private class ColumnString
    implements FormatString {
        private String s;

        ColumnString(String s) {
            this.s = s;
        }

        @Override
        public int index() {
            return 0;
        }

        @Override
        public String toString() {
            return this.s;
        }
    }

    private class FixedString
    implements FormatString {
        private String s;

        FixedString(String s) {
            this.s = s;
        }

        @Override
        public int index() {
            return -1;
        }

        @Override
        public String toString() {
            return this.s;
        }
    }

    private static interface FormatString {
        public int index();

        public String toString();
    }
}

