/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.impl;

import it.unibz.inf.ontop.dbschema.DBMetadata;
import it.unibz.inf.ontop.exception.DBMetadataExtractionException;
import it.unibz.inf.ontop.exception.DuplicateMappingException;
import it.unibz.inf.ontop.exception.InvalidMappingException;
import it.unibz.inf.ontop.exception.InvalidMappingSourceQueriesException;
import it.unibz.inf.ontop.exception.MappingException;
import it.unibz.inf.ontop.exception.MappingIOException;
import it.unibz.inf.ontop.exception.MappingOntologyMismatchException;
import it.unibz.inf.ontop.exception.MetaMappingExpansionException;
import it.unibz.inf.ontop.exception.NullVariableInMappingException;
import it.unibz.inf.ontop.exception.UnknownDatatypeException;
import it.unibz.inf.ontop.injection.OntopMappingSettings;
import it.unibz.inf.ontop.iq.tools.ExecutorRegistry;
import it.unibz.inf.ontop.spec.OBDASpecInput;
import it.unibz.inf.ontop.spec.mapping.MappingExtractor;
import it.unibz.inf.ontop.spec.mapping.MappingWithProvenance;
import it.unibz.inf.ontop.spec.mapping.parser.MappingParser;
import it.unibz.inf.ontop.spec.mapping.pp.PreProcessedMapping;
import it.unibz.inf.ontop.spec.mapping.validation.MappingOntologyComplianceValidator;
import it.unibz.inf.ontop.spec.ontology.Ontology;
import java.io.File;
import java.io.Reader;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.commons.rdf.api.Graph;

public abstract class AbstractMappingExtractor<T1 extends PreProcessedMapping, T2 extends DBMetadata, T3 extends MappingParser, T4 extends OntopMappingSettings>
implements MappingExtractor {
    private final MappingOntologyComplianceValidator ontologyComplianceValidator;
    protected final T3 mappingParser;

    protected AbstractMappingExtractor(MappingOntologyComplianceValidator ontologyComplianceValidator, T3 mappingParser) {
        this.ontologyComplianceValidator = ontologyComplianceValidator;
        this.mappingParser = mappingParser;
    }

    @Override
    public MappingExtractor.MappingAndDBMetadata extract(@Nonnull OBDASpecInput specInput, @Nonnull Optional<DBMetadata> dbMetadata, @Nonnull Optional<Ontology> ontology, @Nonnull ExecutorRegistry executorRegistry) throws MappingException, DBMetadataExtractionException {
        T1 ppMapping = this.extractPPMapping(specInput);
        return this.extract((PreProcessedMapping)ppMapping, specInput, dbMetadata, ontology, executorRegistry);
    }

    protected T1 extractPPMapping(OBDASpecInput specInput) throws DuplicateMappingException, MappingIOException, InvalidMappingException {
        Optional<File> optionalMappingFile = specInput.getMappingFile();
        if (optionalMappingFile.isPresent()) {
            return (T1)this.mappingParser.parse(optionalMappingFile.get());
        }
        Optional<Reader> optionalMappingReader = specInput.getMappingReader();
        if (optionalMappingReader.isPresent()) {
            return (T1)this.mappingParser.parse(optionalMappingReader.get());
        }
        Optional<Graph> optionalMappingGraph = specInput.getMappingGraph();
        if (optionalMappingGraph.isPresent()) {
            return (T1)this.mappingParser.parse(optionalMappingGraph.get());
        }
        throw new IllegalArgumentException("Bad internal configuration: no mapping input provided in the OBDASpecInput!\n Should have been detected earlier (in case of an user mistake)");
    }

    @Override
    public MappingExtractor.MappingAndDBMetadata extract(@Nonnull PreProcessedMapping ppMapping, @Nonnull OBDASpecInput specInput, @Nonnull Optional<DBMetadata> dbMetadata, @Nonnull Optional<Ontology> ontology, @Nonnull ExecutorRegistry executorRegistry) throws MappingException, DBMetadataExtractionException {
        return this.convertPPMapping(this.castPPMapping(ppMapping), this.castDBMetadata(dbMetadata), specInput, ontology, executorRegistry);
    }

    protected void validateMapping(Optional<Ontology> ontology, MappingWithProvenance filledProvMapping) throws MappingOntologyMismatchException {
        if (ontology.isPresent()) {
            this.ontologyComplianceValidator.validate(filledProvMapping, ontology.get());
        }
    }

    protected abstract MappingExtractor.MappingAndDBMetadata convertPPMapping(T1 var1, Optional<T2> var2, OBDASpecInput var3, Optional<Ontology> var4, ExecutorRegistry var5) throws MetaMappingExpansionException, DBMetadataExtractionException, MappingOntologyMismatchException, InvalidMappingSourceQueriesException, NullVariableInMappingException, UnknownDatatypeException;

    protected abstract Optional<T2> castDBMetadata(Optional<DBMetadata> var1);

    protected abstract T1 castPPMapping(PreProcessedMapping var1);

    protected abstract T1 expandPPMapping(T1 var1, T4 var2, T2 var3) throws MetaMappingExpansionException;
}

