/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.impl;

import com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.spec.OBDASpecInput;
import java.io.File;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.rdf.api.Graph;

public class OBDASpecInputImpl
implements OBDASpecInput {
    private final ImmutableMap<String, File> files;
    private final ImmutableMap<String, Reader> readers;
    private final ImmutableMap<String, Graph> graphs;

    private OBDASpecInputImpl(ImmutableMap<String, File> files, ImmutableMap<String, Reader> readers, ImmutableMap<String, Graph> graphs) {
        this.files = files;
        this.readers = readers;
        this.graphs = graphs;
    }

    @Override
    public Optional<File> getFile(String key) {
        return Optional.ofNullable(this.files.get((Object)key));
    }

    @Override
    public Optional<Reader> getReader(String key) {
        return Optional.ofNullable(this.readers.get((Object)key));
    }

    @Override
    public Optional<Graph> getGraph(String key) {
        return Optional.ofNullable(this.graphs.get((Object)key));
    }

    public static class BuilderImpl
    implements OBDASpecInput.Builder {
        private final Map<String, File> files = new HashMap<String, File>();
        private final Map<String, Reader> readers = new HashMap<String, Reader>();
        private final Map<String, Graph> graphs = new HashMap<String, Graph>();

        @Override
        public OBDASpecInput.Builder addFile(String key, File file) {
            this.files.put(key, file);
            return this;
        }

        @Override
        public OBDASpecInput.Builder addReader(String key, Reader reader) {
            this.readers.put(key, reader);
            return this;
        }

        @Override
        public OBDASpecInput.Builder addGraph(String key, Graph graph) {
            this.graphs.put(key, graph);
            return this;
        }

        @Override
        public OBDASpecInput build() {
            return new OBDASpecInputImpl(ImmutableMap.copyOf(this.files), ImmutableMap.copyOf(this.readers), ImmutableMap.copyOf(this.graphs));
        }
    }
}

