/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.dbschema.impl;

import com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.dbschema.Attribute;
import it.unibz.inf.ontop.dbschema.DBMetadata;
import it.unibz.inf.ontop.dbschema.DatabaseRelationDefinition;
import it.unibz.inf.ontop.dbschema.ForeignKeyConstraint;
import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.dbschema.QuotedIDFactory;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.dbschema.UniqueConstraint;
import it.unibz.inf.ontop.spec.dbschema.PreProcessedImplicitRelationalDBConstraintSet;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicPreProcessedImplicitRelationalDBConstraintSet
implements PreProcessedImplicitRelationalDBConstraintSet {
    private static Logger log = LoggerFactory.getLogger(BasicPreProcessedImplicitRelationalDBConstraintSet.class);
    private final ImmutableList<String[]> ucs;
    private final ImmutableList<String[]> fks;

    BasicPreProcessedImplicitRelationalDBConstraintSet(ImmutableList<String[]> uniqueConstraints, ImmutableList<String[]> foreignKeys) {
        this.ucs = uniqueConstraints;
        this.fks = foreignKeys;
    }

    @Override
    public Set<RelationID> getReferredTables(QuotedIDFactory idfac) {
        HashSet<RelationID> referredTables = new HashSet<RelationID>();
        for (String[] fk : this.fks) {
            RelationID pkTableId = BasicPreProcessedImplicitRelationalDBConstraintSet.getRelationIDFromString(fk[2], idfac);
            referredTables.add(pkTableId);
        }
        return referredTables;
    }

    @Override
    public void insertUniqueConstraints(DBMetadata md) {
        QuotedIDFactory idfac = md.getQuotedIDFactory();
        int counter = 0;
        for (String[] uc : this.ucs) {
            String[] attrs;
            RelationID tableId = BasicPreProcessedImplicitRelationalDBConstraintSet.getRelationIDFromString(uc[0], idfac);
            DatabaseRelationDefinition td = md.getDatabaseRelation(tableId);
            if (td == null) {
                log.warn("Error in user-supplied unique constraint: table " + tableId + " not found.");
                continue;
            }
            UniqueConstraint.Builder builder = UniqueConstraint.builder((DatabaseRelationDefinition)td);
            for (String attr : attrs = uc[1].split(",")) {
                QuotedID attrId = idfac.createAttributeID(attr);
                Attribute attribute = td.getAttribute(attrId);
                if (attribute == null) {
                    log.warn("Error in user-supplied unique constraint: column " + attrId + " not found in table " + tableId + ".");
                    builder = null;
                    break;
                }
                builder.add(attribute);
            }
            if (builder != null) {
                td.addUniqueConstraint(builder.build(td.getID().getTableName() + "_USER_UC_" + counter, false));
            }
            ++counter;
        }
    }

    @Override
    public void insertForeignKeyConstraints(DBMetadata md) {
        QuotedIDFactory idfac = md.getQuotedIDFactory();
        int counter = 0;
        for (String[] fk : this.fks) {
            RelationID pkTableId = BasicPreProcessedImplicitRelationalDBConstraintSet.getRelationIDFromString(fk[2], idfac);
            DatabaseRelationDefinition pkTable = md.getDatabaseRelation(pkTableId);
            if (pkTable == null) {
                log.warn("Error in user-supplied foreign key: table " + pkTableId + " not found.");
                continue;
            }
            RelationID fkTableId = BasicPreProcessedImplicitRelationalDBConstraintSet.getRelationIDFromString(fk[0], idfac);
            DatabaseRelationDefinition fkTable = md.getDatabaseRelation(fkTableId);
            if (fkTable == null) {
                log.warn("Error in user-supplied foreign key: table " + fkTableId + " not found.");
                continue;
            }
            String[] pkAttrs = fk[3].split(",");
            String[] fkAttrs = fk[1].split(",");
            if (fkAttrs.length != pkAttrs.length) {
                log.warn("Error in user-supplied foreign key: foreign key refers to different number of columns " + fk + ".");
                continue;
            }
            ForeignKeyConstraint.Builder builder = ForeignKeyConstraint.builder((DatabaseRelationDefinition)fkTable, (DatabaseRelationDefinition)pkTable);
            for (int i = 0; i < pkAttrs.length; ++i) {
                QuotedID pkAttrId = idfac.createAttributeID(pkAttrs[i]);
                Attribute pkAttr = pkTable.getAttribute(pkAttrId);
                if (pkAttr == null) {
                    log.warn("Error in user-supplied foreign key: column " + pkAttrId + " not found in in table " + pkTable + ".");
                    builder = null;
                    break;
                }
                QuotedID fkAttrId = idfac.createAttributeID(fkAttrs[i]);
                Attribute fkAttr = fkTable.getAttribute(fkAttrId);
                if (fkAttr == null) {
                    log.warn("Error in user-supplied foreign key: column " + fkAttrId + " not found in table " + fkTable + ".");
                    builder = null;
                    break;
                }
                builder.add(fkAttr, pkAttr);
            }
            if (builder != null) {
                fkTable.addForeignKeyConstraint(builder.build(fkTable.getID().getTableName() + "_USER_FK_" + pkTable.getID().getTableName() + "_" + counter));
            }
            ++counter;
        }
    }

    private static RelationID getRelationIDFromString(String name, QuotedIDFactory idfac) {
        String[] names = name.split("\\.");
        if (names.length == 1) {
            return idfac.createRelationID(null, name);
        }
        return idfac.createRelationID(names[0], names[1]);
    }
}

