/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.dbschema.impl;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.exception.ImplicitDBContraintException;
import it.unibz.inf.ontop.spec.dbschema.PreProcessedImplicitRelationalDBConstraintExtractor;
import it.unibz.inf.ontop.spec.dbschema.PreProcessedImplicitRelationalDBConstraintSet;
import it.unibz.inf.ontop.spec.dbschema.impl.BasicPreProcessedImplicitRelationalDBConstraintSet;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class BasicPreProcessedImplicitRelationalDBConstraintExtractor
implements PreProcessedImplicitRelationalDBConstraintExtractor {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicPreProcessedImplicitRelationalDBConstraintExtractor.class);

    @Inject
    private BasicPreProcessedImplicitRelationalDBConstraintExtractor() {
    }

    @Override
    public PreProcessedImplicitRelationalDBConstraintSet extract(@Nonnull File constraintFile) throws ImplicitDBContraintException {
        ImmutableList.Builder ucBuilder = ImmutableList.builder();
        ImmutableList.Builder fkBuilder = ImmutableList.builder();
        try (BufferedReader reader = new BufferedReader(new FileReader(constraintFile));){
            String line = null;
            while ((line = reader.readLine()) != null) {
                String[] parts = line.split(":");
                if (parts.length == 2) {
                    ucBuilder.add((Object)parts);
                    continue;
                }
                if (parts.length != 4) continue;
                fkBuilder.add((Object)parts);
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.warn("Could not find file " + constraintFile + " in directory " + System.getenv().get("PWD"));
            String currentDir = System.getProperty("user.dir");
            LOGGER.warn("Current dir using System:" + currentDir);
            throw new ImplicitDBContraintException("Constraint file " + constraintFile + " does not exist");
        }
        catch (IOException e) {
            LOGGER.warn("Problem reading keys from the constraint file " + constraintFile);
            LOGGER.warn(e.getMessage());
            throw new ImplicitDBContraintException(e);
        }
        return new BasicPreProcessedImplicitRelationalDBConstraintSet((ImmutableList<String[]>)ucBuilder.build(), (ImmutableList<String[]>)fkBuilder.build());
    }
}

