/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.endpoint.controllers;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMultimap;
import it.unibz.inf.ontop.com.google.common.collect.Maps;
import it.unibz.inf.ontop.rdf4j.predefined.LateEvaluationOrConversionException;
import it.unibz.inf.ontop.rdf4j.predefined.OntopRDF4JPredefinedQueryEngine;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class PredefinedQueryController {
    private final OntopRDF4JPredefinedQueryEngine engine;

    @Autowired
    public PredefinedQueryController(OntopRDF4JPredefinedQueryEngine engine) {
        this.engine = engine;
    }

    @RequestMapping(value={"/predefined/{id}"})
    @ResponseBody
    public void answer(@PathVariable(value="id") String id, @RequestParam Map<String, String> allRequestParams, @RequestHeader(value="Accept") String accept, HttpServletRequest request, HttpServletResponse response) throws IOException, LateEvaluationOrConversionException {
        response.setCharacterEncoding("UTF-8");
        List mediaTypes = MediaType.parseMediaTypes((String)accept);
        MediaType.sortBySpecificity((List)mediaTypes);
        ImmutableList acceptMediaTypes = (ImmutableList)mediaTypes.stream().map(m -> m.getType() + "/" + m.getSubtype()).collect(ImmutableCollectors.toList());
        ImmutableMultimap httpHeaders = (ImmutableMultimap)Collections.list(request.getHeaderNames()).stream().flatMap(k -> Collections.list(request.getHeaders(k)).stream().map(v -> Maps.immutableEntry((Object)k, (Object)v))).collect(ImmutableCollectors.toMultimap());
        ImmutableMap requestParams = ImmutableMap.copyOf(allRequestParams);
        ServletOutputStream responseOutputStream = response.getOutputStream();
        if (this.engine.shouldStream(id)) {
            this.engine.evaluate(id, requestParams, acceptMediaTypes, httpHeaders, arg_0 -> ((HttpServletResponse)response).setStatus(arg_0), (arg_0, arg_1) -> ((HttpServletResponse)response).setHeader(arg_0, arg_1), (OutputStream)responseOutputStream);
        } else {
            ByteArrayOutputStream payloadOutputStream = new ByteArrayOutputStream();
            this.engine.evaluate(id, requestParams, acceptMediaTypes, httpHeaders, arg_0 -> ((HttpServletResponse)response).setStatus(arg_0), (arg_0, arg_1) -> ((HttpServletResponse)response).setHeader(arg_0, arg_1), (OutputStream)payloadOutputStream);
            response.setContentLength(payloadOutputStream.size());
            payloadOutputStream.writeTo((OutputStream)responseOutputStream);
        }
        responseOutputStream.flush();
    }

    @ExceptionHandler(value={LateEvaluationOrConversionException.class})
    public ResponseEntity<String> handleLateException(Exception ex) {
        ex.printStackTrace();
        HttpHeaders headers = new HttpHeaders();
        headers.set("Content-Type", "text/plain; charset=UTF-8");
        HttpStatus status = HttpStatus.INTERNAL_SERVER_ERROR;
        return new ResponseEntity((Object)ex.getMessage(), (MultiValueMap)headers, status);
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<String> handleUnexpectedException(Exception ex) {
        ex.printStackTrace();
        String message = "Unexpected exception: " + ex.getMessage();
        HttpHeaders headers = new HttpHeaders();
        headers.set("Content-Type", "text/plain; charset=UTF-8");
        HttpStatus status = HttpStatus.INTERNAL_SERVER_ERROR;
        return new ResponseEntity((Object)message, (MultiValueMap)headers, status);
    }
}

