/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.endpoint.beans;

import it.unibz.inf.ontop.injection.OntopSQLOWLAPIConfiguration;
import it.unibz.inf.ontop.injection.OntopSystemConfiguration;
import it.unibz.inf.ontop.rdf4j.repository.OntopRepository;
import it.unibz.inf.ontop.rdf4j.repository.impl.OntopVirtualRepository;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component
public class OntopVirtualRepositoryBean {
    @Bean
    private OntopSystemConfiguration setupOntopConfiguration(@Value(value="${mapping}") String mappings, @Value(value="${ontology:#{null}}") String ontology, @Value(value="${xml-catalog:#{null}}") String xmlCatalog, @Value(value="${properties}") String properties, @Value(value="${constraint:#{null}}") String constraint, @Value(value="${db-metadata:#{null}}") String dbMetadata, @Value(value="${ontop-views:#{null}}") String ontopViews, @Value(value="${db-user:#{null}}") String dbUser, @Value(value="${db-password:#{null}}") String dbPassword, @Value(value="${db-url:#{null}}") String dbUrl) throws RepositoryException {
        OntopSQLOWLAPIConfiguration.Builder builder = (OntopSQLOWLAPIConfiguration.Builder)OntopSQLOWLAPIConfiguration.defaultBuilder().propertyFile(properties);
        if (mappings.endsWith(".obda")) {
            builder.nativeOntopMappingFile(mappings);
        } else {
            builder.r2rmlMappingFile(mappings);
        }
        if (ontology != null && !ontology.isEmpty()) {
            builder.ontologyFile(ontology);
        }
        if (xmlCatalog != null && !xmlCatalog.isEmpty()) {
            builder.xmlCatalogFile(xmlCatalog);
        }
        if (constraint != null && !constraint.isEmpty()) {
            builder.basicImplicitConstraintFile(constraint);
        }
        if (dbMetadata != null && !dbMetadata.isEmpty()) {
            builder.dbMetadataFile(dbMetadata);
        }
        if (ontopViews != null && !ontopViews.isEmpty()) {
            builder.ontopViewFile(ontopViews);
        }
        if (dbUser != null && !dbUser.isEmpty()) {
            builder.jdbcUser(dbUser);
        }
        if (dbPassword != null) {
            builder.jdbcPassword(dbPassword);
        }
        if (dbUrl != null && !dbUrl.isEmpty()) {
            builder.jdbcUrl(dbUrl);
        }
        return builder.build();
    }

    @Bean
    private OntopVirtualRepository setupVirtualRepository(@Value(value="${lazy:false}") boolean lazy, OntopSystemConfiguration configuration) throws RepositoryException {
        OntopVirtualRepository repository = OntopRepository.defaultRepository((OntopSystemConfiguration)configuration);
        if (!lazy) {
            repository.init();
        }
        return repository;
    }
}

