/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.endpoint.controllers;

import it.unibz.inf.ontop.rdf4j.repository.impl.OntopRepositoryConnection;
import it.unibz.inf.ontop.rdf4j.repository.impl.OntopVirtualRepository;
import it.unibz.inf.ontop.utils.VersionInfo;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.rdf4j.query.BooleanQuery;
import org.eclipse.rdf4j.query.GraphQuery;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.Query;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResultHandler;
import org.eclipse.rdf4j.query.Update;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultWriter;
import org.eclipse.rdf4j.query.resultio.sparqljson.SPARQLBooleanJSONWriter;
import org.eclipse.rdf4j.query.resultio.sparqljson.SPARQLResultsJSONWriter;
import org.eclipse.rdf4j.query.resultio.sparqlxml.SPARQLBooleanXMLWriter;
import org.eclipse.rdf4j.query.resultio.sparqlxml.SPARQLResultsXMLWriter;
import org.eclipse.rdf4j.query.resultio.text.BooleanTextWriter;
import org.eclipse.rdf4j.query.resultio.text.csv.SPARQLResultsCSVWriter;
import org.eclipse.rdf4j.query.resultio.text.tsv.SPARQLResultsTSVWriter;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.jsonld.JSONLDWriter;
import org.eclipse.rdf4j.rio.rdfjson.RDFJSONWriter;
import org.eclipse.rdf4j.rio.rdfxml.RDFXMLWriter;
import org.eclipse.rdf4j.rio.turtle.TurtleWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
public class SparqlQueryController {
    private static final Logger log = LoggerFactory.getLogger(SparqlQueryController.class);
    private final OntopVirtualRepository repository;

    @Autowired
    public SparqlQueryController(OntopVirtualRepository repository) {
        this.repository = repository;
    }

    @GetMapping(value={"/"})
    public ModelAndView home() {
        HashMap<String, String> model = new HashMap<String, String>();
        model.put("version", VersionInfo.getVersionInfo().getVersion());
        return new ModelAndView("index", model);
    }

    @RequestMapping(value={"/sparql"}, method={RequestMethod.GET})
    public void query_get(@RequestHeader(value="Accept") String accept, @RequestParam(value="query") String query, @RequestParam(value="default-graph-uri", required=false) String[] defaultGraphUri, @RequestParam(value="named-graph-uri", required=false) String[] namedGraphUri, HttpServletResponse response) {
        this.execQuery(accept, query, defaultGraphUri, namedGraphUri, response);
    }

    @RequestMapping(value={"/sparql"}, method={RequestMethod.POST}, consumes={"application/x-www-form-urlencoded"})
    public void query_post_URL_encoded(@RequestHeader(value="Accept") String accept, @RequestParam(value="query") String query, @RequestParam(value="default-graph-uri", required=false) String[] defaultGraphUri, @RequestParam(value="named-graph-uri", required=false) String[] namedGraphUri, HttpServletResponse response) {
        this.execQuery(accept, query, defaultGraphUri, namedGraphUri, response);
    }

    @RequestMapping(value={"/sparql"}, method={RequestMethod.POST}, consumes={"application/sparql-query"})
    public void query_post_directly(@RequestHeader(value="Accept") String accept, @RequestBody String query, @RequestParam(value="default-graph-uri", required=false) String[] defaultGraphUri, @RequestParam(value="named-graph-uri", required=false) String[] namedGraphUri, HttpServletResponse response) {
        this.execQuery(accept, query, defaultGraphUri, namedGraphUri, response);
    }

    private void execQuery(String accept, String query, String[] defaultGraphUri, String[] namedGraphUri, HttpServletResponse response) {
        try (OntopRepositoryConnection connection = this.repository.getConnection();){
            Query q = connection.prepareQuery(QueryLanguage.SPARQL, query);
            ServletOutputStream bao = response.getOutputStream();
            if (q instanceof TupleQuery) {
                TupleQuery selectQuery = (TupleQuery)q;
                response.setCharacterEncoding("UTF-8");
                if ("*/*".equals(accept) || accept.contains("json")) {
                    response.setHeader("Content-Type", "application/sparql-results+json;charset=UTF-8");
                    this.evaluateSelectQuery(selectQuery, (TupleQueryResultWriter)new SPARQLResultsJSONWriter((OutputStream)bao), response);
                } else if (accept.contains("xml")) {
                    response.setHeader("Content-Type", "application/sparql-results+xml;charset=UTF-8");
                    this.evaluateSelectQuery(selectQuery, (TupleQueryResultWriter)new SPARQLResultsXMLWriter((OutputStream)bao), response);
                } else if (accept.contains("csv")) {
                    response.setHeader("Content-Type", "text/sparql-results+csv;charset=UTF-8");
                    this.evaluateSelectQuery(selectQuery, (TupleQueryResultWriter)new SPARQLResultsCSVWriter((OutputStream)bao), response);
                } else if (accept.contains("tsv") || accept.contains("text/tab-separated-values")) {
                    response.setHeader("Content-Type", "text/sparql-results+tsv;charset=UTF-8");
                    this.evaluateSelectQuery(selectQuery, (TupleQueryResultWriter)new SPARQLResultsTSVWriter((OutputStream)bao), response);
                } else {
                    response.setStatus(HttpStatus.NOT_ACCEPTABLE.value());
                }
            } else if (q instanceof BooleanQuery) {
                BooleanQuery askQuery = (BooleanQuery)q;
                boolean b = askQuery.evaluate();
                if ("*/*".equals(accept) || accept.contains("json")) {
                    response.setHeader("Content-Type", "application/sparql-results+json");
                    this.addCacheHeaders(response);
                    SPARQLBooleanJSONWriter writer = new SPARQLBooleanJSONWriter((OutputStream)bao);
                    writer.handleBoolean(b);
                } else if (accept.contains("xml")) {
                    response.setHeader("Content-Type", "application/sparql-results+xml");
                    this.addCacheHeaders(response);
                    SPARQLBooleanXMLWriter writer = new SPARQLBooleanXMLWriter((OutputStream)bao);
                    writer.handleBoolean(b);
                } else if (accept.contains("text")) {
                    response.setHeader("Content-Type", "text/boolean");
                    this.addCacheHeaders(response);
                    BooleanTextWriter writer = new BooleanTextWriter((OutputStream)bao);
                    writer.handleBoolean(b);
                } else {
                    response.setStatus(HttpStatus.NOT_ACCEPTABLE.value());
                }
            } else if (q instanceof GraphQuery) {
                GraphQuery graphQuery = (GraphQuery)q;
                response.setCharacterEncoding("UTF-8");
                if ("*/*".equals(accept) || accept.contains("turtle")) {
                    response.setHeader("Content-Type", "text/turtle;charset=UTF-8");
                    this.evaluateGraphQuery(graphQuery, (RDFWriter)new TurtleWriter((OutputStream)bao), response);
                } else if (accept.contains("rdf+json")) {
                    response.setHeader("Content-Type", "application/rdf+json;charset=UTF-8");
                    this.evaluateGraphQuery(graphQuery, (RDFWriter)new RDFJSONWriter((OutputStream)bao, RDFFormat.RDFJSON), response);
                } else if (accept.contains("json")) {
                    response.setHeader("Content-Type", "application/ld+json;charset=UTF-8");
                    this.evaluateGraphQuery(graphQuery, (RDFWriter)new JSONLDWriter((OutputStream)bao), response);
                } else if (accept.contains("xml")) {
                    response.setHeader("Content-Type", "application/rdf+xml;charset=UTF-8");
                    this.evaluateGraphQuery(graphQuery, (RDFWriter)new RDFXMLWriter((OutputStream)bao), response);
                } else {
                    response.setStatus(HttpStatus.NOT_ACCEPTABLE.value());
                }
            } else if (q instanceof Update) {
                response.setStatus(HttpStatus.NOT_IMPLEMENTED.value());
            } else {
                response.setStatus(HttpStatus.BAD_REQUEST.value());
            }
            bao.flush();
        }
        catch (IOException ex) {
            throw new Error(ex);
        }
    }

    private void evaluateSelectQuery(TupleQuery selectQuery, TupleQueryResultWriter writer, HttpServletResponse response) {
        this.addCacheHeaders(response);
        selectQuery.evaluate((TupleQueryResultHandler)writer);
    }

    private void evaluateGraphQuery(GraphQuery graphQuery, RDFWriter turtleWriter, HttpServletResponse response) {
        this.addCacheHeaders(response);
        graphQuery.evaluate((RDFHandler)turtleWriter);
    }

    private void addCacheHeaders(HttpServletResponse response) {
        this.repository.getHttpCacheHeaders().getMap().forEach((arg_0, arg_1) -> ((HttpServletResponse)response).setHeader(arg_0, arg_1));
    }

    @ExceptionHandler(value={MalformedQueryException.class})
    public ResponseEntity<String> handleMalformedQueryException(Exception ex) {
        ex.printStackTrace();
        String message = ex.getMessage();
        HttpHeaders headers = new HttpHeaders();
        headers.set("Content-Type", "text/plain; charset=UTF-8");
        HttpStatus status = HttpStatus.BAD_REQUEST;
        return new ResponseEntity((Object)message, (MultiValueMap)headers, status);
    }

    @ExceptionHandler(value={RepositoryException.class, Exception.class})
    public ResponseEntity<String> handleRepositoryException(Exception ex) {
        ex.printStackTrace();
        String message = ex.getMessage();
        HttpHeaders headers = new HttpHeaders();
        headers.set("Content-Type", "text/plain; charset=UTF-8");
        HttpStatus status = HttpStatus.INTERNAL_SERVER_ERROR;
        return new ResponseEntity((Object)message, (MultiValueMap)headers, status);
    }
}

