/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.endpoint.beans;

import it.unibz.inf.ontop.injection.OntopSQLOWLAPIConfiguration;
import it.unibz.inf.ontop.injection.OntopSystemConfiguration;
import it.unibz.inf.ontop.rdf4j.repository.OntopRepository;
import it.unibz.inf.ontop.rdf4j.repository.impl.OntopVirtualRepository;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component
public class OntopVirtualRepositoryBean {
    @Bean
    private OntopVirtualRepository setupVirtualRepository(@Value(value="${mapping}") String mappings, @Value(value="${ontology:#{null}}") String ontology, @Value(value="${xml-catalog:#{null}}") String xmlCatalog, @Value(value="${properties}") String properties, @Value(value="${constraint:#{null}}") String constraint, @Value(value="${lazy:false}") boolean lazy) throws RepositoryException {
        OntopSQLOWLAPIConfiguration.Builder builder = (OntopSQLOWLAPIConfiguration.Builder)OntopSQLOWLAPIConfiguration.defaultBuilder().propertyFile(properties);
        if (mappings.endsWith(".obda")) {
            builder.nativeOntopMappingFile(mappings);
        } else {
            builder.r2rmlMappingFile(mappings);
        }
        if (ontology != null && !ontology.isEmpty()) {
            builder.ontologyFile(ontology);
        }
        if (xmlCatalog != null && !xmlCatalog.isEmpty()) {
            builder.xmlCatalogFile(xmlCatalog);
        }
        if (constraint != null && !constraint.isEmpty()) {
            builder.basicImplicitConstraintFile(constraint);
        }
        OntopSQLOWLAPIConfiguration configuration = builder.build();
        OntopVirtualRepository repository = OntopRepository.defaultRepository((OntopSystemConfiguration)configuration);
        if (!lazy) {
            repository.init();
        }
        return repository;
    }
}

