/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.endpoint;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.boot.web.servlet.server.ConfigurableServletWebServerFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@SpringBootApplication
public class OntopEndpointApplication {
    private static ConfigurableApplicationContext context;

    public static void main(String[] args) {
        context = SpringApplication.run(OntopEndpointApplication.class, (String[])args);
    }

    @Bean
    WebServerFactoryCustomizer<ConfigurableServletWebServerFactory> portConfig(@Value(value="${port:8080}") int port) {
        return server -> server.setPort(port);
    }

    @Bean
    public WebMvcConfigurer corsConfigurer(final @Value(value="${cors-allowed-origins:#{null}}") String[] allowedOrigins) {
        return allowedOrigins == null ? new WebMvcConfigurer(){} : new WebMvcConfigurer(){

            public void addCorsMappings(CorsRegistry registry) {
                registry.addMapping("/*").allowedOrigins(allowedOrigins);
            }
        };
    }

    public static void restart() {
        ApplicationArguments args = (ApplicationArguments)context.getBean(ApplicationArguments.class);
        Thread thread = new Thread(() -> {
            context.close();
            context = SpringApplication.run(OntopEndpointApplication.class, (String[])args.getSourceArgs());
        });
        thread.setDaemon(false);
        thread.start();
    }
}

