/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.endpoint.controllers;

import it.unibz.inf.ontop.rdf4j.repository.impl.OntopRepositoryConnection;
import it.unibz.inf.ontop.rdf4j.repository.impl.OntopVirtualRepository;
import it.unibz.inf.ontop.utils.VersionInfo;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.eclipse.rdf4j.query.BooleanQuery;
import org.eclipse.rdf4j.query.GraphQuery;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.Query;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResultHandler;
import org.eclipse.rdf4j.query.Update;
import org.eclipse.rdf4j.query.resultio.sparqljson.SPARQLBooleanJSONWriter;
import org.eclipse.rdf4j.query.resultio.sparqljson.SPARQLResultsJSONWriter;
import org.eclipse.rdf4j.query.resultio.sparqlxml.SPARQLBooleanXMLWriter;
import org.eclipse.rdf4j.query.resultio.sparqlxml.SPARQLResultsXMLWriter;
import org.eclipse.rdf4j.query.resultio.text.BooleanTextWriter;
import org.eclipse.rdf4j.query.resultio.text.csv.SPARQLResultsCSVWriter;
import org.eclipse.rdf4j.query.resultio.text.tsv.SPARQLResultsTSVWriter;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.rdfjson.RDFJSONWriter;
import org.eclipse.rdf4j.rio.rdfxml.RDFXMLWriter;
import org.eclipse.rdf4j.rio.turtle.TurtleWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
public class SparqlQueryController {
    private static final Logger log = LoggerFactory.getLogger(SparqlQueryController.class);
    private final OntopVirtualRepository repository;

    @Autowired
    public SparqlQueryController(OntopVirtualRepository repository) {
        this.repository = repository;
    }

    @GetMapping(value={"/"})
    public ModelAndView home() {
        HashMap<String, String> model = new HashMap<String, String>();
        model.put("version", VersionInfo.getVersionInfo().getVersion());
        return new ModelAndView("index", model);
    }

    @RequestMapping(value={"/sparql"}, method={RequestMethod.GET})
    @ResponseBody
    public HttpEntity<String> query_get(@RequestHeader(value="Accept") String accept, @RequestParam(value="query") String query, @RequestParam(value="default-graph-uri", required=false) String[] defaultGraphUri, @RequestParam(value="named-graph-uri", required=false) String[] namedGraphUri) {
        return this.execQuery(accept, query, defaultGraphUri, namedGraphUri);
    }

    @RequestMapping(value={"/sparql"}, method={RequestMethod.POST}, consumes={"application/x-www-form-urlencoded"})
    @ResponseBody
    public HttpEntity<String> query_post_URL_encoded(@RequestHeader(value="Accept") String accept, @RequestParam(value="query") String query, @RequestParam(value="default-graph-uri", required=false) String[] defaultGraphUri, @RequestParam(value="named-graph-uri", required=false) String[] namedGraphUri) {
        return this.execQuery(accept, query, defaultGraphUri, namedGraphUri);
    }

    @RequestMapping(value={"/sparql"}, method={RequestMethod.POST}, consumes={"application/sparql-query"})
    @ResponseBody
    public HttpEntity<String> query_post_directly(@RequestHeader(value="Accept") String accept, @RequestBody String query, @RequestParam(value="default-graph-uri", required=false) String[] defaultGraphUri, @RequestParam(value="named-graph-uri", required=false) String[] namedGraphUri) {
        return this.execQuery(accept, query, defaultGraphUri, namedGraphUri);
    }

    private ResponseEntity<String> execQuery(String accept, String query, String[] defaultGraphUri, String[] namedGraphUri) {
        HttpHeaders headers = new HttpHeaders();
        HttpStatus status = HttpStatus.OK;
        try (OntopRepositoryConnection connection = this.repository.getConnection();){
            String result;
            Query q = connection.prepareQuery(QueryLanguage.SPARQL, query);
            ByteArrayOutputStream bao = new ByteArrayOutputStream();
            if (q instanceof TupleQuery) {
                TupleQuery selectQuery = (TupleQuery)q;
                if ("*/*".equals(accept) || accept.contains("json")) {
                    headers.set("Content-Type", "application/sparql-results+json");
                    selectQuery.evaluate((TupleQueryResultHandler)new SPARQLResultsJSONWriter((OutputStream)bao));
                    result = bao.toString();
                } else if (accept.contains("xml")) {
                    headers.set("Content-Type", "application/sparql-results+xml");
                    selectQuery.evaluate((TupleQueryResultHandler)new SPARQLResultsXMLWriter((OutputStream)bao));
                    result = bao.toString();
                } else if (accept.contains("csv")) {
                    headers.set("Content-Type", "text/sparql-results+csv");
                    selectQuery.evaluate((TupleQueryResultHandler)new SPARQLResultsCSVWriter((OutputStream)bao));
                    result = bao.toString();
                } else if (accept.contains("tsv")) {
                    headers.set("Content-Type", "text/sparql-results+tsv");
                    selectQuery.evaluate((TupleQueryResultHandler)new SPARQLResultsTSVWriter((OutputStream)bao));
                    result = bao.toString();
                } else {
                    result = "";
                    status = HttpStatus.BAD_REQUEST;
                }
            } else if (q instanceof BooleanQuery) {
                BooleanQuery askQuery = (BooleanQuery)q;
                boolean b = askQuery.evaluate();
                if ("*/*".equals(accept) || accept.contains("json")) {
                    headers.set("Content-Type", "application/sparql-results+json");
                    SPARQLBooleanJSONWriter writer = new SPARQLBooleanJSONWriter((OutputStream)bao);
                    writer.handleBoolean(b);
                    result = bao.toString();
                } else if (accept.contains("xml")) {
                    headers.set("Content-Type", "application/sparql-results+xml");
                    SPARQLBooleanXMLWriter writer = new SPARQLBooleanXMLWriter((OutputStream)bao);
                    writer.handleBoolean(b);
                    result = bao.toString();
                } else if (accept.contains("text")) {
                    headers.set("Content-Type", "text/boolean");
                    BooleanTextWriter writer = new BooleanTextWriter((OutputStream)bao);
                    writer.handleBoolean(b);
                    result = bao.toString();
                } else {
                    result = "";
                    status = HttpStatus.BAD_REQUEST;
                }
            } else if (q instanceof GraphQuery) {
                GraphQuery graphQuery = (GraphQuery)q;
                if ("*/*".equals(accept) || accept.contains("turtle")) {
                    headers.set("Content-Type", "text/turtle");
                    graphQuery.evaluate((RDFHandler)new TurtleWriter((OutputStream)bao));
                    result = bao.toString();
                } else if (accept.contains("json")) {
                    headers.set("Content-Type", "application/json");
                    graphQuery.evaluate((RDFHandler)new RDFJSONWriter((OutputStream)bao, RDFFormat.JSONLD));
                    result = bao.toString();
                } else if (accept.contains("xml")) {
                    headers.set("Content-Type", "application/rdf+xml");
                    graphQuery.evaluate((RDFHandler)new RDFXMLWriter((OutputStream)bao));
                    result = bao.toString();
                } else {
                    result = "";
                    status = HttpStatus.BAD_REQUEST;
                }
            } else if (q instanceof Update) {
                result = "";
                status = HttpStatus.NOT_IMPLEMENTED;
            } else {
                result = "";
                status = HttpStatus.BAD_REQUEST;
            }
            ResponseEntity responseEntity = new ResponseEntity((Object)result, (MultiValueMap)headers, status);
            return responseEntity;
        }
    }

    @ExceptionHandler(value={MalformedQueryException.class})
    public ResponseEntity<String> handleMalformedQueryException(Exception ex) {
        ex.printStackTrace();
        String message = ex.getMessage();
        HttpHeaders headers = new HttpHeaders();
        headers.set("Content-Type", "text/plain; charset=UTF-8");
        HttpStatus status = HttpStatus.BAD_REQUEST;
        return new ResponseEntity((Object)message, (MultiValueMap)headers, status);
    }

    @ExceptionHandler(value={RepositoryException.class, Exception.class})
    public ResponseEntity<String> handleRepositoryException(Exception ex) {
        ex.printStackTrace();
        String message = ex.getMessage();
        HttpHeaders headers = new HttpHeaders();
        headers.set("Content-Type", "text/plain; charset=UTF-8");
        HttpStatus status = HttpStatus.INTERNAL_SERVER_ERROR;
        return new ResponseEntity((Object)message, (MultiValueMap)headers, status);
    }
}

