/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.endpoint.controllers;

import it.unibz.inf.ontop.exception.OntopConnectionException;
import it.unibz.inf.ontop.exception.OntopReformulationException;
import it.unibz.inf.ontop.rdf4j.repository.impl.OntopRepositoryConnection;
import it.unibz.inf.ontop.rdf4j.repository.impl.OntopVirtualRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ConditionalOnExpression(value="${dev:false}")
public class ReformulateController {
    private OntopVirtualRepository repository;

    @Autowired
    public ReformulateController(OntopVirtualRepository repository) {
        this.repository = repository;
    }

    @RequestMapping(value={"/ontop/reformulate"})
    @ResponseBody
    public ResponseEntity<String> reformulate(@RequestParam(value="query") String query) throws OntopConnectionException, OntopReformulationException {
        HttpHeaders headers = new HttpHeaders();
        headers.set("Content-Type", "text/plain; charset=UTF-8");
        try (OntopRepositoryConnection connection = this.repository.getConnection();){
            ResponseEntity responseEntity = new ResponseEntity((Object)connection.reformulate(query), (MultiValueMap)headers, HttpStatus.OK);
            return responseEntity;
        }
    }
}

