/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.endpoint.controllers;

import com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.endpoint.OntopEndpointApplication;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ConditionalOnExpression(value="${dev:false}")
public class AutoRestartController {
    private static final Logger log = LoggerFactory.getLogger(AutoRestartController.class);

    @Autowired
    public AutoRestartController(@Value(value="${mapping}") String mappingFile, @Value(value="${properties}") String propertiesFile, @Value(value="${ontology:#{null}}") String owlFile, @Value(value="${portal:#{null}}") String portalFile) {
        this.registerFileWatcher(mappingFile, owlFile, propertiesFile, portalFile);
    }

    @PostMapping(value={"/ontop/restart"})
    public void restart() {
        OntopEndpointApplication.restart();
    }

    private void registerFileWatcher(String mappingFile, @Nullable String owlFile, String propertiesFile, @Nullable String portalFile) {
        FileSystem fileSystem = FileSystems.getDefault();
        ImmutableList filesToWatch = (ImmutableList)Stream.of(mappingFile, owlFile, propertiesFile, portalFile).filter(Objects::nonNull).map(f -> new File((String)f).getAbsolutePath()).map(s -> fileSystem.getPath((String)s, new String[0])).collect(ImmutableCollectors.toList());
        Path parentDirectoryPath = ((Path)filesToWatch.get(0)).getParent();
        System.out.println(parentDirectoryPath);
        new Thread(() -> {
            try {
                WatchService watchService = FileSystems.getDefault().newWatchService();
                WatchKey watchKey = parentDirectoryPath.register(watchService, StandardWatchEventKinds.ENTRY_MODIFY);
                while (true) {
                    WatchKey wk = watchService.take();
                    for (WatchEvent<?> event : wk.pollEvents()) {
                        Path localChanged = (Path)event.context();
                        Path changed = Paths.get(parentDirectoryPath.toString(), localChanged.toString()).toAbsolutePath();
                        System.out.println(changed + " changed detected!");
                        if (!filesToWatch.stream().anyMatch(changed::endsWith)) continue;
                        log.info("RESTARTING Ontop!");
                        OntopEndpointApplication.restart();
                    }
                    boolean valid = wk.reset();
                    if (!valid) {
                        System.out.println("Key has been unregistered");
                    }
                    Thread.sleep(1000L);
                }
            }
            catch (IOException | InterruptedException e) {
                e.printStackTrace();
                return;
            }
        }).start();
    }
}

