/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.cli;

import com.github.rvesse.airline.annotations.Command;
import it.unibz.inf.ontop.cli.OntopMappingOntologyRelatedCommand;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.com.google.common.collect.Sets;
import it.unibz.inf.ontop.exception.OBDASpecificationException;
import it.unibz.inf.ontop.injection.OntopSQLOWLAPIConfiguration;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Set;
import java.util.stream.Collectors;
import org.semanticweb.owlapi.model.HasIRI;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;

@Command(name="validate", description="Validate Ontology and Mappings")
public class OntopValidate
extends OntopMappingOntologyRelatedCommand {
    @Override
    public void run() {
        if (!Files.exists(Paths.get(this.owlFile, new String[0]), new LinkOption[0])) {
            System.out.format("ERROR: The Ontology file %s does not exist\n", this.owlFile);
            System.exit(1);
        }
        OntopSQLOWLAPIConfiguration.Builder builder = (OntopSQLOWLAPIConfiguration.Builder)((OntopSQLOWLAPIConfiguration.Builder)OntopSQLOWLAPIConfiguration.defaultBuilder().ontologyFile(this.owlFile)).propertyFile(this.propertiesFile);
        if (this.dbPassword != null) {
            builder.jdbcPassword(this.dbPassword);
        }
        if (this.dbUrl != null) {
            builder.jdbcUrl(this.dbUrl);
        }
        if (this.dbUser != null) {
            builder.jdbcUser(this.dbUser);
        }
        if (this.isR2rmlFile(this.mappingFile)) {
            builder.r2rmlMappingFile(this.mappingFile);
        } else {
            builder.nativeOntopMappingFile(this.mappingFile);
        }
        if (this.dbMetadataFile != null) {
            builder.dbMetadataFile(this.dbMetadataFile);
        }
        if (this.ontopViewFile != null) {
            builder.ontopViewFile(this.ontopViewFile);
        }
        OntopSQLOWLAPIConfiguration config = builder.build();
        OWLOntology ontology = null;
        try {
            ontology = config.loadProvidedInputOntology();
        }
        catch (OWLOntologyCreationException e) {
            System.out.format("ERROR: There is a problem loading the ontology file: %s\n", this.owlFile);
            e.printStackTrace();
            System.exit(1);
        }
        catch (Exception ex) {
            System.out.format("ERROR: QuestOWL reasoner cannot be initialized\n", new Object[0]);
            ex.printStackTrace();
            System.exit(1);
        }
        Set classIRIs = ontology.getClassesInSignature().stream().map(HasIRI::getIRI).collect(Collectors.toSet());
        Set opIRIs = ontology.getObjectPropertiesInSignature().stream().map(HasIRI::getIRI).collect(Collectors.toSet());
        Set dpIRIs = ontology.getDataPropertiesInSignature().stream().map(HasIRI::getIRI).collect(Collectors.toSet());
        ImmutableSet class_op_intersections = Sets.intersection(classIRIs, opIRIs).immutableCopy();
        ImmutableSet class_dp_intersections = Sets.intersection(classIRIs, dpIRIs).immutableCopy();
        ImmutableSet op_dp_intersections = Sets.intersection(opIRIs, dpIRIs).immutableCopy();
        boolean punning = false;
        if (class_op_intersections.size() > 0) {
            System.out.println();
            System.out.format("ERROR: Class and Object property name sets are not disjoint. Violations: \n", new Object[0]);
            class_op_intersections.forEach(x -> System.out.println("- <" + x + ">"));
            punning = true;
        }
        if (class_dp_intersections.size() > 0) {
            System.out.println();
            System.out.format("ERROR: Class and Data property name sets are not disjoint. Violations: \n", new Object[0]);
            class_dp_intersections.forEach(x -> System.out.println("- <" + x + ">"));
            punning = true;
        }
        if (op_dp_intersections.size() > 0) {
            System.out.println();
            System.out.format("ERROR: Object and Data property name sets are not disjoint. Violations: \n", new Object[0]);
            op_dp_intersections.forEach(x -> System.out.println("- <" + x + ">"));
            punning = true;
        }
        if (punning) {
            System.exit(1);
        }
        try {
            config.loadSpecification();
        }
        catch (OBDASpecificationException e) {
            System.out.format("ERROR: There is a problem loading the mapping file %s\n", this.mappingFile);
            e.printStackTrace();
            System.exit(1);
        }
        System.out.println("Validation completed");
    }
}

