/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.cli;

import com.github.rvesse.airline.annotations.Command;
import com.github.rvesse.airline.annotations.Option;
import com.github.rvesse.airline.annotations.OptionType;
import com.github.rvesse.airline.annotations.restrictions.Required;
import it.unibz.inf.ontop.cli.OntopCommand;
import it.unibz.inf.ontop.com.google.common.base.Strings;
import it.unibz.inf.ontop.injection.OntopSQLOWLAPIConfiguration;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPMapping;
import it.unibz.inf.ontop.spec.mapping.serializer.impl.OntopNativeMappingSerializer;
import java.io.File;

@Command(name="to-obda", description="Convert R2RML format to ontop native mapping format (.obda)")
public class OntopR2RMLToOBDA
implements OntopCommand {
    @Option(type=OptionType.COMMAND, name={"-i", "--input"}, title={"mapping.ttl"}, description="Input mapping file in R2RML format (.ttl)")
    @Required
    protected String inputMappingFile;
    @Option(type=OptionType.COMMAND, name={"-o", "--output"}, title={"mapping.obda"}, description="Output mapping file in Ontop native format (.obda)")
    protected String outputMappingFile;

    @Override
    public void run() {
        if (Strings.isNullOrEmpty((String)this.outputMappingFile)) {
            this.outputMappingFile = this.inputMappingFile.substring(this.inputMappingFile.lastIndexOf(".")).concat(".obda");
        }
        OntopSQLOWLAPIConfiguration configuration = ((OntopSQLOWLAPIConfiguration.Builder)((OntopSQLOWLAPIConfiguration.Builder)((OntopSQLOWLAPIConfiguration.Builder)((OntopSQLOWLAPIConfiguration.Builder)((OntopSQLOWLAPIConfiguration.Builder)OntopSQLOWLAPIConfiguration.defaultBuilder().r2rmlMappingFile(this.inputMappingFile)).jdbcName("h2")).jdbcUrl("jdbc:h2:tcp://localhost/DBName")).jdbcUser("username")).jdbcPassword("password")).build();
        OntopNativeMappingSerializer writer = new OntopNativeMappingSerializer();
        try {
            SQLPPMapping ppMapping = configuration.loadProvidedPPMapping();
            writer.write(new File(this.outputMappingFile), ppMapping);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

