/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.cli;

import com.github.rvesse.airline.annotations.Command;
import com.github.rvesse.airline.annotations.Option;
import com.github.rvesse.airline.annotations.OptionType;
import com.github.rvesse.airline.annotations.restrictions.Required;
import it.unibz.inf.ontop.cli.OntopCommand;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.WriterConfig;
import org.eclipse.rdf4j.rio.helpers.BasicWriterSettings;

@Command(name="pretty-r2rml", description="prettify R2RML file using Jena")
public class OntopR2RMLPrettify
implements OntopCommand {
    @Option(type=OptionType.COMMAND, name={"-i", "--input"}, title={"input.ttl"}, description="Input mapping file in the turtle R2RML format (.ttl)")
    @Required
    protected String inputMappingFile;
    @Option(type=OptionType.COMMAND, name={"-o", "--output"}, title={"pretty.ttl"}, description="Output mapping file in the turtle R2RML format (.ttl)")
    @Required
    protected String outputMappingFile;

    @Override
    public void run() {
        try {
            Model m = Rio.parse((InputStream)new FileInputStream(this.inputMappingFile), (String)"", (RDFFormat)RDFFormat.TURTLE, (Resource[])new Resource[0]);
            m.setNamespace("rr", "http://www.w3.org/ns/r2rml#");
            WriterConfig settings = new WriterConfig();
            settings.set(BasicWriterSettings.PRETTY_PRINT, (Object)true);
            settings.set(BasicWriterSettings.INLINE_BLANK_NODES, (Object)true);
            FileOutputStream os = new FileOutputStream(this.outputMappingFile);
            Rio.write((Iterable)m, (OutputStream)os, (RDFFormat)RDFFormat.TURTLE, (WriterConfig)settings);
            os.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

