/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.cli;

import com.github.rvesse.airline.annotations.Command;
import com.github.rvesse.airline.annotations.Option;
import com.github.rvesse.airline.annotations.OptionType;
import com.github.rvesse.airline.annotations.help.BashCompletion;
import com.github.rvesse.airline.annotations.restrictions.Required;
import com.github.rvesse.airline.help.cli.bash.CompletionBehaviour;
import it.unibz.inf.ontop.cli.OntopReasoningCommandBase;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.injection.OntopSQLOWLAPIConfiguration;
import it.unibz.inf.ontop.injection.OntopSystemOWLAPIConfiguration;
import it.unibz.inf.ontop.owlapi.OntopOWLFactory;
import it.unibz.inf.ontop.owlapi.OntopOWLReasoner;
import it.unibz.inf.ontop.owlapi.connection.OWLStatement;
import it.unibz.inf.ontop.owlapi.connection.OntopOWLConnection;
import it.unibz.inf.ontop.owlapi.resultset.OWLBindingSet;
import it.unibz.inf.ontop.owlapi.resultset.TupleOWLResultSet;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.io.ToStringRenderer;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;

@Command(name="query", description="Query the RDF graph exposed by the mapping and the OWL ontology")
public class OntopQuery
extends OntopReasoningCommandBase {
    @Option(type=OptionType.COMMAND, name={"-q", "--query"}, title={"queryFile"}, description="SPARQL SELECT query file")
    @BashCompletion(behaviour=CompletionBehaviour.FILENAMES)
    @Required
    private String queryFile;

    @Override
    public void run() {
        OWLOntology ontology;
        try {
            OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
            if (this.owlFile != null) {
                ontology = manager.loadOntologyFromOntologyDocument(new File(this.owlFile));
                if (this.disableReasoning) {
                    ontology = OntopQuery.extractDeclarations(ontology.getOWLOntologyManager(), ontology);
                }
            } else {
                ontology = manager.createOntology();
            }
        }
        catch (OWLOntologyCreationException e) {
            e.printStackTrace();
            return;
        }
        OntopSQLOWLAPIConfiguration.Builder configurationBuilder = (OntopSQLOWLAPIConfiguration.Builder)((OntopSQLOWLAPIConfiguration.Builder)((OntopSQLOWLAPIConfiguration.Builder)OntopSQLOWLAPIConfiguration.defaultBuilder().propertyFile(this.propertiesFile)).ontology(ontology)).enableOntologyAnnotationQuerying(this.enableAnnotations);
        if (this.isR2rmlFile(this.mappingFile)) {
            configurationBuilder.r2rmlMappingFile(this.mappingFile);
        } else {
            configurationBuilder.nativeOntopMappingFile(this.mappingFile);
        }
        if (this.dbMetadataFile != null) {
            configurationBuilder.dbMetadataFile(this.dbMetadataFile);
        }
        if (this.ontopViewFile != null) {
            configurationBuilder.ontopViewFile(this.ontopViewFile);
        }
        if (this.dbPassword != null) {
            configurationBuilder.jdbcPassword(this.dbPassword);
        }
        if (this.dbUrl != null) {
            configurationBuilder.jdbcUrl(this.dbUrl);
        }
        if (this.dbUser != null) {
            configurationBuilder.jdbcUser(this.dbUser);
        }
        OntopOWLFactory factory = OntopOWLFactory.defaultFactory();
        try (OntopOWLReasoner reasoner = factory.createReasoner((OntopSystemOWLAPIConfiguration)configurationBuilder.build());
             OntopOWLConnection conn = reasoner.getConnection();
             OWLStatement st = conn.createStatement();){
            String query = Files.lines(Paths.get(this.queryFile, new String[0]), StandardCharsets.UTF_8).collect(Collectors.joining("\n"));
            TupleOWLResultSet result = st.executeSelectQuery(query);
            OutputStream out = null;
            out = this.outputFile == null ? System.out : new FileOutputStream(new File(this.outputFile));
            OntopQuery.printResult(out, result);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public static void printResult(OutputStream out, TupleOWLResultSet result) throws Exception {
        BufferedWriter wr = new BufferedWriter(new OutputStreamWriter(out, "utf8"));
        List signature = result.getSignature();
        int columns = result.getColumnCount();
        for (int c = 0; c < columns; ++c) {
            String value = (String)signature.get(c);
            wr.append(value);
            if (c + 1 >= columns) continue;
            wr.append(",");
        }
        wr.newLine();
        while (result.hasNext()) {
            OWLBindingSet bindingSet = (OWLBindingSet)result.next();
            ImmutableList.Builder valueListBuilder = ImmutableList.builder();
            for (String columnName : signature) {
                valueListBuilder.add((Object)ToStringRenderer.getInstance().render(bindingSet.getOWLObject(columnName)));
            }
            wr.append(String.join((CharSequence)",", (Iterable<? extends CharSequence>)valueListBuilder.build()));
            wr.newLine();
        }
        wr.flush();
        result.close();
    }
}

