/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.cli;

import com.github.rvesse.airline.annotations.Command;
import com.github.rvesse.airline.annotations.Option;
import com.github.rvesse.airline.annotations.OptionType;
import com.github.rvesse.airline.annotations.help.BashCompletion;
import com.github.rvesse.airline.annotations.restrictions.Required;
import com.github.rvesse.airline.help.cli.bash.CompletionBehaviour;
import com.google.common.base.Strings;
import com.google.inject.Injector;
import it.unibz.inf.ontop.cli.OntopCommand;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.dbschema.DBMetadataProvider;
import it.unibz.inf.ontop.dbschema.MetadataLookup;
import it.unibz.inf.ontop.dbschema.MetadataProvider;
import it.unibz.inf.ontop.dbschema.OntopViewMetadataProvider;
import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.dbschema.QuotedIDFactory;
import it.unibz.inf.ontop.dbschema.SerializedMetadataProvider;
import it.unibz.inf.ontop.dbschema.impl.CachingMetadataLookup;
import it.unibz.inf.ontop.dbschema.impl.JDBCMetadataProviderFactory;
import it.unibz.inf.ontop.dbschema.impl.RawQuotedIDFactory;
import it.unibz.inf.ontop.exception.InvalidMappingSourceQueriesException;
import it.unibz.inf.ontop.exception.MetadataExtractionException;
import it.unibz.inf.ontop.injection.OntopSQLCredentialSettings;
import it.unibz.inf.ontop.injection.OntopSQLOWLAPIConfiguration;
import it.unibz.inf.ontop.injection.SQLPPMappingFactory;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.spec.mapping.TargetAtom;
import it.unibz.inf.ontop.spec.mapping.TargetAtomFactory;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPMapping;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPMappingConverter;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPTriplesMap;
import it.unibz.inf.ontop.spec.mapping.pp.impl.OntopNativeSQLPPTriplesMap;
import it.unibz.inf.ontop.spec.mapping.pp.impl.SQLPPMappingConverterImpl;
import it.unibz.inf.ontop.spec.mapping.serializer.impl.R2RMLMappingSerializer;
import it.unibz.inf.ontop.spec.sqlparser.RAExpression;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.substitution.Var2VarSubstitution;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.LocalJDBCConnectionUtils;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@Command(name="to-r2rml", description="Convert ontop native mapping format (.obda) to R2RML format")
public class OntopOBDAToR2RML
implements OntopCommand {
    @Option(type=OptionType.COMMAND, name={"-i", "--input"}, title={"mapping.obda"}, description="Input mapping file in Ontop native format (.obda)")
    @Required
    @BashCompletion(behaviour=CompletionBehaviour.FILENAMES)
    private String inputMappingFile;
    @Option(type=OptionType.COMMAND, name={"-t", "--ontology"}, title={"ontology.owl"}, description="OWL ontology file")
    @BashCompletion(behaviour=CompletionBehaviour.FILENAMES)
    @Nullable
    private String owlFile;
    @Option(type=OptionType.COMMAND, name={"-o", "--output"}, title={"mapping.ttl"}, description="Output mapping file in R2RML format (.ttl)")
    @BashCompletion(behaviour=CompletionBehaviour.FILENAMES)
    private String outputMappingFile;
    @Option(type=OptionType.COMMAND, name={"-p", "--properties"}, title={"properties file"}, description="Properties file")
    @BashCompletion(behaviour=CompletionBehaviour.FILENAMES)
    @Nullable
    private String propertiesFile;
    @Option(type=OptionType.COMMAND, name={"-d", "--db-metadata"}, title={"db-metadata file"}, description="User-supplied db-metadata file")
    @BashCompletion(behaviour=CompletionBehaviour.FILENAMES)
    String dbMetadataFile;
    @Option(type=OptionType.COMMAND, name={"-v", "--ontop-views"}, title={"Ontop view file"}, description="User-supplied view file")
    @BashCompletion(behaviour=CompletionBehaviour.FILENAMES)
    String ontopViewFile;
    @Option(type=OptionType.COMMAND, name={"--force"}, title={"Force the conversion"}, description="Force the conversion in the absence of DB metadata", arity=0)
    @BashCompletion(behaviour=CompletionBehaviour.FILENAMES)
    @Nullable
    private Boolean force;

    @Override
    public void run() {
        if (Strings.isNullOrEmpty((String)this.outputMappingFile)) {
            this.outputMappingFile = this.inputMappingFile.substring(0, this.inputMappingFile.length() - ".obda".length()).concat(".ttl");
        }
        OntopSQLOWLAPIConfiguration.Builder configBuilder = (OntopSQLOWLAPIConfiguration.Builder)OntopSQLOWLAPIConfiguration.defaultBuilder().nativeOntopMappingFile(this.inputMappingFile);
        if (!Strings.isNullOrEmpty((String)this.propertiesFile)) {
            configBuilder.propertyFile(this.propertiesFile);
        } else {
            ((OntopSQLOWLAPIConfiguration.Builder)((OntopSQLOWLAPIConfiguration.Builder)((OntopSQLOWLAPIConfiguration.Builder)configBuilder.jdbcDriver("dummy")).jdbcUrl("dummy")).jdbcUser("")).jdbcPassword("");
        }
        if (!Strings.isNullOrEmpty((String)this.owlFile)) {
            configBuilder.ontologyFile(this.owlFile);
        }
        OntopSQLOWLAPIConfiguration config = configBuilder.build();
        try {
            SQLPPMapping ppMapping = this.extractAndNormalizePPMapping(config);
            R2RMLMappingSerializer converter = new R2RMLMappingSerializer(config.getRdfFactory());
            converter.write(new File(this.outputMappingFile), ppMapping);
            System.out.println("R2RML mapping file " + this.outputMappingFile + " written!");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private SQLPPMapping extractAndNormalizePPMapping(OntopSQLOWLAPIConfiguration config) throws Exception {
        SQLPPMapping ppMapping = config.loadProvidedPPMapping();
        if (!Strings.isNullOrEmpty((String)this.dbMetadataFile)) {
            return this.normalizeWithDBMetadataFile(ppMapping, config);
        }
        if (!Strings.isNullOrEmpty((String)this.propertiesFile)) {
            return this.normalizeByConnectingToDB(ppMapping, config);
        }
        if (this.force != null) {
            return ppMapping;
        }
        System.err.println("Access to DB metadata is required by default to respect column quoting rules of R2RML.\nPlease provide a properties file containing the info to connect to the database.\nSpecify the option --force to bypass this requirement.");
        System.exit(2);
        return null;
    }

    private SQLPPMapping normalizeWithDBMetadataFile(SQLPPMapping ppMapping, OntopSQLOWLAPIConfiguration config) throws IOException, MetadataExtractionException {
        try (FileReader dbMetadataReader = new FileReader(this.dbMetadataFile);){
            SerializedMetadataProvider dbMetadataProvider = ((SerializedMetadataProvider.Factory)config.getInjector().getInstance(SerializedMetadataProvider.Factory.class)).getMetadataProvider((Reader)dbMetadataReader);
            SQLPPMapping sQLPPMapping = this.normalize(ppMapping, (MetadataProvider)dbMetadataProvider, config);
            return sQLPPMapping;
        }
    }

    private SQLPPMapping normalizeByConnectingToDB(SQLPPMapping ppMapping, OntopSQLOWLAPIConfiguration config) throws MetadataExtractionException, SQLException, IOException {
        try (Connection connection = LocalJDBCConnectionUtils.createConnection((OntopSQLCredentialSettings)config.getSettings());){
            JDBCMetadataProviderFactory metadataProviderFactory = (JDBCMetadataProviderFactory)config.getInjector().getInstance(JDBCMetadataProviderFactory.class);
            DBMetadataProvider dbMetadataProvider = metadataProviderFactory.getMetadataProvider(connection);
            SQLPPMapping sQLPPMapping = this.normalize(ppMapping, (MetadataProvider)dbMetadataProvider, config);
            return sQLPPMapping;
        }
    }

    private SQLPPMapping normalize(SQLPPMapping ppMapping, MetadataProvider dbMetadataProvider, OntopSQLOWLAPIConfiguration config) throws IOException, MetadataExtractionException {
        MetadataProvider metadataProvider;
        Injector injector = config.getInjector();
        if (!Strings.isNullOrEmpty((String)this.ontopViewFile)) {
            try (FileReader viewReader = new FileReader(this.ontopViewFile);){
                metadataProvider = ((OntopViewMetadataProvider.Factory)injector.getInstance(OntopViewMetadataProvider.Factory.class)).getMetadataProvider(dbMetadataProvider, (Reader)viewReader);
            }
        } else {
            metadataProvider = dbMetadataProvider;
        }
        CachingMetadataLookup metadataLookup = new CachingMetadataLookup(metadataProvider);
        OntopNativeMappingIdentifierNormalizer normalizer = new OntopNativeMappingIdentifierNormalizer(config, (MetadataLookup)metadataLookup);
        SQLPPMappingFactory sqlppMappingFactory = (SQLPPMappingFactory)injector.getInstance(SQLPPMappingFactory.class);
        return sqlppMappingFactory.createSQLPreProcessedMapping((ImmutableList)ppMapping.getTripleMaps().stream().map(x$0 -> normalizer.normalize(x$0)).collect(ImmutableCollectors.toList()), ppMapping.getPrefixManager());
    }

    private static class OntopNativeMappingIdentifierNormalizer {
        final SubstitutionFactory substitutionFactory;
        final TargetAtomFactory targetAtomFactory;
        final TermFactory termFactory;
        final SQLPPMappingConverterImpl converter;
        final MetadataLookup metadataLookup;
        final QuotedIDFactory idFactory;
        final QuotedIDFactory rawIdFactory;

        private OntopNativeMappingIdentifierNormalizer(OntopSQLOWLAPIConfiguration config, MetadataLookup metadataLookup) {
            this.substitutionFactory = (SubstitutionFactory)config.getInjector().getInstance(SubstitutionFactory.class);
            this.targetAtomFactory = (TargetAtomFactory)config.getInjector().getInstance(TargetAtomFactory.class);
            this.termFactory = config.getTermFactory();
            this.converter = (SQLPPMappingConverterImpl)config.getInjector().getInstance(SQLPPMappingConverter.class);
            this.metadataLookup = metadataLookup;
            this.idFactory = metadataLookup.getQuotedIDFactory();
            this.rawIdFactory = new RawQuotedIDFactory(this.idFactory);
        }

        private SQLPPTriplesMap normalize(SQLPPTriplesMap triplesMap) {
            try {
                RAExpression re = this.converter.getRAExpression(triplesMap, this.metadataLookup);
                ImmutableMap attributeMap = re.getUnqualifiedAttributes();
                Function<Variable, Optional> lookup = var -> {
                    QuotedID standardId = this.idFactory.createAttributeID(var.getName());
                    if (attributeMap.containsKey((Object)standardId)) {
                        return Optional.of(standardId);
                    }
                    QuotedID rawId = this.rawIdFactory.createAttributeID(var.getName());
                    if (attributeMap.containsKey((Object)rawId)) {
                        return Optional.of(rawId);
                    }
                    return Optional.empty();
                };
                return new OntopNativeSQLPPTriplesMap(triplesMap.getId(), triplesMap.getSourceQuery(), (ImmutableList)triplesMap.getTargetAtoms().stream().map(t -> this.normalize((TargetAtom)t, (Function<Variable, Optional<QuotedID>>)lookup)).collect(ImmutableCollectors.toList()));
            }
            catch (InvalidMappingSourceQueriesException e) {
                throw new RuntimeException(e);
            }
        }

        private TargetAtom normalize(TargetAtom target, Function<Variable, Optional<QuotedID>> lookup) {
            ImmutableMap targetPreMap = (ImmutableMap)target.getProjectionAtom().getArguments().stream().map(v -> target.getSubstitution().apply((ImmutableTerm)v)).flatMap(ImmutableTerm::getVariableStream).distinct().collect(ImmutableCollectors.toMap(Function.identity(), lookup));
            if (targetPreMap.values().stream().anyMatch(t -> !t.isPresent())) {
                throw new RuntimeException(targetPreMap.entrySet().stream().filter(e -> !((Optional)e.getValue()).isPresent()).map(Map.Entry::getKey).map(Variable::getName).collect(Collectors.joining(", ", "The placeholder(s) ", " in the target do(es) not occur in source query of the mapping assertion\n[" + target + "]")));
            }
            ImmutableMap targetMap = (ImmutableMap)targetPreMap.entrySet().stream().filter(e -> !((Variable)e.getKey()).getName().equals(((QuotedID)((Optional)e.getValue()).get()).getSQLRendering())).collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> this.termFactory.getVariable(((QuotedID)((Optional)e.getValue()).get()).getSQLRendering())));
            Var2VarSubstitution sub = this.substitutionFactory.getVar2VarSubstitution(targetMap);
            ImmutableSubstitution newSubtitution = sub.applyToTarget(target.getSubstitution());
            return this.targetAtomFactory.getTargetAtom(target.getProjectionAtom(), newSubtitution);
        }
    }
}

