/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.cli;

import com.github.rvesse.airline.annotations.Command;
import com.github.rvesse.airline.annotations.Option;
import com.github.rvesse.airline.annotations.OptionType;
import com.github.rvesse.airline.annotations.help.BashCompletion;
import com.github.rvesse.airline.annotations.restrictions.Required;
import com.github.rvesse.airline.help.cli.bash.CompletionBehaviour;
import it.unibz.inf.ontop.cli.OntopCommand;
import it.unibz.inf.ontop.com.google.common.base.Joiner;
import it.unibz.inf.ontop.com.google.common.base.Strings;
import it.unibz.inf.ontop.com.google.common.collect.BiMap;
import it.unibz.inf.ontop.com.google.common.collect.HashBiMap;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Scanner;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.URI;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.LiteralImpl;
import org.eclipse.rdf4j.model.impl.StatementImpl;
import org.eclipse.rdf4j.model.impl.URIImpl;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.Rio;

@Command(name="v1-to-v3", description="Clean mapping file (from Ontop v1) to be readable by Ontop v3. \nYou may still need to manually adjust the converted files. \nIt does the following jobs at our best effort: \n  (1) for Ontop native OBDA files, it extracts the jdbc connection info into a separate properties file\n  (2) for both Ontop native and R2RML files, for each full qualified columns (e.g `table1.col1`), it generates an alias (e.g `table1.col1 AS table1_col1`")
public class OntopMappingV1ToV3
implements OntopCommand {
    @Option(type=OptionType.COMMAND, name={"-m", "--mapping"}, title={"mapping file"}, description="Mapping file in R2RML (.ttl) or in Ontop native format (.obda)")
    @Required
    @BashCompletion(behaviour=CompletionBehaviour.FILENAMES)
    String mappingFile;
    @Option(type=OptionType.COMMAND, name={"-o", "--output"}, title={"mapping.obda"}, description="Output mapping file in R2RML (.ttl) or in Ontop native format (.obda)")
    @BashCompletion(behaviour=CompletionBehaviour.FILENAMES)
    protected String outputMappingFile;
    @Option(type=OptionType.COMMAND, name={"--simplify-projection"}, description="Replace projection with * whenever possible in SQL queries")
    protected boolean SIMPLIFY_SQL_PROJECTIONS;
    @Option(type=OptionType.COMMAND, name={"--overwrite"}, description="Overwrite the mapping file given as input")
    protected boolean overwriteFile;
    private final Pattern selectPattern = Pattern.compile("SELECT\\W.*\\WFROM", 34);
    private final Pattern asPattern = Pattern.compile("\\WAS\\W", 2);
    private final boolean PRETTY_PRINT = true;
    private final boolean REDUCE_TEMPLATES_TO_COLUMNS = true;
    private final boolean REPLACE_SIMPLE_SQL = true;

    @Override
    public void run() {
        try {
            boolean noOutputFile = Strings.isNullOrEmpty((String)this.outputMappingFile);
            if (noOutputFile && this.overwriteFile) {
                this.outputMappingFile = this.mappingFile + ".tmp";
            }
            Objects.requireNonNull(this.outputMappingFile, "Output mapping file cannot be null");
            File inputFile = new File(this.mappingFile);
            File outputFile = new File(this.outputMappingFile);
            if (this.mappingFile.endsWith(".obda")) {
                this.processOBDA(inputFile, outputFile);
            } else {
                this.processR2RML(outputFile);
            }
            if (this.overwriteFile) {
                if (!outputFile.renameTo(inputFile)) {
                    System.err.println("Could not rename the file");
                }
                this.outputMappingFile = inputFile.getName();
            }
            System.out.printf("New mapping file %s%n", this.outputMappingFile);
        }
        catch (Exception e) {
            System.err.println("Error occurred during v1-to-v3 mapping conversion: " + e.getMessage());
            System.err.println("Debugging information for developers: ");
            e.printStackTrace();
        }
    }

    public void processOBDA(File inputFile, File outputFile) throws Exception {
        BufferedWriter writer = new BufferedWriter(new FileWriter(outputFile));
        try (Scanner sc = new Scanner(inputFile);){
            while (sc.hasNextLine()) {
                String line = sc.nextLine();
                if (line.startsWith("[SourceDeclaration]")) {
                    if (this.overwriteFile) {
                        this.readSourceDeclaration(sc, this.mappingFile);
                        continue;
                    }
                    this.readSourceDeclaration(sc, this.outputMappingFile);
                    continue;
                }
                if (line.startsWith("mappingId")) {
                    String target = sc.nextLine();
                    String source = sc.nextLine();
                    if (!target.startsWith("target") || !source.startsWith("source")) {
                        System.err.println("ERROR: badly formatted " + line);
                        continue;
                    }
                    String mapping = line.substring("mappingId".length());
                    HashSet<String> args = new HashSet<String>();
                    for (String template : target.split("\\s")) {
                        args.addAll(this.getTemplateColumns(template));
                    }
                    String sql = source.substring("source".length());
                    String selectClause = this.extractMappingColumnsFromSQL(args, sql, mapping);
                    if (selectClause != null) {
                        HashBiMap renaming = HashBiMap.create();
                        HashMap<String, String> sqlRenaming = new HashMap<String, String>();
                        HashMap<String, Integer> duplicates = new HashMap<String, Integer>();
                        for (String arg : args) {
                            if (!arg.contains(".")) continue;
                            String chopped = arg.substring(arg.lastIndexOf(46) + 1);
                            if (duplicates.containsKey(chopped)) {
                                int count = (Integer)duplicates.get(chopped) + 1;
                                renaming.put((Object)arg, (Object)(chopped + count));
                                sqlRenaming.put(arg, arg + " AS " + chopped + count);
                                duplicates.put(chopped, count);
                                continue;
                            }
                            if (renaming.containsValue((Object)chopped)) {
                                String other = (String)renaming.inverse().get((Object)chopped);
                                renaming.put((Object)other, (Object)(chopped + "1"));
                                sqlRenaming.put(other, other + " AS " + chopped + "1");
                                duplicates.put(chopped, 2);
                                renaming.put((Object)arg, (Object)(chopped + "2"));
                                sqlRenaming.put(arg, arg + " AS " + chopped + "2");
                                continue;
                            }
                            renaming.put((Object)arg, (Object)chopped);
                            sqlRenaming.put(arg, arg + " AS " + chopped);
                        }
                        writer.write(line + System.getProperty("line.separator"));
                        String replacementSelectClause = this.getRenaming(sqlRenaming, selectClause, mapping);
                        String resultingSql = sql.replace(selectClause, replacementSelectClause);
                        if (this.SIMPLIFY_SQL_PROJECTIONS) {
                            resultingSql = this.getSimplifiedProjection(resultingSql);
                        }
                        for (Map.Entry r : renaming.entrySet()) {
                            target = target.replace("{" + (String)r.getKey() + "}", "{" + (String)r.getValue() + "}");
                        }
                        writer.write(target + System.getProperty("line.separator"));
                        writer.write("source" + resultingSql + System.getProperty("line.separator"));
                        continue;
                    }
                    System.err.println("ERROR: cannot find the SELECT clause in " + mapping);
                    continue;
                }
                writer.write(line + System.getProperty("line.separator"));
            }
        }
        writer.flush();
        writer.close();
    }

    private void readSourceDeclaration(Scanner sc, String f) throws IOException {
        String line;
        Properties dataSourceProperties = new Properties();
        while (!(line = sc.nextLine()).isEmpty()) {
            String inputParameter;
            String[] tokens = line.split("[\t| ]+", 2);
            String parameter = tokens[0].trim();
            String string = inputParameter = tokens.length > 1 ? tokens[1].trim() : "";
            if (parameter.equals(Label.sourceUri.name())) {
                dataSourceProperties.put("jdbc.name", inputParameter);
                continue;
            }
            if (parameter.equals(Label.connectionUrl.name())) {
                dataSourceProperties.put("jdbc.url", inputParameter);
                continue;
            }
            if (parameter.equals(Label.username.name())) {
                dataSourceProperties.put("jdbc.user", inputParameter);
                continue;
            }
            if (parameter.equals(Label.password.name())) {
                dataSourceProperties.put("jdbc.password", inputParameter);
                continue;
            }
            if (parameter.equals(Label.driverClass.name())) {
                dataSourceProperties.put("jdbc.driver", inputParameter);
                continue;
            }
            String msg = String.format("Unknown parameter name \"%s\"", parameter);
            throw new IOException(msg);
        }
        String propertyFilePath = f.substring(0, f.lastIndexOf(".")) + ".properties";
        try (FileOutputStream outputStream = new FileOutputStream(new File(propertyFilePath));){
            dataSourceProperties.store(outputStream, null);
        }
    }

    private void processR2RML(File outputFile) throws Exception {
        final BufferedWriter writer = new BufferedWriter(new FileWriter(outputFile));
        RDFParser parser = Rio.createParser((RDFFormat)RDFFormat.TURTLE);
        parser.setPreserveBNodeIDs(true);
        FileInputStream in = new FileInputStream(this.mappingFile);
        URL documentUrl = new URL("file://" + this.mappingFile);
        parser.setRDFHandler(new RDFHandler(){
            Map<BNode, List<Statement>> bmap = new HashMap<BNode, List<Statement>>();
            Map<Resource, Resource> logicalTable = new HashMap<Resource, Resource>();
            Map<Resource, String> sqlQuery = new HashMap<Resource, String>();
            Map<Resource, String> tableName = new HashMap<Resource, String>();
            Map<Resource, Resource> subjectMap = new HashMap<Resource, Resource>();
            Map<Resource, List<Resource>> predicateObjectMap = new HashMap<Resource, List<Resource>>();
            Map<Resource, List<Resource>> objectMap = new HashMap<Resource, List<Resource>>();
            Map<Resource, List<Resource>> predicateMap = new HashMap<Resource, List<Resource>>();
            Map<Resource, String> template = new HashMap<Resource, String>();
            Map<Resource, String> column = new HashMap<Resource, String>();
            Set<Resource> TripleMap = new HashSet<Resource>();
            List<Statement> statements = new ArrayList<Statement>();
            private final Map<String, String> PREFIXES = new HashMap<String, String>();
            private String pref = "    ";

            private void addToSetIgnoreSubject(List<Statement> list, Statement st) {
                for (Statement s : list) {
                    if (!s.getPredicate().equals((Object)st.getPredicate()) || !s.getObject().equals(st.getObject())) continue;
                    return;
                }
                list.add(st);
            }

            private void mergeBmapInto(Resource s, Resource t) {
                List<Statement> list = this.bmap.get(t);
                for (Statement statement : this.bmap.get(s)) {
                    this.addToSetIgnoreSubject(list, statement);
                }
            }

            public void startRDF() throws RDFHandlerException {
            }

            /*
             * WARNING - void declaration
             */
            public void endRDF() throws RDFHandlerException {
                try {
                    for (Resource resource : this.logicalTable.keySet()) {
                        this.performRenamingInTemplates(resource);
                    }
                    HashMap idmap = new HashMap();
                    for (Resource resource : this.TripleMap) {
                        String key;
                        Resource subj;
                        String tmpl;
                        Resource lt = this.logicalTable.get(resource);
                        String sql = this.sqlQuery.get(lt);
                        if (sql == null) {
                            sql = this.tableName.get(lt);
                        }
                        if ((tmpl = this.template.get(subj = this.subjectMap.get(resource))) == null) {
                            tmpl = this.column.get(subj);
                        }
                        if (!idmap.containsKey(key = sql + tmpl)) {
                            idmap.put(key, new ArrayList());
                        }
                        ((List)idmap.get(key)).add(resource);
                    }
                    ArrayList<Statement> arrayList = new ArrayList<Statement>();
                    for (List ids : idmap.values()) {
                        ids.sort(Comparator.comparing(this::outID));
                        Resource id = (Resource)ids.get(0);
                        String nid = id.toString();
                        nid = nid.substring(0, nid.length() - 5);
                        nid = nid + Joiner.on((String)"-").join((Iterable)ids.stream().map(i -> i.toString().substring(i.toString().length() - 5, i.toString().length())).collect(Collectors.toList()));
                        URIImpl to = new URIImpl(nid);
                        Resource lt = this.logicalTable.get(id);
                        this.logicalTable.put((Resource)to, lt);
                        Resource sm = this.subjectMap.get(id);
                        this.subjectMap.put((Resource)to, sm);
                        this.TripleMap.add((Resource)to);
                        for (Statement statement : this.statements) {
                            StatementImpl st;
                            Resource s2 = statement.getSubject();
                            if (!ids.contains(s2)) continue;
                            Value object = statement.getObject();
                            if (statement.getPredicate().toString().equals("http://www.w3.org/ns/r2rml#logicalTable")) {
                                this.mergeBmapInto((Resource)object, lt);
                                object = lt;
                            } else if (statement.getPredicate().toString().equals("http://www.w3.org/ns/r2rml#subjectMap")) {
                                this.mergeBmapInto((Resource)object, sm);
                                object = sm;
                            }
                            if (arrayList.contains(st = new StatementImpl((Resource)to, (URI)statement.getPredicate(), object))) continue;
                            arrayList.add((Statement)st);
                        }
                    }
                    arrayList.sort(Comparator.comparing(s -> s.getSubject().toString()).thenComparing(s -> s.getPredicate().toString()).thenComparing(s -> s.getObject().toString()));
                    this.statements = arrayList;
                    writer.write(System.lineSeparator());
                    Object var3_8 = null;
                    for (Statement statement : this.statements) {
                        void var3_9;
                        Resource subject = statement.getSubject();
                        if (!this.TripleMap.contains(subject)) continue;
                        if (subject.equals(var3_9)) {
                            writer.write(" ;" + System.lineSeparator() + "    " + this.out((Value)statement.getPredicate()) + " " + this.getO(statement));
                            continue;
                        }
                        if (var3_9 != null) {
                            writer.write(" ." + System.lineSeparator() + System.lineSeparator());
                        }
                        writer.write(this.outID(subject) + "\n    " + this.out((Value)statement.getPredicate()) + " " + this.getO(statement));
                        Resource resource = subject;
                    }
                    writer.write(" ." + System.lineSeparator());
                }
                catch (IOException e) {
                    System.err.println("Error during process: " + e.getMessage());
                    e.printStackTrace();
                }
            }

            public void handleNamespace(String s, String s1) throws RDFHandlerException {
                try {
                    writer.write("@prefix " + s + ": <" + s1 + "> .");
                    this.PREFIXES.put(s1, s + ":");
                }
                catch (IOException e) {
                    System.err.println("Error during process: " + e.getMessage());
                    e.printStackTrace();
                }
            }

            public void handleStatement(Statement statement) throws RDFHandlerException {
                String sql;
                String table;
                String template;
                if (statement.getPredicate().toString().equals("http://www.w3.org/ns/r2rml#template") && (template = statement.getObject().stringValue()).startsWith("{") && template.endsWith("}") && !template.substring(1, template.length() - 1).contains("{")) {
                    statement = new StatementImpl(statement.getSubject(), (URI)new URIImpl("http://www.w3.org/ns/r2rml#column"), (Value)new LiteralImpl(template.substring(1, template.length() - 1)));
                }
                if (statement.getPredicate().toString().equals("http://www.w3.org/ns/r2rml#sqlQuery") && (table = OntopMappingV1ToV3.this.extractSimpleTable(sql = statement.getObject().stringValue())) != null) {
                    statement = new StatementImpl(statement.getSubject(), (URI)new URIImpl("http://www.w3.org/ns/r2rml#tableName"), (Value)new LiteralImpl(table));
                }
                if (statement.getSubject() instanceof BNode) {
                    List list = this.bmap.computeIfAbsent((BNode)statement.getSubject(), k -> new ArrayList());
                    list.add(statement);
                }
                String predicate = statement.getPredicate().toString();
                Value object = statement.getObject();
                Resource subject = statement.getSubject();
                if (object instanceof URI && object.toString().equals("http://www.w3.org/ns/r2rml#TriplesMap")) {
                    this.TripleMap.add(subject);
                }
                switch (predicate) {
                    case "http://www.w3.org/ns/r2rml#logicalTable": {
                        this.logicalTable.put(subject, (Resource)object);
                        break;
                    }
                    case "http://www.w3.org/ns/r2rml#sqlQuery": {
                        this.sqlQuery.put(subject, object.stringValue());
                        break;
                    }
                    case "http://www.w3.org/ns/r2rml#tableName": {
                        this.tableName.put(subject, object.stringValue());
                        break;
                    }
                    case "http://www.w3.org/ns/r2rml#subjectMap": {
                        this.subjectMap.put(subject, (Resource)object);
                        break;
                    }
                    case "http://www.w3.org/ns/r2rml#column": {
                        this.column.put(subject, object.stringValue());
                        break;
                    }
                    case "http://www.w3.org/ns/r2rml#template": {
                        this.template.put(subject, object.stringValue());
                        break;
                    }
                    case "http://www.w3.org/ns/r2rml#predicateObjectMap": {
                        this.addToList(this.predicateObjectMap, subject, object);
                        break;
                    }
                    case "http://www.w3.org/ns/r2rml#objectMap": {
                        this.addToList(this.objectMap, subject, object);
                        break;
                    }
                    case "http://www.w3.org/ns/r2rml#predicateMap": {
                        this.addToList(this.predicateMap, subject, object);
                    }
                }
                this.statements.add(statement);
            }

            private void addToList(Map<Resource, List<Resource>> map, Resource subject, Value object) {
                List list = map.computeIfAbsent(subject, k -> new ArrayList());
                list.add((Resource)object);
            }

            private Set<String> getMappingColumnsFromTemplates(Resource mapping) {
                HashSet<String> columns = new HashSet<String>();
                this.extractMappingColumnsFromTemplates(columns, (List<Resource>)ImmutableList.of((Object)this.subjectMap.get(mapping)));
                List<Resource> pomaps = this.predicateObjectMap.get(mapping);
                if (pomaps != null) {
                    for (Resource pomap : pomaps) {
                        this.extractMappingColumnsFromTemplates(columns, this.predicateMap.get(pomap));
                        this.extractMappingColumnsFromTemplates(columns, this.objectMap.get(pomap));
                    }
                }
                return columns;
            }

            private void extractMappingColumnsFromTemplates(Set<String> args, List<Resource> resources) {
                if (resources != null) {
                    for (Resource resource : resources) {
                        String col;
                        String temp = this.template.get(resource);
                        if (temp != null) {
                            args.addAll(OntopMappingV1ToV3.this.getTemplateColumns(temp));
                        }
                        if ((col = this.column.get(resource)) == null) continue;
                        args.add(col);
                    }
                }
            }

            private void performRenamingInTemplates(Resource mapping) {
                String sql;
                Resource table = this.logicalTable.get(mapping);
                if (table != null && (sql = this.sqlQuery.get(table)) != null) {
                    Set<String> args = this.getMappingColumnsFromTemplates(mapping);
                    String selectClause = OntopMappingV1ToV3.this.extractMappingColumnsFromSQL(args, sql, this.outID(mapping));
                    if (selectClause != null) {
                        HashBiMap renaming = HashBiMap.create();
                        HashMap<String, String> sqlRenaming = new HashMap<String, String>();
                        HashMap<String, Integer> duplicates = new HashMap<String, Integer>();
                        for (String arg : args) {
                            if (!arg.contains(".")) continue;
                            String chopped = arg.substring(arg.lastIndexOf(46) + 1);
                            if (duplicates.containsKey(chopped)) {
                                int count = (Integer)duplicates.get(chopped) + 1;
                                renaming.put((Object)arg, (Object)(chopped + count));
                                sqlRenaming.put(arg, arg + " AS " + chopped + count);
                                duplicates.put(chopped, count);
                                continue;
                            }
                            if (renaming.containsValue((Object)chopped)) {
                                String other = (String)renaming.inverse().get((Object)chopped);
                                renaming.put((Object)other, (Object)(chopped + "1"));
                                sqlRenaming.put(other, other + " AS " + chopped + "1");
                                duplicates.put(chopped, 2);
                                renaming.put((Object)arg, (Object)(chopped + "2"));
                                sqlRenaming.put(arg, arg + " AS " + chopped + "2");
                                continue;
                            }
                            renaming.put((Object)arg, (Object)chopped);
                            sqlRenaming.put(arg, arg + " AS " + chopped);
                        }
                        String replacementSelectClause = OntopMappingV1ToV3.this.getRenaming(sqlRenaming, selectClause, this.outID(mapping));
                        String resultingSql = sql.replace(selectClause, replacementSelectClause);
                        if (OntopMappingV1ToV3.this.SIMPLIFY_SQL_PROJECTIONS) {
                            resultingSql = OntopMappingV1ToV3.this.getSimplifiedProjection(resultingSql);
                        }
                        this.sqlQuery.put(table, resultingSql);
                        this.performRenamingInTemplates((BiMap<String, String>)renaming, mapping);
                    } else {
                        System.err.println("ERROR: cannot find the SELECT clause for " + this.outID(mapping));
                    }
                }
            }

            private void performRenamingInTemplates(BiMap<String, String> renaming, Resource mapping) {
                this.performRenamingInTemplates(renaming, (List<Resource>)ImmutableList.of((Object)this.subjectMap.get(mapping)));
                List<Resource> pomaps = this.predicateObjectMap.get(mapping);
                if (pomaps != null) {
                    for (Resource resource : this.predicateObjectMap.get(mapping)) {
                        this.performRenamingInTemplates(renaming, this.predicateMap.get(resource));
                        this.performRenamingInTemplates(renaming, this.objectMap.get(resource));
                    }
                }
            }

            private void performRenamingInTemplates(BiMap<String, String> renaming, List<Resource> resources) {
                if (resources != null) {
                    for (Resource resource : resources) {
                        String t = this.template.get(resource);
                        if (t != null) {
                            for (Map.Entry r : renaming.entrySet()) {
                                t = t.replace("{" + (String)r.getKey() + "}", "{" + (String)r.getValue() + "}");
                            }
                            this.template.put(resource, t);
                        }
                        if ((t = this.column.get(resource)) == null) continue;
                        for (Map.Entry r : renaming.entrySet()) {
                            if (!t.equals(r.getKey())) continue;
                            t = (String)r.getValue();
                        }
                        this.column.put(resource, t);
                    }
                }
            }

            private String getO(Statement statement) {
                Value object;
                IRI predicate = statement.getPredicate();
                switch (predicate.toString()) {
                    case "http://www.w3.org/ns/r2rml#column": {
                        object = new LiteralImpl(this.column.get(statement.getSubject()));
                        break;
                    }
                    case "http://www.w3.org/ns/r2rml#template": {
                        object = new LiteralImpl(this.template.get(statement.getSubject()));
                        break;
                    }
                    case "http://www.w3.org/ns/r2rml#sqlQuery": {
                        object = new LiteralImpl(this.sqlQuery.get(statement.getSubject()));
                        break;
                    }
                    case "http://www.w3.org/ns/r2rml#tableName": {
                        object = new LiteralImpl(this.tableName.get(statement.getSubject()));
                        break;
                    }
                    default: {
                        object = statement.getObject();
                    }
                }
                return this.out(object);
            }

            private String outID(Resource resource) {
                if (resource instanceof URI) {
                    return this.out((Value)resource);
                }
                return resource.toString();
            }

            private String out(Value value) {
                if (value instanceof URI) {
                    String uri = ((URI)value).toString();
                    if (uri.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#type")) {
                        return "a";
                    }
                    for (Map.Entry<String, String> e : this.PREFIXES.entrySet()) {
                        if (!uri.startsWith(e.getKey())) continue;
                        return e.getValue() + uri.substring(e.getKey().length());
                    }
                    return "<" + uri + ">";
                }
                if (value instanceof BNode) {
                    String s = "";
                    String saved_pref = this.pref;
                    this.pref = this.pref + "    ";
                    List<Statement> list = this.bmap.get(value);
                    boolean first = true;
                    IRI current_pred = null;
                    for (Statement st : list) {
                        if (current_pred == st.getPredicate()) {
                            s = s + ", " + this.getO(st);
                            continue;
                        }
                        current_pred = st.getPredicate();
                        if (!first) {
                            s = s + " ;\n";
                        }
                        first = false;
                        s = s + this.pref + this.out((Value)current_pred) + " " + this.getO(st);
                    }
                    this.pref = saved_pref;
                    return "[\n" + s + "\n" + this.pref + "]";
                }
                if (value instanceof Literal) {
                    Literal literal = (Literal)value;
                    String s = literal.stringValue();
                    s = s.replace("\"", "\\\"");
                    s = "\"" + s + "\"";
                    return s;
                }
                return value.toString();
            }

            public void handleComment(String s) throws RDFHandlerException {
            }
        });
        parser.parse((InputStream)in, documentUrl.toString());
        writer.flush();
        writer.close();
    }

    protected Set<String> getTemplateColumns(String template) {
        HashSet<String> set = new HashSet<String>();
        int pos = 0;
        while ((pos = template.indexOf(123, pos)) != -1) {
            int endpos;
            if (pos > 0 && template.charAt(pos - 1) == '\\') {
                ++pos;
                continue;
            }
            do {
                if ((endpos = template.indexOf(125, pos)) != -1) continue;
                System.err.println("FAIL " + template + " AT " + pos);
                return set;
            } while (template.charAt(endpos - 1) == '\\');
            set.add(template.substring(pos + 1, endpos));
            ++pos;
        }
        return set;
    }

    protected String extractMappingColumnsFromSQL(Set<String> args, String sql, String mapping) {
        Matcher m = this.selectPattern.matcher(sql);
        if (m.find()) {
            String[] columns;
            String selectClause = m.group();
            String projection = selectClause.substring("SELECT ".length(), selectClause.length() - " FROM".length());
            for (String column : columns = projection.split(",")) {
                Matcher mp = this.asPattern.matcher(column);
                String alias = mp.find() ? column.substring(mp.end()) : column;
                alias = alias.replaceAll("\\s", "");
                args.add(alias);
            }
            return selectClause;
        }
        return null;
    }

    protected String getRenaming(Map<String, String> renaming, String selectClause, String mapping) {
        String replacementSelectClause = selectClause;
        for (Map.Entry<String, String> r : renaming.entrySet()) {
            Pattern p = Pattern.compile("\\b" + r.getKey() + "\\b", 32);
            Matcher mp = p.matcher(replacementSelectClause);
            if (mp.find()) {
                replacementSelectClause = mp.replaceFirst(r.getValue());
                continue;
            }
            System.err.println("ERROR: cannot find column " + r.getKey() + " in " + replacementSelectClause + " in mapping " + mapping);
        }
        return replacementSelectClause;
    }

    protected String getSimplifiedProjection(String sql) {
        try {
            Select select;
            PlainSelect plainSelect;
            net.sf.jsqlparser.statement.Statement statement = CCJSqlParserUtil.parse((String)sql);
            if (statement instanceof Select && (plainSelect = (PlainSelect)(select = (Select)statement).getSelectBody()).getJoins() == null) {
                boolean ok = true;
                for (SelectItem si : plainSelect.getSelectItems()) {
                    if (!(si instanceof SelectExpressionItem)) {
                        ok = false;
                        break;
                    }
                    SelectExpressionItem sei = (SelectExpressionItem)si;
                    if (sei.getAlias() == null) continue;
                    ok = false;
                    break;
                }
                if (ok) {
                    plainSelect.setSelectItems((List)ImmutableList.of((Object)new AllColumns()));
                    Matcher m = this.selectPattern.matcher(sql);
                    if (m.find()) {
                        String selectClause = m.group();
                        String projection = selectClause.substring("SELECT".length(), selectClause.length() - "FROM".length());
                        Pattern endSpaces = Pattern.compile("\\S\\s+\\z", 32);
                        Matcher es = endSpaces.matcher(projection);
                        if (es.find()) {
                            projection = projection.substring(0, projection.length() - es.group().length() + 1);
                        }
                        return sql.replace(projection, " *");
                    }
                }
            }
        }
        catch (JSQLParserException e) {
            e.printStackTrace();
        }
        return sql;
    }

    protected String extractSimpleTable(String sql) {
        try {
            Select select;
            PlainSelect plainSelect;
            net.sf.jsqlparser.statement.Statement statement = CCJSqlParserUtil.parse((String)sql);
            if (statement instanceof Select && (plainSelect = (PlainSelect)(select = (Select)statement).getSelectBody()).getJoins() == null) {
                boolean ok = true;
                for (SelectItem si : plainSelect.getSelectItems()) {
                    if (!(si instanceof SelectExpressionItem)) {
                        ok = false;
                        break;
                    }
                    SelectExpressionItem sei = (SelectExpressionItem)si;
                    if (sei.getAlias() == null) continue;
                    ok = false;
                    break;
                }
                if (ok && plainSelect.getWhere() == null) {
                    return ((Table)plainSelect.getFromItem()).getName();
                }
            }
        }
        catch (JSQLParserException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static enum Label {
        sourceUri,
        connectionUrl,
        username,
        password,
        driverClass,
        mappingId,
        target,
        source;

    }
}

