/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.cli;

import com.github.rvesse.airline.annotations.Option;
import com.github.rvesse.airline.annotations.OptionType;
import com.github.rvesse.airline.annotations.help.BashCompletion;
import com.github.rvesse.airline.help.cli.bash.CompletionBehaviour;
import it.unibz.inf.ontop.cli.OntopMappingOntologyRelatedCommand;
import java.util.Set;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;

public abstract class OntopReasoningCommandBase
extends OntopMappingOntologyRelatedCommand {
    @Option(type=OptionType.COMMAND, name={"--disable-reasoning"}, description="disable OWL reasoning. Default: false")
    public boolean disableReasoning = false;
    @Option(type=OptionType.COMMAND, name={"-x", "--xml-catalog"}, title="xml catalog file", description="XML Catalog file (e.g. catalog-v001.xml generated by Protege) for redirecting ontologies imported by owl:imports")
    @BashCompletion(behaviour=CompletionBehaviour.FILENAMES)
    String xmlCatalogFile;
    @Option(type=OptionType.COMMAND, name={"-o", "--output"}, title="output", description="output file (default)")
    protected String outputFile;
    @Option(type=OptionType.COMMAND, name={"--enable-annotations"}, description="enable annotation properties defined in the ontology. Default: false")
    public boolean enableAnnotations = false;

    protected static OWLOntology extractDeclarations(OWLOntologyManager manager, OWLOntology ontology) throws OWLOntologyCreationException {
        IRI ontologyIRI = (IRI)ontology.getOntologyID().getOntologyIRI().get();
        System.err.println("Ontology " + ontologyIRI);
        Set declarationAxioms = ontology.getAxioms(AxiomType.DECLARATION);
        manager.removeOntology(ontology);
        OWLOntology newOntology = manager.createOntology(ontologyIRI);
        manager.addAxioms(newOntology, declarationAxioms);
        return newOntology;
    }
}

