/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.cli;

import com.github.rvesse.airline.Cli;
import com.github.rvesse.airline.builder.CliBuilder;
import com.github.rvesse.airline.parser.errors.ParseArgumentsUnexpectedException;
import com.github.rvesse.airline.parser.errors.ParseCommandMissingException;
import com.github.rvesse.airline.parser.errors.ParseCommandUnrecognizedException;
import com.github.rvesse.airline.parser.errors.ParseException;
import com.github.rvesse.airline.parser.errors.ParseOptionMissingException;
import it.unibz.inf.ontop.cli.OntopBootstrap;
import it.unibz.inf.ontop.cli.OntopCommand;
import it.unibz.inf.ontop.cli.OntopCompile;
import it.unibz.inf.ontop.cli.OntopEndpoint;
import it.unibz.inf.ontop.cli.OntopExtractDBMetadata;
import it.unibz.inf.ontop.cli.OntopHelp;
import it.unibz.inf.ontop.cli.OntopMappingV1ToV3;
import it.unibz.inf.ontop.cli.OntopMaterialize;
import it.unibz.inf.ontop.cli.OntopOBDAToR2RML;
import it.unibz.inf.ontop.cli.OntopQuery;
import it.unibz.inf.ontop.cli.OntopR2RMLPrettify;
import it.unibz.inf.ontop.cli.OntopR2RMLToOBDA;
import it.unibz.inf.ontop.cli.OntopValidate;
import it.unibz.inf.ontop.cli.OntopVersion;

public class Ontop {
    public static void main(String ... args) {
        Cli<OntopCommand> ontopCommandCLI = Ontop.getOntopCommandCLI();
        try {
            OntopCommand command = (OntopCommand)ontopCommandCLI.parse(args);
            command.run();
        }
        catch (ParseCommandMissingException e) {
            Ontop.main("help");
        }
        catch (ParseCommandUnrecognizedException e) {
            System.err.println("Error: " + e.getMessage());
            System.err.println("Run `ontop help` to see the help");
        }
        catch (ParseArgumentsUnexpectedException | ParseOptionMissingException e) {
            System.err.println("Error: " + e.getMessage());
            String commandName = args[0];
            System.err.format("Run `ontop help %s` to see the help for the command `%s`\n", commandName, commandName);
        }
        catch (ParseException e) {
            System.err.println("Error: " + e.getMessage());
            System.err.println("Run `ontop help` to see the help");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static Cli<OntopCommand> getOntopCommandCLI() {
        CliBuilder builder = Cli.builder((String)"ontop").withDescription("Ontop system for Ontology based Data Access").withCommands(OntopVersion.class, new Class[]{OntopHelp.class, OntopQuery.class, OntopMaterialize.class, OntopBootstrap.class, OntopValidate.class, OntopEndpoint.class, OntopExtractDBMetadata.class, OntopCompile.class});
        builder.withGroup("mapping").withDescription("Manipulate mapping files").withCommand(OntopOBDAToR2RML.class).withCommand(OntopR2RMLToOBDA.class).withCommand(OntopR2RMLPrettify.class).withCommand(OntopMappingV1ToV3.class);
        return builder.build();
    }
}

