/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.cli;

import com.github.rvesse.airline.annotations.Command;
import com.github.rvesse.airline.annotations.Option;
import com.github.rvesse.airline.annotations.OptionType;
import com.github.rvesse.airline.annotations.restrictions.Required;
import com.google.common.base.Strings;
import it.unibz.inf.ontop.cli.OntopCommand;
import it.unibz.inf.ontop.injection.OntopSQLOWLAPIConfiguration;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPMapping;
import it.unibz.inf.ontop.spec.mapping.serializer.impl.OntopNativeMappingSerializer;
import java.io.File;
import java.util.Properties;

@Command(name="to-obda", description="Convert R2RML format to ontop native mapping format (.obda)")
public class OntopR2RMLToOBDA
implements OntopCommand {
    @Option(type=OptionType.COMMAND, name={"-i", "--input"}, title="mapping.ttl", description="Input mapping file in R2RML format (.ttl)")
    @Required
    protected String inputMappingFile;
    @Option(type=OptionType.COMMAND, name={"-o", "--output"}, title="mapping.obda", description="Output mapping file in Ontop native format (.obda)")
    protected String outputMappingFile;

    @Override
    public void run() {
        if (Strings.isNullOrEmpty((String)this.outputMappingFile)) {
            this.outputMappingFile = this.inputMappingFile.substring(this.inputMappingFile.lastIndexOf(".")).concat(".obda");
        }
        File out = new File(this.outputMappingFile);
        try {
            Properties p = new Properties();
            p.put("jdbc.name", "h2");
            p.put("jdbc.url", "jdbc:h2:tcp://localhost/DBName");
            p.put("jdbc.user", "username");
            p.put("jdbc.password", "password");
            p.put("jdbc.driver", "com.mysql.jdbc.Driver");
            OntopSQLOWLAPIConfiguration configuration = ((OntopSQLOWLAPIConfiguration.Builder)((OntopSQLOWLAPIConfiguration.Builder)OntopSQLOWLAPIConfiguration.defaultBuilder().r2rmlMappingFile(this.inputMappingFile)).properties(p)).build();
            SQLPPMapping ppMapping = configuration.loadProvidedPPMapping();
            OntopNativeMappingSerializer writer = new OntopNativeMappingSerializer(ppMapping);
            writer.save(out);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

