/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.cli;

import com.github.rvesse.airline.annotations.Command;
import com.github.rvesse.airline.annotations.Option;
import com.github.rvesse.airline.annotations.OptionType;
import com.github.rvesse.airline.annotations.help.BashCompletion;
import com.github.rvesse.airline.annotations.restrictions.Required;
import com.github.rvesse.airline.help.cli.bash.CompletionBehaviour;
import com.google.common.base.Strings;
import eu.optique.r2rml.api.binding.jena.JenaR2RMLMappingManager;
import it.unibz.inf.ontop.cli.OntopCommand;
import it.unibz.inf.ontop.exception.MappingException;
import it.unibz.inf.ontop.injection.OntopSQLOWLAPIConfiguration;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPMapping;
import it.unibz.inf.ontop.spec.mapping.serializer.SQLPPMappingToR2RMLConverter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import javax.annotation.Nullable;
import org.apache.commons.rdf.jena.JenaGraph;
import org.apache.commons.rdf.jena.JenaRDF;
import org.apache.jena.graph.Graph;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;

@Command(name="to-r2rml", description="Convert ontop native mapping format (.obda) to R2RML format")
public class OntopOBDAToR2RML
implements OntopCommand {
    @Option(type=OptionType.COMMAND, name={"-i", "--input"}, title="mapping.obda", description="Input mapping file in Ontop native format (.obda)")
    @Required
    @BashCompletion(behaviour=CompletionBehaviour.FILENAMES)
    private String inputMappingFile;
    @Option(type=OptionType.COMMAND, name={"-t", "--ontology"}, title="ontology.owl", description="OWL ontology file")
    @BashCompletion(behaviour=CompletionBehaviour.FILENAMES)
    @Nullable
    private String owlFile;
    @Option(type=OptionType.COMMAND, name={"-o", "--output"}, title="mapping.ttl", description="Output mapping file in R2RML format (.ttl)")
    @BashCompletion(behaviour=CompletionBehaviour.FILENAMES)
    private String outputMappingFile;

    @Override
    public void run() {
        SQLPPMapping ppMapping;
        if (Strings.isNullOrEmpty((String)this.outputMappingFile)) {
            this.outputMappingFile = this.inputMappingFile.substring(0, this.inputMappingFile.length() - ".obda".length()).concat(".ttl");
        }
        File out = new File(this.outputMappingFile);
        OntopSQLOWLAPIConfiguration.Builder configBuilder = (OntopSQLOWLAPIConfiguration.Builder)((OntopSQLOWLAPIConfiguration.Builder)((OntopSQLOWLAPIConfiguration.Builder)((OntopSQLOWLAPIConfiguration.Builder)((OntopSQLOWLAPIConfiguration.Builder)OntopSQLOWLAPIConfiguration.defaultBuilder().nativeOntopMappingFile(this.inputMappingFile)).jdbcDriver("dummy")).jdbcUrl("dummy")).jdbcUser("")).jdbcPassword("");
        if (!Strings.isNullOrEmpty((String)this.owlFile)) {
            configBuilder.ontologyFile(this.owlFile);
        }
        OntopSQLOWLAPIConfiguration config = configBuilder.build();
        try {
            ppMapping = config.loadProvidedPPMapping();
        }
        catch (MappingException e) {
            e.printStackTrace();
            System.exit(1);
            return;
        }
        SQLPPMappingToR2RMLConverter converter = new SQLPPMappingToR2RMLConverter(ppMapping, config.getRdfFactory(), config.getTermFactory());
        Collection tripleMaps = converter.getTripleMaps();
        JenaR2RMLMappingManager mm = JenaR2RMLMappingManager.getInstance();
        JenaGraph jenaGraph = mm.exportMappings(tripleMaps);
        Graph graph = new JenaRDF().asJenaGraph((org.apache.commons.rdf.api.Graph)jenaGraph);
        try {
            RDFDataMgr.write((OutputStream)new FileOutputStream(out), (Graph)graph, (RDFFormat)RDFFormat.TURTLE_PRETTY);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        System.out.println("R2RML mapping file " + this.outputMappingFile + " written!");
    }
}

