/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.cli;

import com.github.rvesse.airline.annotations.Command;
import com.github.rvesse.airline.annotations.Option;
import com.github.rvesse.airline.annotations.OptionType;
import com.github.rvesse.airline.annotations.restrictions.AllowedValues;
import com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.cli.OntopReasoningCommandBase;
import it.unibz.inf.ontop.exception.OBDASpecificationException;
import it.unibz.inf.ontop.injection.OntopSQLOWLAPIConfiguration;
import it.unibz.inf.ontop.injection.OntopSystemConfiguration;
import it.unibz.inf.ontop.materialization.MaterializationParams;
import it.unibz.inf.ontop.rdf4j.materialization.RDF4JMaterializer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.rdf.api.IRI;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.query.GraphQueryResult;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.helpers.BasicWriterSettings;
import org.eclipse.rdf4j.rio.ntriples.NTriplesWriter;
import org.eclipse.rdf4j.rio.rdfxml.RDFXMLWriter;
import org.eclipse.rdf4j.rio.turtle.TurtleWriter;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;

@Command(name="materialize", description="Materialize the RDF graph exposed by the mapping and the OWL ontology")
public class OntopMaterialize
extends OntopReasoningCommandBase {
    private static final int TRIPLE_LIMIT_PER_FILE = 500000;
    private static final String RDF_XML = "rdfxml";
    private static final String TURTLE = "turtle";
    private static final String NTRIPLES = "ntriples";
    @Option(type=OptionType.COMMAND, override=true, name={"-o", "--output"}, title="output", description="output file (default) or prefix (only for --separate-files)")
    private String outputFile;
    @Option(type=OptionType.COMMAND, name={"-f", "--format"}, title="outputFormat", description="The format of the materialized ontology. Default: rdfxml")
    @AllowedValues(allowedValues={"rdfxml", "turtle", "ntriples"})
    public String format = "rdfxml";
    @Option(type=OptionType.COMMAND, name={"--separate-files"}, title="output to separate files", description="generating separate files for different classes/properties. This is useful for materializing large OBDA setting. Default: false.")
    public boolean separate = false;
    @Option(type=OptionType.COMMAND, name={"--no-streaming"}, title="do not execute streaming of results", description="All the SQL results of one big query will be stored in memory. Not recommended. Default: false.")
    private boolean noStream = false;
    private boolean doStreamResults = true;

    @Override
    public void run() {
        OutputSpec outputSpec;
        if (this.noStream) {
            this.doStreamResults = false;
        }
        RDF4JMaterializer materializer = this.createMaterializer();
        OutputSpec outputSpec2 = outputSpec = this.outputFile == null ? new OutputSpec(this.format) : new OutputSpec(this.outputFile, this.format);
        if (this.separate) {
            this.runWithSeparateFiles(materializer, outputSpec);
        } else {
            this.runWithSingleFile(materializer, outputSpec);
        }
    }

    private RDF4JMaterializer createMaterializer() {
        RDF4JMaterializer materializer;
        try {
            OWLOntology ontology = this.loadOntology();
            OntopSQLOWLAPIConfiguration materializerConfiguration = ((OntopSQLOWLAPIConfiguration.Builder)this.createAndInitConfigurationBuilder().ontology(ontology)).build();
            materializer = RDF4JMaterializer.defaultMaterializer((OntopSystemConfiguration)materializerConfiguration, (MaterializationParams)MaterializationParams.defaultBuilder().enableDBResultsStreaming(this.doStreamResults).build());
        }
        catch (OBDASpecificationException | OWLOntologyCreationException e) {
            throw new RuntimeException(e);
        }
        return materializer;
    }

    private OWLOntology loadOntology() throws OWLOntologyCreationException {
        if (this.owlFile != null) {
            OWLOntology ontology = OWLManager.createOWLOntologyManager().loadOntologyFromOntologyDocument(new File(this.owlFile));
            if (this.disableReasoning) {
                return OntopMaterialize.extractDeclarations(ontology.getOWLOntologyManager(), ontology);
            }
            return ontology;
        }
        return OWLManager.createOWLOntologyManager().createOntology();
    }

    private void runWithSingleFile(RDF4JMaterializer materializer, OutputSpec outputSpec) {
        BufferedWriter writer;
        int tripleCount = 0;
        long startTime = System.currentTimeMillis();
        GraphQueryResult result = materializer.materialize().evaluate();
        try {
            writer = outputSpec.createWriter(Optional.empty());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        System.out.println("NR of TRIPLES: " + (tripleCount += this.serializeTripleBatch(result, Optional.empty(), writer, outputSpec.createRDFHandler(writer))));
        long endTime = System.currentTimeMillis();
        long time = endTime - startTime;
        System.out.println("Elapsed time to materialize: " + time + " {ms}");
    }

    private void runWithSeparateFiles(RDF4JMaterializer materializer, OutputSpec outputSpec) {
        try {
            this.materializeClassesByFile(materializer, outputSpec);
            this.materializePropertiesByFile(materializer, outputSpec);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void materializeClassesByFile(RDF4JMaterializer materializer, OutputSpec outputSpec) throws Exception {
        ImmutableSet classes = materializer.getClasses();
        int total = classes.size();
        AtomicInteger i = new AtomicInteger();
        for (IRI c : classes) {
            this.serializePredicate(materializer, c, PredicateType.CLASS, i.incrementAndGet(), total, outputSpec);
        }
    }

    private void materializePropertiesByFile(RDF4JMaterializer materializer, OutputSpec outputSpec) throws Exception {
        ImmutableSet properties = materializer.getProperties();
        int total = properties.size();
        AtomicInteger i = new AtomicInteger();
        for (IRI p : properties) {
            this.serializePredicate(materializer, p, PredicateType.PROPERTY, i.incrementAndGet(), total, outputSpec);
        }
    }

    private void serializePredicate(RDF4JMaterializer materializer, IRI predicateIRI, PredicateType predicateType, int index, int total, OutputSpec outputSpec) throws Exception {
        long startTime = System.currentTimeMillis();
        System.err.println(String.format("Materializing %s (%d/%d)", predicateIRI, index, total));
        System.err.println("Starts writing triples into files.");
        int tripleCount = 0;
        int fileCount = 0;
        String fileSubstring = predicateIRI.toString().replaceAll("[^a-zA-Z0-9]", "_") + predicateType.getCode() + "_";
        GraphQueryResult result = materializer.materialize(ImmutableSet.of((Object)predicateIRI)).evaluate();
        while (result.hasNext()) {
            BufferedWriter writer = outputSpec.createWriter(Optional.of(fileSubstring + fileCount));
            tripleCount += this.serializeTripleBatch(result, Optional.of(500000), writer, outputSpec.createRDFHandler(writer));
            ++fileCount;
        }
        System.out.println("NR of TRIPLES: " + tripleCount);
        long endTime = System.currentTimeMillis();
        long time = endTime - startTime;
        System.out.println("Elapsed time to materialize: " + time + " {ms}");
    }

    private int serializeTripleBatch(GraphQueryResult result, Optional<Integer> limitPerFile, BufferedWriter writer, RDFHandler handler) throws IOException {
        int tripleCount;
        handler.startRDF();
        for (tripleCount = 0; result.hasNext() && (!limitPerFile.isPresent() || tripleCount < limitPerFile.get()); ++tripleCount) {
            handler.handleStatement((Statement)result.next());
        }
        handler.endRDF();
        writer.close();
        return tripleCount;
    }

    private OntopSQLOWLAPIConfiguration.Builder<? extends OntopSQLOWLAPIConfiguration.Builder> createAndInitConfigurationBuilder() {
        OntopSQLOWLAPIConfiguration.Builder configBuilder = OntopSQLOWLAPIConfiguration.defaultBuilder();
        if (this.isR2rmlFile(this.mappingFile)) {
            configBuilder.r2rmlMappingFile(this.mappingFile);
        } else {
            configBuilder.nativeOntopMappingFile(this.mappingFile);
        }
        return (OntopSQLOWLAPIConfiguration.Builder)((OntopSQLOWLAPIConfiguration.Builder)configBuilder.propertyFile(this.propertiesFile)).enableOntologyAnnotationQuerying(true);
    }

    private class OutputSpec {
        private final Optional<String> prefix;
        private final String format;

        private OutputSpec(String prefix, String format) {
            this.prefix = Optional.of(FilenameUtils.removeExtension((String)prefix));
            this.format = format;
        }

        private OutputSpec(String format) {
            this.prefix = Optional.empty();
            this.format = format;
        }

        private BufferedWriter createWriter(Optional<String> prefixExtension) throws IOException {
            if (this.prefix.isPresent()) {
                String suffix = this.getSuffix();
                return Files.newBufferedWriter(prefixExtension.isPresent() ? Paths.get(this.prefix.get(), prefixExtension.get() + suffix) : Paths.get(this.prefix.get() + suffix, new String[0]), Charset.forName("UTF-8"), new OpenOption[0]);
            }
            return new BufferedWriter(new OutputStreamWriter((OutputStream)System.out, "UTF-8"));
        }

        private String getSuffix() {
            switch (this.format) {
                case "rdfxml": {
                    return ".rdf";
                }
                case "turtle": {
                    return ".ttl";
                }
                case "ntriples": {
                    return ".nt";
                }
            }
            throw new RuntimeException("Unknown output format: " + this.format);
        }

        private RDFHandler createRDFHandler(BufferedWriter writer) {
            switch (this.format) {
                case "rdfxml": {
                    return new RDFXMLWriter((Writer)writer);
                }
                case "turtle": {
                    TurtleWriter tw = new TurtleWriter((Writer)writer);
                    tw.set(BasicWriterSettings.PRETTY_PRINT, (Object)false);
                    return tw;
                }
                case "ntriples": {
                    NTriplesWriter btw = new NTriplesWriter((Writer)writer);
                    btw.set(BasicWriterSettings.PRETTY_PRINT, (Object)false);
                    return btw;
                }
            }
            throw new RuntimeException("Unknown output format: " + this.format);
        }
    }

    private static enum PredicateType {
        CLASS("C"),
        PROPERTY("P");

        private final String code;

        private PredicateType(String code) {
            this.code = code;
        }

        public String getCode() {
            return this.code;
        }
    }
}

