/*
 * Decompiled with CFR 0.152.
 */
package jp.ndca.similarity.join;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.ndca.similarity.distance.Overlap;
import jp.ndca.similarity.join.AbstractSimilarityJoin;
import jp.ndca.similarity.join.IntItem;
import jp.ndca.similarity.join.IntLinkedInvertedIndex;
import jp.ndca.similarity.join.LinkedPositions;
import jp.ndca.similarity.join.StringItem;
import jp.ndca.similarity.join.StringLinkedInvertedIndex;

public class PPJoin
extends AbstractSimilarityJoin {
    private static final Overlap overlap = new Overlap();
    private static final int DEFAULT_MAX_DEPTH = 3;
    private boolean usePlus = false;
    private boolean useSortAtSearch = true;
    private boolean useSortAtExtractPairs = true;
    private boolean useSortAtExtractBulks = true;
    private int maxDepth = 3;
    private SearchBox box = new SearchBox();

    public boolean isUsePlus() {
        return this.usePlus;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public boolean isUseSortAtSearch() {
        return this.useSortAtSearch;
    }

    public boolean isUseSortAtExtractPairs() {
        return this.useSortAtExtractPairs;
    }

    public boolean isUseSortAtExtractBulks() {
        return this.useSortAtExtractBulks;
    }

    public void setUsePlus(boolean usePlus) {
        this.usePlus = usePlus;
    }

    public void setMaxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
    }

    public void setUseSortAtSearch(boolean useSortAtSearch) {
        this.useSortAtSearch = useSortAtSearch;
    }

    public void setUseSortAtExtractPairs(boolean useSortAtExtractPairs) {
        this.useSortAtExtractPairs = useSortAtExtractPairs;
    }

    public void setUseSortAtExtractBulks(boolean useSortAtExtractBulks) {
        this.useSortAtExtractBulks = useSortAtExtractBulks;
    }

    @Override
    public List<Map.Entry<StringItem, StringItem>> extractPairs(StringItem[] dataSet, double threshold) {
        this.validation(dataSet, threshold, this.useSortAtExtractPairs);
        double coeff = threshold / (1.0 + threshold);
        ArrayList<Map.Entry<StringItem, StringItem>> S = new ArrayList<Map.Entry<StringItem, StringItem>>();
        StringLinkedInvertedIndex index = new StringLinkedInvertedIndex();
        int dataSetSize = dataSet.length;
        int[] prefixLengths = new int[dataSetSize];
        int[] alpha = new int[dataSetSize];
        for (int xDataSetID = 0; xDataSetID < dataSetSize; ++xDataSetID) {
            int midPrefixLength;
            int ubound;
            int ySize;
            int yPos;
            StringItem y;
            int yID;
            LinkedPositions.Node next;
            LinkedPositions.Node node;
            LinkedPositions positions;
            int xPos;
            StringItem x = dataSet[xDataSetID];
            int[] A = new int[xDataSetID];
            int xSize = x.size();
            if (xSize == 0) continue;
            int maxPrefixLength = xSize - (int)Math.ceil((double)xSize * threshold) + 1;
            if (this.usePlus) {
                for (xPos = 0; xPos < maxPrefixLength; ++xPos) {
                    String w = x.get(xPos);
                    positions = index.get(w);
                    if (positions == null) continue;
                    node = positions.getRootNode();
                    while ((next = node.getNext()) != null) {
                        int h;
                        int hmax;
                        yID = next.getId();
                        if (A[yID] == Integer.MIN_VALUE) {
                            node = next;
                            continue;
                        }
                        y = dataSet[yID];
                        yPos = next.getPosition();
                        ySize = y.size();
                        if ((double)ySize < (double)xSize * threshold) {
                            next.remove();
                            continue;
                        }
                        alpha[yID] = (int)Math.ceil(coeff * (double)(ySize + xSize));
                        int n = yID;
                        A[n] = A[n] + 1;
                        ubound = Math.min(xSize - xPos, ySize - yPos) - 1;
                        if (A[yID] + ubound < alpha[yID]) {
                            A[yID] = Integer.MIN_VALUE;
                        } else if (A[yID] == 1 && (hmax = xSize + ySize - 2 * (int)Math.ceil(coeff * (double)(ySize + xSize)) - (xPos + yPos)) < (h = this.suffixFilter(x.getTokens(), xPos + 1, x.size() - xPos - 1, y.getTokens(), yPos + 1, y.size() - yPos - 1, hmax, 0))) {
                            A[yID] = Integer.MIN_VALUE;
                        }
                        node = next;
                    }
                }
            } else {
                for (xPos = 0; xPos < maxPrefixLength; ++xPos) {
                    String w = x.get(xPos);
                    positions = index.get(w);
                    if (positions == null) continue;
                    node = positions.getRootNode();
                    while ((next = node.getNext()) != null) {
                        yID = next.getId();
                        if (A[yID] == Integer.MIN_VALUE) {
                            node = next;
                            continue;
                        }
                        y = dataSet[yID];
                        yPos = next.getPosition();
                        ySize = y.size();
                        if ((double)ySize < (double)xSize * threshold) {
                            next.remove();
                            continue;
                        }
                        alpha[yID] = (int)Math.ceil(coeff * (double)(ySize + xSize));
                        int n = yID;
                        A[n] = A[n] + 1;
                        ubound = Math.min(xSize - xPos, ySize - yPos) - 1;
                        if (A[yID] + ubound < alpha[yID]) {
                            A[yID] = Integer.MIN_VALUE;
                        }
                        node = next;
                    }
                }
            }
            prefixLengths[xDataSetID] = midPrefixLength = xSize - (int)Math.ceil(2.0 * coeff * (double)xSize) + 1;
            this.veryfy(xDataSetID, dataSet, maxPrefixLength, A, prefixLengths, alpha, S);
            for (int xPos2 = 0; xPos2 < midPrefixLength; ++xPos2) {
                String w = x.get(xPos2);
                index.put(w, xDataSetID, xPos2);
            }
        }
        return S;
    }

    private int suffixFilter(String[] x, int xPos, int xLen, String[] y, int yPos, int yLen, int hmax, int d) {
        int or;
        int ol;
        if (this.maxDepth <= d || yLen == 0 || xLen == 0) {
            return Math.abs(yLen - xLen);
        }
        int halfLength = (int)Math.ceil(0.5 * (double)yLen);
        int ymid = yPos + halfLength - 1;
        String wy = y[ymid];
        int o = (int)Math.ceil(0.5 * (double)(hmax - Math.abs(yLen - xLen)));
        if (xLen < yLen) {
            ol = 1;
            or = 0;
        } else {
            ol = 0;
            or = 1;
        }
        int ylPos = yPos;
        int ylLen = halfLength - 1;
        int rLength = yLen - ylLen - 1;
        int yrPos = ymid + 1;
        int yrLen = rLength;
        Partition xPartition = this.partition(x, xPos, xLen, wy, xPos + halfLength - 1 - o - Math.abs(yLen - xLen) * ol, xPos + halfLength - 1 + o + Math.abs(yLen - xLen) * or);
        int f = xPartition.isRange;
        int diff = xPartition.notFind;
        int xlLen = xPartition.slLen;
        int xlPos = xPartition.slPos;
        int xrLen = xPartition.srLen;
        int xrPos = xPartition.srPos;
        if (f == 0) {
            return ++hmax;
        }
        int h = Math.abs(xlLen - ylLen) + Math.abs(xrLen - yrLen) + diff;
        if (hmax < h) {
            return h;
        }
        int next_d = d + 1;
        int hl = this.suffixFilter(x, xlPos, xlLen, y, ylPos, ylLen, hmax - Math.abs(xrLen - yrLen) - diff, next_d);
        h = hl + Math.abs(xrLen - yrLen) + diff;
        if (hmax < h) {
            return h;
        }
        int hr = this.suffixFilter(x, xrPos, xrLen, y, yrPos, yrLen, hmax - hl - diff, next_d);
        return hr + hl + diff;
    }

    private Partition partition(String[] x, int xPos, int xLen, String w, int l, int r) {
        int srPos;
        int srLen;
        int lastIndex = xPos + xLen - 1;
        if (l < xPos) {
            l = xPos;
        }
        if (lastIndex < r) {
            r = lastIndex;
        }
        String wl = x[l];
        String wr = x[r];
        if (w.compareTo(wl) < 0 || wr.compareTo(w) < 0) {
            Partition p = new Partition();
            p.slPos = xPos;
            p.slLen = 0;
            p.srPos = xPos;
            p.srLen = 0;
            p.isRange = 0;
            p.notFind = 1;
            return p;
        }
        this.binarySearch(x, w, l, r);
        Partition p = new Partition();
        int partioningPoint = this.box.position;
        int slLen = partioningPoint - xPos;
        int slPos = xPos;
        if (this.box.isfound) {
            srLen = xLen - slLen - 1;
            if (srLen < 0) {
                srLen = 0;
            }
            srPos = partioningPoint + 1;
            p.notFind = 0;
        } else {
            srLen = xLen - slLen;
            srPos = partioningPoint;
            p.notFind = 1;
        }
        p.isRange = 1;
        p.slLen = slLen;
        p.srLen = srLen;
        p.slPos = slPos;
        p.srPos = srPos;
        return p;
    }

    private void binarySearch(String[] x, String query, int start, int end) {
        int min = start;
        int max = end;
        while (min <= max) {
            int midd = (int)(0.5 * (double)(min + max));
            String w = x[midd];
            if (query.compareTo(w) == 0) {
                this.box.isfound = true;
                this.box.position = midd;
                return;
            }
            if (query.compareTo(w) < 0) {
                max = --midd;
                continue;
            }
            min = ++midd;
        }
        int index = start;
        if (start <= max) {
            index = ++max;
        }
        this.box.isfound = false;
        this.box.position = index;
    }

    private void veryfy(int xDataSetID, StringItem[] dataSet, int maxXPrefixLength, int[] A, int[] prefixLengths, int[] alpha, List<Map.Entry<StringItem, StringItem>> S) {
        StringItem x = dataSet[xDataSetID];
        String wx_lastPrefix = x.get(maxXPrefixLength - 1);
        for (int yDataSetID = 0; yDataSetID < xDataSetID; ++yDataSetID) {
            int unbound;
            if (A[yDataSetID] <= 0) continue;
            int overlapValue = A[yDataSetID];
            StringItem y = dataSet[yDataSetID];
            String wy_lastPrefix = y.get(prefixLengths[yDataSetID] - 1);
            if (wx_lastPrefix.compareTo(wy_lastPrefix) < 0) {
                unbound = A[yDataSetID] + x.size() - maxXPrefixLength;
                if (alpha[yDataSetID] <= unbound) {
                    overlapValue = (int)((double)overlapValue + overlap.calcByMerge((Comparable[])x.getTokens(), maxXPrefixLength, (Comparable[])y.getTokens(), A[yDataSetID]));
                }
            } else {
                unbound = A[yDataSetID] + y.size() - prefixLengths[yDataSetID];
                if (alpha[yDataSetID] <= unbound) {
                    overlapValue = (int)((double)overlapValue + overlap.calcByMerge((Comparable[])x.getTokens(), A[yDataSetID], (Comparable[])y.getTokens(), prefixLengths[yDataSetID]));
                }
            }
            if (alpha[yDataSetID] > overlapValue) continue;
            S.add(new AbstractMap.SimpleEntry<StringItem, StringItem>(x, y));
        }
    }

    @Override
    public List<StringItem> search(StringItem query, StringItem[] dataSet, double threshold) {
        LinkedPositions.Node next;
        this.validation(dataSet, threshold, this.useSortAtSearch);
        StringItem x = query;
        double coeff = threshold / (1.0 + threshold);
        ArrayList<StringItem> S = new ArrayList<StringItem>();
        int dataSetSize = dataSet.length;
        int[] prefixLengths = new int[dataSetSize];
        int[] alpha = new int[dataSetSize];
        int xSize = x.size();
        if (xSize == 0) {
            return S;
        }
        int xPrefixLength = xSize - (int)Math.ceil((double)xSize * threshold) + 1;
        HashSet<String> xPrefixSet = new HashSet<String>();
        for (int xPos = 0; xPos < xPrefixLength; ++xPos) {
            String w = x.get(xPos);
            xPrefixSet.add(w);
        }
        StringLinkedInvertedIndex index = new StringLinkedInvertedIndex();
        for (int dataSetID = 0; dataSetID < dataSetSize; ++dataSetID) {
            int yPrefixLength;
            StringItem y = dataSet[dataSetID];
            int ySize = y.size();
            if (ySize == 0 || (double)ySize < (double)xSize * threshold || (double)xSize < (double)ySize * threshold) continue;
            prefixLengths[dataSetID] = yPrefixLength = ySize - (int)Math.ceil(coeff * (double)(ySize + xSize)) + 1;
            for (int yPos = 0; yPos < yPrefixLength; ++yPos) {
                String w = y.get(yPos);
                if (!xPrefixSet.contains(w)) continue;
                index.put(w, dataSetID, yPos);
            }
        }
        int[] A = new int[dataSetSize];
        if (this.usePlus) {
            for (int xPos = 0; xPos < xPrefixLength; ++xPos) {
                String w = x.get(xPos);
                LinkedPositions positions = index.get(w);
                if (positions == null) continue;
                LinkedPositions.Node node = positions.getRootNode();
                while ((next = node.getNext()) != null) {
                    int h;
                    int hmax;
                    int yID = next.getId();
                    if (A[yID] == Integer.MIN_VALUE) {
                        node = next;
                        continue;
                    }
                    StringItem y = dataSet[yID];
                    int yPos = next.getPosition();
                    int ySize = y.size();
                    alpha[yID] = (int)Math.ceil(coeff * (double)(ySize + xSize));
                    int n = yID;
                    A[n] = A[n] + 1;
                    int unbound = Math.min(xSize - xPos, ySize - yPos) - 1;
                    if (A[yID] + unbound < alpha[yID]) {
                        A[yID] = Integer.MIN_VALUE;
                    } else if (A[yID] == 1 && (hmax = xSize + ySize - 2 * (int)Math.ceil(coeff * (double)(ySize + xSize)) - (xPos + yPos)) < (h = this.suffixFilter(x.getTokens(), xPos + 1, xSize - xPos - 1, y.getTokens(), yPos + 1, ySize - yPos - 1, hmax, 0))) {
                        A[yID] = Integer.MIN_VALUE;
                    }
                    node = next;
                }
            }
        } else {
            for (int xPos = 0; xPos < xPrefixLength; ++xPos) {
                String w = x.get(xPos);
                LinkedPositions positions = index.get(w);
                if (positions == null) continue;
                LinkedPositions.Node node = positions.getRootNode();
                while ((next = node.getNext()) != null) {
                    int yID = next.getId();
                    if (A[yID] == Integer.MIN_VALUE) {
                        node = next;
                        continue;
                    }
                    StringItem y = dataSet[yID];
                    int yPos = next.getPosition();
                    int ySize = y.size();
                    alpha[yID] = (int)Math.ceil(coeff * (double)(ySize + xSize));
                    int n = yID;
                    A[n] = A[n] + 1;
                    int unbound = Math.min(xSize - xPos, ySize - yPos) - 1;
                    if (A[yID] + unbound < alpha[yID]) {
                        A[yID] = Integer.MIN_VALUE;
                    }
                    node = next;
                }
            }
        }
        this.veryfy(x, xPrefixLength, dataSet, A, prefixLengths, alpha, S);
        return S;
    }

    private void veryfy(StringItem x, int xPrefixLengths, StringItem[] dataSet, int[] A, int[] prefixLengths, int[] alpha, Collection<StringItem> S) {
        String wx_lastPrefix = x.get(xPrefixLengths - 1);
        for (int yDataSetID = 0; yDataSetID < A.length; ++yDataSetID) {
            int unbound;
            if (A[yDataSetID] <= 0) continue;
            int overlapValue = A[yDataSetID];
            StringItem y = dataSet[yDataSetID];
            String wy_lastPrefix = y.get(prefixLengths[yDataSetID] - 1);
            if (wx_lastPrefix.compareTo(wy_lastPrefix) < 0) {
                unbound = A[yDataSetID] + x.size() - xPrefixLengths;
                if (alpha[yDataSetID] <= unbound) {
                    overlapValue = (int)((double)overlapValue + overlap.calcByMerge((Comparable[])x.getTokens(), xPrefixLengths, (Comparable[])y.getTokens(), A[yDataSetID]));
                }
            } else {
                unbound = A[yDataSetID] + y.size() - prefixLengths[yDataSetID];
                if (alpha[yDataSetID] <= unbound) {
                    overlapValue = (int)((double)overlapValue + overlap.calcByMerge((Comparable[])x.getTokens(), A[yDataSetID], (Comparable[])y.getTokens(), prefixLengths[yDataSetID]));
                }
            }
            if (alpha[yDataSetID] > overlapValue) continue;
            S.add(y);
        }
    }

    @Override
    public List<List<StringItem>> extractBulks(StringItem[] dataSet, double threshold) {
        this.validation(dataSet, threshold, this.useSortAtExtractBulks);
        double coff = threshold / (1.0 + threshold);
        IntOpenHashSet buffer = new IntOpenHashSet();
        ArrayList<List<StringItem>> result = new ArrayList<List<StringItem>>();
        StringLinkedInvertedIndex index = new StringLinkedInvertedIndex();
        int dataSetSize = dataSet.length;
        int[] prefixLengths = new int[dataSetSize];
        int[] alpha = new int[dataSetSize];
        for (int xDataSetID = 0; xDataSetID < dataSetSize; ++xDataSetID) {
            int midPrefixLength;
            boolean isUnioned;
            int ubound;
            int ySize;
            int yPos;
            StringItem y;
            int yID;
            LinkedPositions.Node next;
            int xPos;
            if (buffer.contains(xDataSetID)) continue;
            StringItem x = dataSet[xDataSetID];
            int[] A = new int[xDataSetID];
            int xSize = x.size();
            if (xSize == 0) {
                buffer.add(xDataSetID);
                continue;
            }
            int maxPrefixLength = xSize - (int)Math.ceil((double)xSize * threshold) + 1;
            if (this.usePlus) {
                for (xPos = 0; xPos < maxPrefixLength; ++xPos) {
                    String w = x.get(xPos);
                    LinkedPositions positions = index.get(w);
                    if (positions == null) continue;
                    LinkedPositions.Node node = positions.getRootNode();
                    while ((next = node.getNext()) != null) {
                        int h;
                        int hmax;
                        yID = next.getId();
                        if (buffer.contains(yID)) {
                            node = next;
                            continue;
                        }
                        if (A[yID] == Integer.MIN_VALUE) {
                            node = next;
                            continue;
                        }
                        y = dataSet[yID];
                        yPos = next.getPosition();
                        ySize = y.size();
                        if ((double)ySize < (double)xSize * threshold) {
                            next.remove();
                            continue;
                        }
                        alpha[yID] = (int)Math.ceil(coff * (double)(ySize + xSize));
                        int n = yID;
                        A[n] = A[n] + 1;
                        ubound = Math.min(xSize - xPos - 1, ySize - yPos - 1);
                        if (A[yID] + ubound < alpha[yID]) {
                            A[yID] = Integer.MIN_VALUE;
                        } else if (A[yID] == 1 && (hmax = xSize + ySize - 2 * (int)Math.ceil(coff * (double)(ySize + xSize) - (double)(xPos + yPos))) < (h = this.suffixFilter(x.getTokens(), xPos + 1, xSize - xPos - 1, y.getTokens(), yPos + 1, ySize - yPos - 1, hmax, 0))) {
                            A[yID] = Integer.MIN_VALUE;
                        }
                        node = next;
                    }
                }
            } else {
                for (xPos = 0; xPos < maxPrefixLength; ++xPos) {
                    String w = x.get(xPos);
                    LinkedPositions positions = index.get(w);
                    if (positions == null) continue;
                    LinkedPositions.Node node = positions.getRootNode();
                    while ((next = node.getNext()) != null) {
                        yID = next.getId();
                        if (buffer.contains(yID)) {
                            next.remove();
                            continue;
                        }
                        if (A[yID] == Integer.MIN_VALUE) {
                            node = next;
                            continue;
                        }
                        y = dataSet[yID];
                        yPos = next.getPosition();
                        ySize = y.size();
                        if ((double)ySize < (double)xSize * threshold) {
                            node = next;
                            continue;
                        }
                        alpha[yID] = (int)Math.ceil(coff * (double)(ySize + xSize));
                        int n = yID;
                        A[n] = A[n] + 1;
                        ubound = Math.min(xSize - xPos - 1, ySize - yPos - 1);
                        if (A[yID] + ubound < alpha[yID]) {
                            A[yID] = Integer.MIN_VALUE;
                        }
                        node = next;
                    }
                }
            }
            ArrayList<StringItem> S = new ArrayList<StringItem>();
            this.veryfy(xDataSetID, dataSet, maxPrefixLength, A, prefixLengths, alpha, S, (Set<Integer>)buffer);
            if (0 < S.size()) {
                buffer.add(xDataSetID);
                S.add(x);
                isUnioned = this.strUnion(S, result, threshold, buffer);
                if (isUnioned) continue;
                result.add(S);
                continue;
            }
            S.add(x);
            isUnioned = this.strUnion(S, result, threshold, buffer);
            if (isUnioned) continue;
            prefixLengths[xDataSetID] = midPrefixLength = xSize - (int)Math.ceil(2.0 * coff * (double)xSize) + 1;
            for (int xPos2 = 0; xPos2 < midPrefixLength; ++xPos2) {
                String w = x.get(xPos2);
                index.put(w, xDataSetID, xPos2);
            }
        }
        Collections.sort(result, new Comparator<List<StringItem>>(){

            @Override
            public int compare(List<StringItem> o1, List<StringItem> o2) {
                int size2;
                int size1 = o1.size();
                if (size1 < (size2 = o2.size())) {
                    return 1;
                }
                if (size2 < size1) {
                    return -1;
                }
                return 0;
            }
        });
        return result;
    }

    private void veryfy(int xDataSetID, StringItem[] dataSet, int maxXPrefixLength, int[] A, int[] prefixLengths, int[] alpha, List<StringItem> S, Set<Integer> buffer) {
        StringItem x = dataSet[xDataSetID];
        String wx_lastPrefix = x.get(maxXPrefixLength - 1);
        for (int yDataSetID = 0; yDataSetID < xDataSetID; ++yDataSetID) {
            int unbound;
            if (A[yDataSetID] <= 0) continue;
            int overlapValue = A[yDataSetID];
            StringItem y = dataSet[yDataSetID];
            String wy_lastPrefix = y.get(prefixLengths[yDataSetID] - 1);
            if (wx_lastPrefix.compareTo(wy_lastPrefix) < 0) {
                unbound = A[yDataSetID] + x.size() - maxXPrefixLength;
                if (alpha[yDataSetID] <= unbound) {
                    overlapValue = (int)((double)overlapValue + overlap.calcByMerge((Comparable[])x.getTokens(), maxXPrefixLength, (Comparable[])y.getTokens(), A[yDataSetID]));
                }
            } else {
                unbound = A[yDataSetID] + y.size() - prefixLengths[yDataSetID];
                if (alpha[yDataSetID] <= unbound) {
                    overlapValue = (int)((double)overlapValue + overlap.calcByMerge((Comparable[])x.getTokens(), A[yDataSetID], (Comparable[])y.getTokens(), prefixLengths[yDataSetID]));
                }
            }
            if (alpha[yDataSetID] > overlapValue) continue;
            S.add(y);
            buffer.add(yDataSetID);
        }
    }

    @Override
    public List<Map.Entry<IntItem, IntItem>> extractPairs(IntItem[] dataSet, double threshold) {
        this.validation(dataSet, threshold, this.useSortAtExtractPairs);
        double coeff = threshold / (1.0 + threshold);
        ArrayList<Map.Entry<IntItem, IntItem>> S = new ArrayList<Map.Entry<IntItem, IntItem>>();
        IntLinkedInvertedIndex index = new IntLinkedInvertedIndex();
        int dataSetSize = dataSet.length;
        int[] prefixLengths = new int[dataSetSize];
        int[] alpha = new int[dataSetSize];
        for (int xDataSetID = 0; xDataSetID < dataSetSize; ++xDataSetID) {
            int midPrefixLength;
            int ubound;
            int ySize;
            int yPos;
            IntItem y;
            int yID;
            LinkedPositions.Node next;
            LinkedPositions.Node node;
            int w;
            int xPos;
            IntItem x = dataSet[xDataSetID];
            int[] A = new int[xDataSetID];
            int xSize = x.size();
            if (xSize == 0) continue;
            int maxPrefixLength = xSize - (int)Math.ceil((double)xSize * threshold) + 1;
            if (this.usePlus) {
                for (xPos = 0; xPos < maxPrefixLength; ++xPos) {
                    w = x.get(xPos);
                    LinkedPositions positions = index.get(w);
                    if (positions == null) continue;
                    node = positions.getRootNode();
                    while ((next = node.getNext()) != null) {
                        int h;
                        int hmax;
                        yID = next.getId();
                        if (A[yID] == Integer.MIN_VALUE) {
                            node = next;
                            continue;
                        }
                        y = dataSet[yID];
                        yPos = next.getPosition();
                        ySize = y.size();
                        if ((double)ySize < (double)xSize * threshold) {
                            next.remove();
                            continue;
                        }
                        alpha[yID] = (int)Math.ceil(coeff * (double)(ySize + xSize));
                        int n = yID;
                        A[n] = A[n] + 1;
                        ubound = Math.min(xSize - xPos, ySize - yPos) - 1;
                        if (A[yID] + ubound < alpha[yID]) {
                            A[yID] = Integer.MIN_VALUE;
                        } else if (A[yID] == 1 && (hmax = xSize + ySize - 2 * (int)Math.ceil(coeff * (double)(ySize + xSize)) - (xPos + yPos)) < (h = this.suffixFilter(x.getTokens(), xPos + 1, x.size() - xPos - 1, y.getTokens(), yPos + 1, y.size() - yPos - 1, hmax, 0))) {
                            A[yID] = Integer.MIN_VALUE;
                        }
                        node = next;
                    }
                }
            } else {
                for (xPos = 0; xPos < maxPrefixLength; ++xPos) {
                    w = x.get(xPos);
                    LinkedPositions positions = index.get(w);
                    if (positions == null) continue;
                    node = positions.getRootNode();
                    while ((next = node.getNext()) != null) {
                        yID = next.getId();
                        if (A[yID] == Integer.MIN_VALUE) {
                            node = next;
                            continue;
                        }
                        y = dataSet[yID];
                        yPos = next.getPosition();
                        ySize = y.size();
                        if ((double)ySize < (double)xSize * threshold) {
                            next.remove();
                            continue;
                        }
                        alpha[yID] = (int)Math.ceil(coeff * (double)(ySize + xSize));
                        int n = yID;
                        A[n] = A[n] + 1;
                        ubound = Math.min(xSize - xPos, ySize - yPos) - 1;
                        if (A[yID] + ubound < alpha[yID]) {
                            A[yID] = Integer.MIN_VALUE;
                        }
                        node = next;
                    }
                }
            }
            prefixLengths[xDataSetID] = midPrefixLength = xSize - (int)Math.ceil(2.0 * coeff * (double)xSize) + 1;
            this.veryfy(xDataSetID, dataSet, maxPrefixLength, A, prefixLengths, alpha, S);
            for (int xPos2 = 0; xPos2 < midPrefixLength; ++xPos2) {
                int w2 = x.get(xPos2);
                index.put(w2, xDataSetID, xPos2);
            }
        }
        return S;
    }

    private int suffixFilter(int[] x, int xPos, int xLen, int[] y, int yPos, int yLen, int hmax, int d) {
        int or;
        int ol;
        if (this.maxDepth <= d || yLen == 0 || xLen == 0) {
            return Math.abs(yLen - xLen);
        }
        int halfLength = (int)Math.ceil(0.5 * (double)yLen);
        int ymid = yPos + halfLength - 1;
        int wy = y[ymid];
        int o = (int)Math.ceil(0.5 * (double)(hmax - Math.abs(yLen - xLen)));
        if (xLen < yLen) {
            ol = 1;
            or = 0;
        } else {
            ol = 0;
            or = 1;
        }
        int ylPos = yPos;
        int ylLen = halfLength - 1;
        int rLength = yLen - ylLen - 1;
        int yrPos = ymid + 1;
        int yrLen = rLength;
        Partition xPartition = this.partition(x, xPos, xLen, wy, xPos + halfLength - 1 - o - Math.abs(yLen - xLen) * ol, xPos + halfLength - 1 + o + Math.abs(yLen - xLen) * or);
        int f = xPartition.isRange;
        int diff = xPartition.notFind;
        int xlLen = xPartition.slLen;
        int xlPos = xPartition.slPos;
        int xrLen = xPartition.srLen;
        int xrPos = xPartition.srPos;
        if (f == 0) {
            return ++hmax;
        }
        int h = Math.abs(xlLen - ylLen) + Math.abs(xrLen - yrLen) + diff;
        if (hmax < h) {
            return h;
        }
        int next_d = d + 1;
        int hl = this.suffixFilter(x, xlPos, xlLen, y, ylPos, ylLen, hmax - Math.abs(xrLen - yrLen) - diff, next_d);
        h = hl + Math.abs(xrLen - yrLen) + diff;
        if (hmax < h) {
            return h;
        }
        int hr = this.suffixFilter(x, xrPos, xrLen, y, yrPos, yrLen, hmax - hl - diff, next_d);
        return hr + hl + diff;
    }

    private Partition partition(int[] x, int xPos, int xLen, int w, int l, int r) {
        int srPos;
        int srLen;
        int lastIndex = xPos + xLen - 1;
        if (l < xPos) {
            l = xPos;
        }
        if (lastIndex < r) {
            r = lastIndex;
        }
        int wl = x[l];
        int wr = x[r];
        if (w < wl || wr < w) {
            Partition p = new Partition();
            p.slPos = xPos;
            p.slLen = 0;
            p.srPos = xPos;
            p.srLen = 0;
            p.isRange = 0;
            p.notFind = 1;
            return p;
        }
        this.binarySearch(x, w, l, r);
        Partition p = new Partition();
        int partioningPoint = this.box.position;
        int slLen = partioningPoint - xPos;
        int slPos = xPos;
        if (this.box.isfound) {
            srLen = xLen - slLen - 1;
            if (srLen < 0) {
                srLen = 0;
            }
            srPos = partioningPoint + 1;
            p.notFind = 0;
        } else {
            srLen = xLen - slLen;
            srPos = partioningPoint;
            p.notFind = 1;
        }
        p.isRange = 1;
        p.slLen = slLen;
        p.srLen = srLen;
        p.slPos = slPos;
        p.srPos = srPos;
        return p;
    }

    private void binarySearch(int[] x, int query, int start, int end) {
        int min = start;
        int max = end;
        while (min <= max) {
            int midd = (int)(0.5 * (double)(min + max));
            int w = x[midd];
            if (query < w) {
                this.box.isfound = true;
                this.box.position = midd;
                return;
            }
            if (query < w) {
                max = --midd;
                continue;
            }
            min = ++midd;
        }
        int index = start;
        if (start <= max) {
            index = ++max;
        }
        this.box.isfound = false;
        this.box.position = index;
    }

    private void veryfy(int xDataSetID, IntItem[] dataSet, int maxXPrefixLength, int[] A, int[] prefixLengths, int[] alpha, List<Map.Entry<IntItem, IntItem>> S) {
        IntItem x = dataSet[xDataSetID];
        int wx_lastPrefix = x.get(maxXPrefixLength - 1);
        for (int yDataSetID = 0; yDataSetID < xDataSetID; ++yDataSetID) {
            int unbound;
            if (A[yDataSetID] <= 0) continue;
            int overlapValue = A[yDataSetID];
            IntItem y = dataSet[yDataSetID];
            int wy_lastPrefix = y.get(prefixLengths[yDataSetID] - 1);
            if (wx_lastPrefix < wy_lastPrefix) {
                unbound = A[yDataSetID] + x.size() - maxXPrefixLength;
                if (alpha[yDataSetID] <= unbound) {
                    overlapValue = (int)((double)overlapValue + overlap.calcByMerge(x.getTokens(), maxXPrefixLength, y.getTokens(), A[yDataSetID]));
                }
            } else {
                unbound = A[yDataSetID] + y.size() - prefixLengths[yDataSetID];
                if (alpha[yDataSetID] <= unbound) {
                    overlapValue = (int)((double)overlapValue + overlap.calcByMerge(x.getTokens(), A[yDataSetID], y.getTokens(), prefixLengths[yDataSetID]));
                }
            }
            if (alpha[yDataSetID] > overlapValue) continue;
            S.add(new AbstractMap.SimpleEntry<IntItem, IntItem>(x, y));
        }
    }

    @Override
    public List<IntItem> search(IntItem query, IntItem[] dataSet, double threshold) {
        int w;
        this.validation(dataSet, threshold, this.useSortAtSearch);
        IntItem x = query;
        double coeff = threshold / (1.0 + threshold);
        ArrayList<IntItem> S = new ArrayList<IntItem>();
        int dataSetSize = dataSet.length;
        int[] prefixLengths = new int[dataSetSize];
        int[] alpha = new int[dataSetSize];
        int xSize = x.size();
        if (xSize == 0) {
            return S;
        }
        int xPrefixLength = xSize - (int)Math.ceil((double)xSize * threshold) + 1;
        IntOpenHashSet xPrefixSet = new IntOpenHashSet();
        for (int xPos = 0; xPos < xPrefixLength; ++xPos) {
            int w2 = x.get(xPos);
            xPrefixSet.add(w2);
        }
        IntLinkedInvertedIndex index = new IntLinkedInvertedIndex();
        for (int dataSetID = 0; dataSetID < dataSetSize; ++dataSetID) {
            int yPrefixLength;
            IntItem y = dataSet[dataSetID];
            int ySize = y.size();
            if (ySize == 0 || (double)ySize < (double)xSize * threshold || (double)xSize < (double)ySize * threshold) continue;
            prefixLengths[dataSetID] = yPrefixLength = ySize - (int)Math.ceil(coeff * (double)(ySize + xSize)) + 1;
            for (int yPos = 0; yPos < yPrefixLength; ++yPos) {
                int w3 = y.get(yPos);
                if (!xPrefixSet.contains(w3)) continue;
                index.put(w3, dataSetID, yPos);
            }
        }
        int[] A = new int[dataSetSize];
        if (this.usePlus) {
            for (int xPos = 0; xPos < xPrefixLength; ++xPos) {
                LinkedPositions.Node next;
                w = x.get(xPos);
                LinkedPositions positions = index.get(w);
                if (positions == null) continue;
                LinkedPositions.Node node = positions.getRootNode();
                while ((next = node.getNext()) != null) {
                    int h;
                    int hmax;
                    int yID = next.getId();
                    if (A[yID] == Integer.MIN_VALUE) {
                        node = next;
                        continue;
                    }
                    IntItem y = dataSet[yID];
                    int yPos = next.getPosition();
                    int ySize = y.size();
                    alpha[yID] = (int)Math.ceil(coeff * (double)(ySize + xSize));
                    int n = yID;
                    A[n] = A[n] + 1;
                    int unbound = Math.min(xSize - xPos, ySize - yPos) - 1;
                    if (A[yID] + unbound < alpha[yID]) {
                        A[yID] = Integer.MIN_VALUE;
                    } else if (A[yID] == 1 && (hmax = xSize + ySize - 2 * (int)Math.ceil(coeff * (double)(ySize + xSize)) - (xPos + yPos)) < (h = this.suffixFilter(x.getTokens(), xPos + 1, xSize - xPos - 1, y.getTokens(), yPos + 1, ySize - yPos - 1, hmax, 0))) {
                        A[yID] = Integer.MIN_VALUE;
                    }
                    node = next;
                }
            }
        } else {
            for (int xPos = 0; xPos < xPrefixLength; ++xPos) {
                LinkedPositions.Node next;
                w = x.get(xPos);
                LinkedPositions positions = index.get(w);
                if (positions == null) continue;
                LinkedPositions.Node node = positions.getRootNode();
                while ((next = node.getNext()) != null) {
                    int yID = next.getId();
                    if (A[yID] == Integer.MIN_VALUE) {
                        node = next;
                        continue;
                    }
                    IntItem y = dataSet[yID];
                    int yPos = next.getPosition();
                    int ySize = y.size();
                    alpha[yID] = (int)Math.ceil(coeff * (double)(ySize + xSize));
                    int n = yID;
                    A[n] = A[n] + 1;
                    int unbound = Math.min(xSize - xPos, ySize - yPos) - 1;
                    if (A[yID] + unbound < alpha[yID]) {
                        A[yID] = Integer.MIN_VALUE;
                    }
                    node = next;
                }
            }
        }
        this.veryfy(x, xPrefixLength, dataSet, A, prefixLengths, alpha, S);
        return S;
    }

    private void veryfy(IntItem x, int xPrefixLengths, IntItem[] dataSet, int[] A, int[] prefixLengths, int[] alpha, Collection<IntItem> S) {
        int wx_lastPrefix = x.get(xPrefixLengths - 1);
        for (int yDataSetID = 0; yDataSetID < A.length; ++yDataSetID) {
            int unbound;
            if (A[yDataSetID] <= 0) continue;
            int overlapValue = A[yDataSetID];
            IntItem y = dataSet[yDataSetID];
            int wy_lastPrefix = y.get(prefixLengths[yDataSetID] - 1);
            if (wx_lastPrefix < wy_lastPrefix) {
                unbound = A[yDataSetID] + x.size() - xPrefixLengths;
                if (alpha[yDataSetID] <= unbound) {
                    overlapValue = (int)((double)overlapValue + overlap.calcByMerge(x.getTokens(), xPrefixLengths, y.getTokens(), A[yDataSetID]));
                }
            } else {
                unbound = A[yDataSetID] + y.size() - prefixLengths[yDataSetID];
                if (alpha[yDataSetID] <= unbound) {
                    overlapValue = (int)((double)overlapValue + overlap.calcByMerge(x.getTokens(), A[yDataSetID], y.getTokens(), prefixLengths[yDataSetID]));
                }
            }
            if (alpha[yDataSetID] > overlapValue) continue;
            S.add(y);
        }
    }

    @Override
    public List<List<IntItem>> extractBulks(IntItem[] dataSet, double threshold) {
        this.validation(dataSet, threshold, this.useSortAtExtractBulks);
        double coff = threshold / (1.0 + threshold);
        IntOpenHashSet buffer = new IntOpenHashSet();
        ArrayList<List<IntItem>> result = new ArrayList<List<IntItem>>();
        IntLinkedInvertedIndex index = new IntLinkedInvertedIndex();
        int dataSetSize = dataSet.length;
        int[] prefixLengths = new int[dataSetSize];
        int[] alpha = new int[dataSetSize];
        for (int xDataSetID = 0; xDataSetID < dataSetSize; ++xDataSetID) {
            int midPrefixLength;
            boolean isUnioned;
            int ubound;
            int ySize;
            int yPos;
            IntItem y;
            int yID;
            int w;
            int xPos;
            if (buffer.contains(xDataSetID)) continue;
            IntItem x = dataSet[xDataSetID];
            int[] A = new int[xDataSetID];
            int xSize = x.size();
            if (xSize == 0) {
                buffer.add(xDataSetID);
                continue;
            }
            int maxPrefixLength = xSize - (int)Math.ceil((double)xSize * threshold) + 1;
            if (this.usePlus) {
                for (xPos = 0; xPos < maxPrefixLength; ++xPos) {
                    LinkedPositions.Node next;
                    w = x.get(xPos);
                    LinkedPositions positions = index.get(w);
                    if (positions == null) continue;
                    LinkedPositions.Node node = positions.getRootNode();
                    while ((next = node.getNext()) != null) {
                        int h;
                        int hmax;
                        yID = next.getId();
                        if (buffer.contains(yID)) {
                            node = next;
                            continue;
                        }
                        if (A[yID] == Integer.MIN_VALUE) {
                            node = next;
                            continue;
                        }
                        y = dataSet[yID];
                        yPos = next.getPosition();
                        ySize = y.size();
                        if ((double)ySize < (double)xSize * threshold) {
                            next.remove();
                            continue;
                        }
                        alpha[yID] = (int)Math.ceil(coff * (double)(ySize + xSize));
                        int n = yID;
                        A[n] = A[n] + 1;
                        ubound = Math.min(xSize - xPos - 1, ySize - yPos - 1);
                        if (A[yID] + ubound < alpha[yID]) {
                            A[yID] = Integer.MIN_VALUE;
                        } else if (A[yID] == 1 && (hmax = xSize + ySize - 2 * (int)Math.ceil(coff * (double)(ySize + xSize) - (double)(xPos + yPos))) < (h = this.suffixFilter(x.getTokens(), xPos + 1, xSize - xPos - 1, y.getTokens(), yPos + 1, ySize - yPos - 1, hmax, 0))) {
                            A[yID] = Integer.MIN_VALUE;
                        }
                        node = next;
                    }
                }
            } else {
                for (xPos = 0; xPos < maxPrefixLength; ++xPos) {
                    LinkedPositions.Node next;
                    w = x.get(xPos);
                    LinkedPositions positions = index.get(w);
                    if (positions == null) continue;
                    LinkedPositions.Node node = positions.getRootNode();
                    while ((next = node.getNext()) != null) {
                        yID = next.getId();
                        if (buffer.contains(yID)) {
                            next.remove();
                            continue;
                        }
                        if (A[yID] == Integer.MIN_VALUE) {
                            node = next;
                            continue;
                        }
                        y = dataSet[yID];
                        yPos = next.getPosition();
                        ySize = y.size();
                        if ((double)ySize < (double)xSize * threshold) {
                            node = next;
                            continue;
                        }
                        alpha[yID] = (int)Math.ceil(coff * (double)(ySize + xSize));
                        int n = yID;
                        A[n] = A[n] + 1;
                        ubound = Math.min(xSize - xPos - 1, ySize - yPos - 1);
                        if (A[yID] + ubound < alpha[yID]) {
                            A[yID] = Integer.MIN_VALUE;
                        }
                        node = next;
                    }
                }
            }
            ArrayList<IntItem> S = new ArrayList<IntItem>();
            this.veryfy(xDataSetID, dataSet, maxPrefixLength, A, prefixLengths, alpha, S, buffer);
            if (0 < S.size()) {
                buffer.add(xDataSetID);
                S.add(x);
                isUnioned = this.intUnion(S, result, threshold, buffer);
                if (isUnioned) continue;
                result.add(S);
                continue;
            }
            S.add(x);
            isUnioned = this.intUnion(S, result, threshold, buffer);
            if (isUnioned) continue;
            prefixLengths[xDataSetID] = midPrefixLength = xSize - (int)Math.ceil(2.0 * coff * (double)xSize) + 1;
            for (int xPos2 = 0; xPos2 < midPrefixLength; ++xPos2) {
                int w2 = x.get(xPos2);
                index.put(w2, xDataSetID, xPos2);
            }
        }
        Collections.sort(result, new Comparator<List<IntItem>>(){

            @Override
            public int compare(List<IntItem> o1, List<IntItem> o2) {
                int size2;
                int size1 = o1.size();
                if (size1 < (size2 = o2.size())) {
                    return 1;
                }
                if (size2 < size1) {
                    return -1;
                }
                return 0;
            }
        });
        return result;
    }

    private void veryfy(int xDataSetID, IntItem[] dataSet, int maxXPrefixLength, int[] A, int[] prefixLengths, int[] alpha, List<IntItem> S, IntSet buffer) {
        IntItem x = dataSet[xDataSetID];
        int wx_lastPrefix = x.get(maxXPrefixLength - 1);
        for (int yDataSetID = 0; yDataSetID < xDataSetID; ++yDataSetID) {
            int unbound;
            if (A[yDataSetID] <= 0) continue;
            int overlapValue = A[yDataSetID];
            IntItem y = dataSet[yDataSetID];
            int wy_lastPrefix = y.get(prefixLengths[yDataSetID] - 1);
            if (wx_lastPrefix < wy_lastPrefix) {
                unbound = A[yDataSetID] + x.size() - maxXPrefixLength;
                if (alpha[yDataSetID] <= unbound) {
                    overlapValue = (int)((double)overlapValue + overlap.calcByMerge(x.getTokens(), maxXPrefixLength, y.getTokens(), A[yDataSetID]));
                }
            } else {
                unbound = A[yDataSetID] + y.size() - prefixLengths[yDataSetID];
                if (alpha[yDataSetID] <= unbound) {
                    overlapValue = (int)((double)overlapValue + overlap.calcByMerge(x.getTokens(), A[yDataSetID], y.getTokens(), prefixLengths[yDataSetID]));
                }
            }
            if (alpha[yDataSetID] > overlapValue) continue;
            S.add(y);
            buffer.add(yDataSetID);
        }
    }

    class SearchBox {
        boolean isfound;
        int position;

        SearchBox() {
        }
    }

    class Partition {
        int slPos;
        int slLen;
        int srPos;
        int srLen;
        int isRange;
        int notFind;

        Partition() {
        }
    }
}

