/*
 * Decompiled with CFR 0.152.
 */
package jp.ndca.similarity.distance;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class Overlap {
    public double calc(Object[] a, Object[] b) {
        int alen = a.length;
        int blen = b.length;
        HashSet<Object> set = new HashSet<Object>(alen + blen);
        set.addAll(Arrays.asList(a));
        set.addAll(Arrays.asList(b));
        return this.innerCalc(alen, blen, set.size());
    }

    public double calc(List<? extends Object> a, List<? extends Object> b) {
        int alen = a.size();
        int blen = b.size();
        HashSet<Object> set = new HashSet<Object>(alen + blen);
        set.addAll(a);
        set.addAll(b);
        return this.innerCalc(alen, blen, set.size());
    }

    public double calc(List<? extends Object> a, int offsetA, List<? extends Object> b, int offsetB) {
        int i;
        int alen = a.size() - offsetA;
        int blen = b.size() - offsetB;
        HashSet<Object> set = new HashSet<Object>();
        for (i = offsetA; i < a.size(); ++i) {
            set.add(a.get(i));
        }
        for (i = offsetB; i < b.size(); ++i) {
            set.add(b.get(i));
        }
        return this.innerCalc(alen, blen, set.size());
    }

    public <K> double calc(K[] a, int offsetA, K[] b, int offsetB) {
        int i;
        int alen = a.length - offsetA;
        int blen = b.length - offsetB;
        HashSet<K> set = new HashSet<K>();
        for (i = offsetA; i < a.length; ++i) {
            set.add(a[i]);
        }
        for (i = offsetB; i < b.length; ++i) {
            set.add(b[i]);
        }
        return this.innerCalc(alen, blen, set.size());
    }

    public <K extends Comparable<K>> double calcByMerge(K[] a, int offsetA, K[] b, int offsetB) {
        int overlap = 0;
        int i = offsetA;
        int j = offsetB;
        while (i < a.length && j < b.length) {
            if (a[i].equals(b[j])) {
                ++overlap;
                ++i;
                ++j;
                continue;
            }
            if (a[i].compareTo(b[j]) < 0) {
                ++i;
                continue;
            }
            ++j;
        }
        return overlap;
    }

    public double calcByMerge(int[] a, int offsetA, int[] b, int offsetB) {
        int overlap = 0;
        int i = offsetA;
        int j = offsetB;
        while (i < a.length && j < b.length) {
            if (a[i] == b[j]) {
                ++overlap;
                ++i;
                ++j;
                continue;
            }
            if (a[i] < b[j]) {
                ++i;
                continue;
            }
            ++j;
        }
        return overlap;
    }

    private double innerCalc(int alen, int blen, int union) {
        double intersection = alen + blen - union;
        return intersection;
    }
}

