/*
 * Decompiled with CFR 0.152.
 */
package jp.ndca.similarity.distance;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class Jaccard {
    public double calc(Object[] a, Object[] b) {
        int alen = a.length;
        int blen = b.length;
        HashSet<Object> set = new HashSet<Object>(alen + blen);
        set.addAll(Arrays.asList(a));
        set.addAll(Arrays.asList(b));
        return this.innerCalc(alen, blen, set.size());
    }

    public double calc(List<? extends Object> a, List<? extends Object> b) {
        int alen = a.size();
        int blen = b.size();
        HashSet<Object> set = new HashSet<Object>(alen + blen);
        set.addAll(a);
        set.addAll(b);
        return this.innerCalc(alen, blen, set.size());
    }

    public <K extends Comparable<K>> double calcByMerge(K[] a, K[] b) {
        return this.calcByMerge((Comparable[])a, 0, (Comparable[])b, 0);
    }

    public double calcByMerge(char[] a, char[] b) {
        return this.calcByMerge(a, 0, b, 0);
    }

    public double calcByMerge(int[] a, int[] b) {
        return this.calcByMerge(a, 0, b, 0);
    }

    public <K extends Comparable<K>> double calcByMerge(K[] a, int offsetA, K[] b, int offsetB) {
        int aLen = a.length - offsetA;
        int bLen = b.length - offsetB;
        int overlap = 0;
        int i = offsetA;
        int j = offsetB;
        while (i < a.length && j < b.length) {
            if (a[i].equals(b[j])) {
                ++overlap;
                ++i;
                ++j;
                continue;
            }
            if (a[i].compareTo(b[j]) < 0) {
                ++i;
                continue;
            }
            ++j;
        }
        return (double)overlap / (double)(aLen + bLen - overlap);
    }

    public double calcByMerge(char[] a, int offsetA, char[] b, int offsetB) {
        int aLen = a.length - offsetA;
        int bLen = b.length - offsetB;
        int overlap = 0;
        int i = offsetA;
        int j = offsetB;
        while (i < a.length && j < b.length) {
            if (a[i] == b[j]) {
                ++overlap;
                ++i;
                ++j;
                continue;
            }
            if (a[i] < b[j]) {
                ++i;
                continue;
            }
            ++j;
        }
        return (double)overlap / (double)(aLen + bLen - overlap);
    }

    public double calcByMerge(int[] a, int offsetA, int[] b, int offsetB) {
        int aLen = a.length - offsetA;
        int bLen = b.length - offsetB;
        int overlap = 0;
        int i = offsetA;
        int j = offsetB;
        while (i < a.length && j < b.length) {
            if (a[i] == b[j]) {
                ++overlap;
                ++i;
                ++j;
                continue;
            }
            if (a[i] < b[j]) {
                ++i;
                continue;
            }
            ++j;
        }
        return (double)overlap / (double)(aLen + bLen - overlap);
    }

    private double innerCalc(int alen, int blen, int union) {
        double overlap = alen + blen - union;
        if (overlap <= 0.0) {
            return 0.0;
        }
        return overlap / (double)union;
    }
}

