/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.shorts;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.booleans.BooleanArrays;
import it.unimi.dsi.fastutil.shorts.AbstractShortIterator;
import it.unimi.dsi.fastutil.shorts.AbstractShortSet;
import it.unimi.dsi.fastutil.shorts.ShortArrays;
import it.unimi.dsi.fastutil.shorts.ShortCollection;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import it.unimi.dsi.fastutil.shorts.ShortIterators;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShortOpenHashSet
extends AbstractShortSet
implements Serializable,
Cloneable,
Hash {
    public static final long serialVersionUID = 0L;
    private static final boolean ASSERTS = false;
    protected transient short[] key;
    protected transient boolean[] used;
    protected final float f;
    protected transient int n;
    protected transient int maxFill;
    protected transient int mask;
    protected int size;

    public ShortOpenHashSet(int expected, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f;
        this.n = HashCommon.arraySize(expected, f);
        this.mask = this.n - 1;
        this.maxFill = HashCommon.maxFill(this.n, f);
        this.key = new short[this.n];
        this.used = new boolean[this.n];
    }

    public ShortOpenHashSet(int expected) {
        this(expected, 0.75f);
    }

    public ShortOpenHashSet() {
        this(16, 0.75f);
    }

    public ShortOpenHashSet(Collection<? extends Short> c, float f) {
        this(c.size(), f);
        this.addAll(c);
    }

    public ShortOpenHashSet(Collection<? extends Short> c) {
        this(c, 0.75f);
    }

    public ShortOpenHashSet(ShortCollection c, float f) {
        this(c.size(), f);
        this.addAll(c);
    }

    public ShortOpenHashSet(ShortCollection c) {
        this(c, 0.75f);
    }

    public ShortOpenHashSet(ShortIterator i, float f) {
        this(16, f);
        while (i.hasNext()) {
            this.add(i.nextShort());
        }
    }

    public ShortOpenHashSet(ShortIterator i) {
        this(i, 0.75f);
    }

    public ShortOpenHashSet(Iterator<?> i, float f) {
        this(ShortIterators.asShortIterator(i), f);
    }

    public ShortOpenHashSet(Iterator<?> i) {
        this(ShortIterators.asShortIterator(i));
    }

    public ShortOpenHashSet(short[] a, int offset, int length, float f) {
        this(length < 0 ? 0 : length, f);
        ShortArrays.ensureOffsetLength(a, offset, length);
        for (int i = 0; i < length; ++i) {
            this.add(a[offset + i]);
        }
    }

    public ShortOpenHashSet(short[] a, int offset, int length) {
        this(a, offset, length, 0.75f);
    }

    public ShortOpenHashSet(short[] a, float f) {
        this(a, 0, a.length, f);
    }

    public ShortOpenHashSet(short[] a) {
        this(a, 0.75f);
    }

    @Override
    public boolean add(short k) {
        int pos = HashCommon.murmurHash3(k) & this.mask;
        while (this.used[pos]) {
            if (k == this.key[pos]) {
                return false;
            }
            pos = pos + 1 & this.mask;
        }
        this.used[pos] = true;
        this.key[pos] = k;
        if (++this.size >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return true;
    }

    protected final void shiftKeys(int pos) {
        while (true) {
            int last = pos;
            pos = last + 1 & this.mask;
            while (this.used[pos]) {
                int slot = HashCommon.murmurHash3(this.key[pos]) & this.mask;
                if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                pos = pos + 1 & this.mask;
            }
            if (!this.used[pos]) break;
            this.key[last] = this.key[pos];
        }
        this.used[last] = false;
    }

    @Override
    public boolean remove(short k) {
        int pos = HashCommon.murmurHash3(k) & this.mask;
        while (this.used[pos]) {
            if (k == this.key[pos]) {
                --this.size;
                this.shiftKeys(pos);
                return true;
            }
            pos = pos + 1 & this.mask;
        }
        return false;
    }

    @Override
    public boolean contains(short k) {
        int pos = HashCommon.murmurHash3(k) & this.mask;
        while (this.used[pos]) {
            if (k == this.key[pos]) {
                return true;
            }
            pos = pos + 1 & this.mask;
        }
        return this.used[pos];
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        BooleanArrays.fill(this.used, false);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Deprecated
    public void growthFactor(int growthFactor) {
    }

    @Deprecated
    public int growthFactor() {
        return 16;
    }

    @Override
    public ShortIterator iterator() {
        return new SetIterator();
    }

    @Deprecated
    public boolean rehash() {
        return true;
    }

    public boolean trim() {
        int l = HashCommon.arraySize(this.size, this.f);
        if (l >= this.n) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n) {
        int l = HashCommon.nextPowerOfTwo((int)Math.ceil((float)n / this.f));
        if (this.n <= l) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(int newN) {
        int i = 0;
        boolean[] used = this.used;
        short[] key = this.key;
        int newMask = newN - 1;
        short[] newKey = new short[newN];
        boolean[] newUsed = new boolean[newN];
        int j = this.size;
        while (j-- != 0) {
            while (!used[i]) {
                ++i;
            }
            short k = key[i];
            int pos = HashCommon.murmurHash3(k) & newMask;
            while (newUsed[pos]) {
                pos = pos + 1 & newMask;
            }
            newUsed[pos] = true;
            newKey[pos] = k;
            ++i;
        }
        this.n = newN;
        this.mask = newMask;
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.key = newKey;
        this.used = newUsed;
    }

    public ShortOpenHashSet clone() {
        ShortOpenHashSet c;
        try {
            c = (ShortOpenHashSet)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.key = (short[])this.key.clone();
        c.used = (boolean[])this.used.clone();
        return c;
    }

    @Override
    public int hashCode() {
        int h = 0;
        int i = 0;
        int j = this.size;
        while (j-- != 0) {
            while (!this.used[i]) {
                ++i;
            }
            h += this.key[i];
            ++i;
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        ShortIterator i = this.iterator();
        s.defaultWriteObject();
        int j = this.size;
        while (j-- != 0) {
            s.writeShort(i.nextShort());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.n = HashCommon.arraySize(this.size, this.f);
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.mask = this.n - 1;
        this.key = new short[this.n];
        short[] key = this.key;
        this.used = new boolean[this.n];
        boolean[] used = this.used;
        int i = this.size;
        int pos = 0;
        while (i-- != 0) {
            short k = s.readShort();
            pos = HashCommon.murmurHash3(k) & this.mask;
            while (used[pos]) {
                pos = pos + 1 & this.mask;
            }
            used[pos] = true;
            key[pos] = k;
        }
    }

    private void checkTable() {
    }

    private class SetIterator
    extends AbstractShortIterator {
        int pos;
        int last;
        int c;

        private SetIterator() {
            this.pos = ShortOpenHashSet.this.n;
            this.last = -1;
            this.c = ShortOpenHashSet.this.size;
            boolean[] used = ShortOpenHashSet.this.used;
            if (this.c != 0) {
                while (!used[--this.pos]) {
                }
            }
        }

        public boolean hasNext() {
            return this.c != 0;
        }

        public short nextShort() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.last = this.pos;
            short retVal = ShortOpenHashSet.this.key[this.last];
            if (--this.c != 0) {
                boolean[] used = ShortOpenHashSet.this.used;
                while (!used[this.pos = this.pos - 1 & ShortOpenHashSet.this.mask]) {
                }
            }
            return retVal;
        }

        public void remove() {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            --ShortOpenHashSet.this.size;
            ShortOpenHashSet.this.shiftKeys(this.last);
            this.last = -1;
        }
    }
}

