/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.floats;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.booleans.BooleanArrays;
import it.unimi.dsi.fastutil.bytes.AbstractByteCollection;
import it.unimi.dsi.fastutil.bytes.ByteCollection;
import it.unimi.dsi.fastutil.bytes.ByteIterator;
import it.unimi.dsi.fastutil.floats.AbstractFloat2ByteMap;
import it.unimi.dsi.fastutil.floats.AbstractFloatSet;
import it.unimi.dsi.fastutil.floats.Float2ByteMap;
import it.unimi.dsi.fastutil.floats.FloatIterator;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Float2ByteOpenHashMap
extends AbstractFloat2ByteMap
implements Serializable,
Cloneable,
Hash {
    public static final long serialVersionUID = 0L;
    private static final boolean ASSERTS = false;
    protected transient float[] key;
    protected transient byte[] value;
    protected transient boolean[] used;
    protected final float f;
    protected transient int n;
    protected transient int maxFill;
    protected transient int mask;
    protected int size;
    protected volatile transient Float2ByteMap.FastEntrySet entries;
    protected volatile transient FloatSet keys;
    protected volatile transient ByteCollection values;

    public Float2ByteOpenHashMap(int expected, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f;
        this.n = HashCommon.arraySize(expected, f);
        this.mask = this.n - 1;
        this.maxFill = HashCommon.maxFill(this.n, f);
        this.key = new float[this.n];
        this.value = new byte[this.n];
        this.used = new boolean[this.n];
    }

    public Float2ByteOpenHashMap(int expected) {
        this(expected, 0.75f);
    }

    public Float2ByteOpenHashMap() {
        this(16, 0.75f);
    }

    public Float2ByteOpenHashMap(Map<? extends Float, ? extends Byte> m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Float2ByteOpenHashMap(Map<? extends Float, ? extends Byte> m) {
        this(m, 0.75f);
    }

    public Float2ByteOpenHashMap(Float2ByteMap m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Float2ByteOpenHashMap(Float2ByteMap m) {
        this(m, 0.75f);
    }

    public Float2ByteOpenHashMap(float[] k, byte[] v, float f) {
        this(k.length, f);
        if (k.length != v.length) {
            throw new IllegalArgumentException("The key array and the value array have different lengths (" + k.length + " and " + v.length + ")");
        }
        for (int i = 0; i < k.length; ++i) {
            this.put(k[i], v[i]);
        }
    }

    public Float2ByteOpenHashMap(float[] k, byte[] v) {
        this(k, v, 0.75f);
    }

    @Override
    public byte put(float k, byte v) {
        int pos = HashCommon.murmurHash3(HashCommon.float2int(k)) & this.mask;
        while (this.used[pos]) {
            if (k == this.key[pos]) {
                byte oldValue = this.value[pos];
                this.value[pos] = v;
                return oldValue;
            }
            pos = pos + 1 & this.mask;
        }
        this.used[pos] = true;
        this.key[pos] = k;
        this.value[pos] = v;
        if (++this.size >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return this.defRetValue;
    }

    @Override
    public Byte put(Float ok, Byte ov) {
        byte v = ov;
        float k = ok.floatValue();
        int pos = HashCommon.murmurHash3(HashCommon.float2int(k)) & this.mask;
        while (this.used[pos]) {
            if (k == this.key[pos]) {
                Byte oldValue = this.value[pos];
                this.value[pos] = v;
                return oldValue;
            }
            pos = pos + 1 & this.mask;
        }
        this.used[pos] = true;
        this.key[pos] = k;
        this.value[pos] = v;
        if (++this.size >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return null;
    }

    public byte add(float k, byte incr) {
        int pos = HashCommon.murmurHash3(HashCommon.float2int(k)) & this.mask;
        while (this.used[pos]) {
            if (k == this.key[pos]) {
                byte oldValue = this.value[pos];
                int n = pos;
                this.value[n] = (byte)(this.value[n] + incr);
                return oldValue;
            }
            pos = pos + 1 & this.mask;
        }
        this.used[pos] = true;
        this.key[pos] = k;
        this.value[pos] = (byte)(this.defRetValue + incr);
        if (++this.size >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return this.defRetValue;
    }

    protected final void shiftKeys(int pos) {
        while (true) {
            int last = pos;
            pos = last + 1 & this.mask;
            while (this.used[pos]) {
                int slot = HashCommon.murmurHash3(HashCommon.float2int(this.key[pos])) & this.mask;
                if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                pos = pos + 1 & this.mask;
            }
            if (!this.used[pos]) break;
            this.key[last] = this.key[pos];
            this.value[last] = this.value[pos];
        }
        this.used[last] = false;
    }

    @Override
    public byte remove(float k) {
        int pos = HashCommon.murmurHash3(HashCommon.float2int(k)) & this.mask;
        while (this.used[pos]) {
            if (k == this.key[pos]) {
                --this.size;
                byte v = this.value[pos];
                this.shiftKeys(pos);
                return v;
            }
            pos = pos + 1 & this.mask;
        }
        return this.defRetValue;
    }

    @Override
    public Byte remove(Object ok) {
        float k = ((Float)ok).floatValue();
        int pos = HashCommon.murmurHash3(HashCommon.float2int(k)) & this.mask;
        while (this.used[pos]) {
            if (k == this.key[pos]) {
                --this.size;
                byte v = this.value[pos];
                this.shiftKeys(pos);
                return v;
            }
            pos = pos + 1 & this.mask;
        }
        return null;
    }

    public Byte get(Float ok) {
        float k = ok.floatValue();
        int pos = HashCommon.murmurHash3(HashCommon.float2int(k)) & this.mask;
        while (this.used[pos]) {
            if (k == this.key[pos]) {
                return this.value[pos];
            }
            pos = pos + 1 & this.mask;
        }
        return null;
    }

    @Override
    public byte get(float k) {
        int pos = HashCommon.murmurHash3(HashCommon.float2int(k)) & this.mask;
        while (this.used[pos]) {
            if (k == this.key[pos]) {
                return this.value[pos];
            }
            pos = pos + 1 & this.mask;
        }
        return this.defRetValue;
    }

    @Override
    public boolean containsKey(float k) {
        int pos = HashCommon.murmurHash3(HashCommon.float2int(k)) & this.mask;
        while (this.used[pos]) {
            if (k == this.key[pos]) {
                return true;
            }
            pos = pos + 1 & this.mask;
        }
        return false;
    }

    @Override
    public boolean containsValue(byte v) {
        byte[] value = this.value;
        boolean[] used = this.used;
        int i = this.n;
        while (i-- != 0) {
            if (!used[i] || value[i] != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        BooleanArrays.fill(this.used, false);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Deprecated
    public void growthFactor(int growthFactor) {
    }

    @Deprecated
    public int growthFactor() {
        return 16;
    }

    public Float2ByteMap.FastEntrySet float2ByteEntrySet() {
        if (this.entries == null) {
            this.entries = new MapEntrySet();
        }
        return this.entries;
    }

    @Override
    public FloatSet keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    @Override
    public ByteCollection values() {
        if (this.values == null) {
            this.values = new AbstractByteCollection(){

                public ByteIterator iterator() {
                    return new ValueIterator();
                }

                public int size() {
                    return Float2ByteOpenHashMap.this.size;
                }

                public boolean contains(byte v) {
                    return Float2ByteOpenHashMap.this.containsValue(v);
                }

                public void clear() {
                    Float2ByteOpenHashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    @Deprecated
    public boolean rehash() {
        return true;
    }

    public boolean trim() {
        int l = HashCommon.arraySize(this.size, this.f);
        if (l >= this.n) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n) {
        int l = HashCommon.nextPowerOfTwo((int)Math.ceil((float)n / this.f));
        if (this.n <= l) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(int newN) {
        int i = 0;
        boolean[] used = this.used;
        float[] key = this.key;
        byte[] value = this.value;
        int newMask = newN - 1;
        float[] newKey = new float[newN];
        byte[] newValue = new byte[newN];
        boolean[] newUsed = new boolean[newN];
        int j = this.size;
        while (j-- != 0) {
            while (!used[i]) {
                ++i;
            }
            float k = key[i];
            int pos = HashCommon.murmurHash3(HashCommon.float2int(k)) & newMask;
            while (newUsed[pos]) {
                pos = pos + 1 & newMask;
            }
            newUsed[pos] = true;
            newKey[pos] = k;
            newValue[pos] = value[i];
            ++i;
        }
        this.n = newN;
        this.mask = newMask;
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.key = newKey;
        this.value = newValue;
        this.used = newUsed;
    }

    public Float2ByteOpenHashMap clone() {
        Float2ByteOpenHashMap c;
        try {
            c = (Float2ByteOpenHashMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.keys = null;
        c.values = null;
        c.entries = null;
        c.key = (float[])this.key.clone();
        c.value = (byte[])this.value.clone();
        c.used = (boolean[])this.used.clone();
        return c;
    }

    @Override
    public int hashCode() {
        int h = 0;
        int j = this.size;
        int i = 0;
        int t = 0;
        while (j-- != 0) {
            while (!this.used[i]) {
                ++i;
            }
            t = HashCommon.float2int(this.key[i]);
            h += (t ^= this.value[i]);
            ++i;
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        float[] key = this.key;
        byte[] value = this.value;
        MapIterator i = new MapIterator();
        s.defaultWriteObject();
        int j = this.size;
        while (j-- != 0) {
            int e = i.nextEntry();
            s.writeFloat(key[e]);
            s.writeByte(value[e]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.n = HashCommon.arraySize(this.size, this.f);
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.mask = this.n - 1;
        this.key = new float[this.n];
        float[] key = this.key;
        this.value = new byte[this.n];
        byte[] value = this.value;
        this.used = new boolean[this.n];
        boolean[] used = this.used;
        int i = this.size;
        int pos = 0;
        while (i-- != 0) {
            float k = s.readFloat();
            byte v = s.readByte();
            pos = HashCommon.murmurHash3(HashCommon.float2int(k)) & this.mask;
            while (used[pos]) {
                pos = pos + 1 & this.mask;
            }
            used[pos] = true;
            key[pos] = k;
            value[pos] = v;
        }
    }

    private void checkTable() {
    }

    private final class ValueIterator
    extends MapIterator
    implements ByteIterator {
        public byte nextByte() {
            return Float2ByteOpenHashMap.this.value[this.nextEntry()];
        }

        public Byte next() {
            return Float2ByteOpenHashMap.this.value[this.nextEntry()];
        }
    }

    private final class KeySet
    extends AbstractFloatSet {
        private KeySet() {
        }

        public FloatIterator iterator() {
            return new KeyIterator();
        }

        public int size() {
            return Float2ByteOpenHashMap.this.size;
        }

        public boolean contains(float k) {
            return Float2ByteOpenHashMap.this.containsKey(k);
        }

        public boolean remove(float k) {
            int oldSize = Float2ByteOpenHashMap.this.size;
            Float2ByteOpenHashMap.this.remove(k);
            return Float2ByteOpenHashMap.this.size != oldSize;
        }

        public void clear() {
            Float2ByteOpenHashMap.this.clear();
        }
    }

    private final class KeyIterator
    extends MapIterator
    implements FloatIterator {
        public float nextFloat() {
            return Float2ByteOpenHashMap.this.key[this.nextEntry()];
        }

        public Float next() {
            return Float.valueOf(Float2ByteOpenHashMap.this.key[this.nextEntry()]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MapEntrySet
    extends AbstractObjectSet<Float2ByteMap.Entry>
    implements Float2ByteMap.FastEntrySet {
        private MapEntrySet() {
        }

        @Override
        public ObjectIterator<Float2ByteMap.Entry> iterator() {
            return new EntryIterator();
        }

        @Override
        public ObjectIterator<Float2ByteMap.Entry> fastIterator() {
            return new FastEntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            float k = ((Float)e.getKey()).floatValue();
            int pos = HashCommon.murmurHash3(HashCommon.float2int(k)) & Float2ByteOpenHashMap.this.mask;
            while (Float2ByteOpenHashMap.this.used[pos]) {
                if (k == Float2ByteOpenHashMap.this.key[pos]) {
                    return Float2ByteOpenHashMap.this.value[pos] == (Byte)e.getValue();
                }
                pos = pos + 1 & Float2ByteOpenHashMap.this.mask;
            }
            return false;
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            float k = ((Float)e.getKey()).floatValue();
            int pos = HashCommon.murmurHash3(HashCommon.float2int(k)) & Float2ByteOpenHashMap.this.mask;
            while (Float2ByteOpenHashMap.this.used[pos]) {
                if (k == Float2ByteOpenHashMap.this.key[pos]) {
                    Float2ByteOpenHashMap.this.remove(e.getKey());
                    return true;
                }
                pos = pos + 1 & Float2ByteOpenHashMap.this.mask;
            }
            return false;
        }

        @Override
        public int size() {
            return Float2ByteOpenHashMap.this.size;
        }

        @Override
        public void clear() {
            Float2ByteOpenHashMap.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FastEntryIterator
    extends MapIterator
    implements ObjectIterator<Float2ByteMap.Entry> {
        final AbstractFloat2ByteMap.BasicEntry entry;

        private FastEntryIterator() {
            this.entry = new AbstractFloat2ByteMap.BasicEntry(0.0f, 0);
        }

        @Override
        public AbstractFloat2ByteMap.BasicEntry next() {
            int e = this.nextEntry();
            this.entry.key = Float2ByteOpenHashMap.this.key[e];
            this.entry.value = Float2ByteOpenHashMap.this.value[e];
            return this.entry;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryIterator
    extends MapIterator
    implements ObjectIterator<Float2ByteMap.Entry> {
        private EntryIterator() {
        }

        @Override
        public Float2ByteMap.Entry next() {
            return new MapEntry(this.nextEntry());
        }
    }

    private class MapIterator {
        int pos;
        int last;
        int c;

        private MapIterator() {
            this.pos = Float2ByteOpenHashMap.this.n;
            this.last = -1;
            this.c = Float2ByteOpenHashMap.this.size;
            boolean[] used = Float2ByteOpenHashMap.this.used;
            if (this.c != 0) {
                while (!used[--this.pos]) {
                }
            }
        }

        public boolean hasNext() {
            return this.c != 0;
        }

        public int nextEntry() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.last = this.pos;
            if (--this.c != 0) {
                boolean[] used = Float2ByteOpenHashMap.this.used;
                while (!used[this.pos = this.pos - 1 & Float2ByteOpenHashMap.this.mask]) {
                }
            }
            return this.last;
        }

        public void remove() {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            --Float2ByteOpenHashMap.this.size;
            Float2ByteOpenHashMap.this.shiftKeys(this.last);
            this.last = -1;
        }

        public int skip(int n) {
            int i = n;
            while (i-- != 0 && this.hasNext()) {
                this.nextEntry();
            }
            return n - i - 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MapEntry
    implements Float2ByteMap.Entry,
    Map.Entry<Float, Byte> {
        private int index;

        MapEntry(int index) {
            this.index = index;
        }

        @Override
        public Float getKey() {
            return Float.valueOf(Float2ByteOpenHashMap.this.key[this.index]);
        }

        @Override
        public float getFloatKey() {
            return Float2ByteOpenHashMap.this.key[this.index];
        }

        @Override
        public Byte getValue() {
            return Float2ByteOpenHashMap.this.value[this.index];
        }

        @Override
        public byte getByteValue() {
            return Float2ByteOpenHashMap.this.value[this.index];
        }

        @Override
        public byte setValue(byte v) {
            byte oldValue = Float2ByteOpenHashMap.this.value[this.index];
            Float2ByteOpenHashMap.this.value[this.index] = v;
            return oldValue;
        }

        @Override
        public Byte setValue(Byte v) {
            return this.setValue((byte)v);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Float2ByteOpenHashMap.this.key[this.index] == ((Float)e.getKey()).floatValue() && Float2ByteOpenHashMap.this.value[this.index] == (Byte)e.getValue();
        }

        @Override
        public int hashCode() {
            return HashCommon.float2int(Float2ByteOpenHashMap.this.key[this.index]) ^ Float2ByteOpenHashMap.this.value[this.index];
        }

        public String toString() {
            return Float2ByteOpenHashMap.this.key[this.index] + "=>" + Float2ByteOpenHashMap.this.value[this.index];
        }
    }
}

