/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.doubles;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.booleans.BooleanArrays;
import it.unimi.dsi.fastutil.doubles.AbstractDouble2DoubleMap;
import it.unimi.dsi.fastutil.doubles.AbstractDoubleCollection;
import it.unimi.dsi.fastutil.doubles.AbstractDoubleSet;
import it.unimi.dsi.fastutil.doubles.Double2DoubleMap;
import it.unimi.dsi.fastutil.doubles.DoubleCollection;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Double2DoubleOpenHashMap
extends AbstractDouble2DoubleMap
implements Serializable,
Cloneable,
Hash {
    public static final long serialVersionUID = 0L;
    private static final boolean ASSERTS = false;
    protected transient double[] key;
    protected transient double[] value;
    protected transient boolean[] used;
    protected final float f;
    protected transient int n;
    protected transient int maxFill;
    protected transient int mask;
    protected int size;
    protected volatile transient Double2DoubleMap.FastEntrySet entries;
    protected volatile transient DoubleSet keys;
    protected volatile transient DoubleCollection values;

    public Double2DoubleOpenHashMap(int expected, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f;
        this.n = HashCommon.arraySize(expected, f);
        this.mask = this.n - 1;
        this.maxFill = HashCommon.maxFill(this.n, f);
        this.key = new double[this.n];
        this.value = new double[this.n];
        this.used = new boolean[this.n];
    }

    public Double2DoubleOpenHashMap(int expected) {
        this(expected, 0.75f);
    }

    public Double2DoubleOpenHashMap() {
        this(16, 0.75f);
    }

    public Double2DoubleOpenHashMap(Map<? extends Double, ? extends Double> m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Double2DoubleOpenHashMap(Map<? extends Double, ? extends Double> m) {
        this(m, 0.75f);
    }

    public Double2DoubleOpenHashMap(Double2DoubleMap m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Double2DoubleOpenHashMap(Double2DoubleMap m) {
        this(m, 0.75f);
    }

    public Double2DoubleOpenHashMap(double[] k, double[] v, float f) {
        this(k.length, f);
        if (k.length != v.length) {
            throw new IllegalArgumentException("The key array and the value array have different lengths (" + k.length + " and " + v.length + ")");
        }
        for (int i = 0; i < k.length; ++i) {
            this.put(k[i], v[i]);
        }
    }

    public Double2DoubleOpenHashMap(double[] k, double[] v) {
        this(k, v, 0.75f);
    }

    @Override
    public double put(double k, double v) {
        int pos = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(k)) & this.mask;
        while (this.used[pos]) {
            if (k == this.key[pos]) {
                double oldValue = this.value[pos];
                this.value[pos] = v;
                return oldValue;
            }
            pos = pos + 1 & this.mask;
        }
        this.used[pos] = true;
        this.key[pos] = k;
        this.value[pos] = v;
        if (++this.size >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return this.defRetValue;
    }

    @Override
    public Double put(Double ok, Double ov) {
        double v = ov;
        double k = ok;
        int pos = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(k)) & this.mask;
        while (this.used[pos]) {
            if (k == this.key[pos]) {
                Double oldValue = this.value[pos];
                this.value[pos] = v;
                return oldValue;
            }
            pos = pos + 1 & this.mask;
        }
        this.used[pos] = true;
        this.key[pos] = k;
        this.value[pos] = v;
        if (++this.size >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return null;
    }

    public double add(double k, double incr) {
        int pos = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(k)) & this.mask;
        while (this.used[pos]) {
            if (k == this.key[pos]) {
                double oldValue = this.value[pos];
                int n = pos;
                this.value[n] = this.value[n] + incr;
                return oldValue;
            }
            pos = pos + 1 & this.mask;
        }
        this.used[pos] = true;
        this.key[pos] = k;
        this.value[pos] = this.defRetValue + incr;
        if (++this.size >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return this.defRetValue;
    }

    protected final void shiftKeys(int pos) {
        while (true) {
            int last = pos;
            pos = last + 1 & this.mask;
            while (this.used[pos]) {
                int slot = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(this.key[pos])) & this.mask;
                if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                pos = pos + 1 & this.mask;
            }
            if (!this.used[pos]) break;
            this.key[last] = this.key[pos];
            this.value[last] = this.value[pos];
        }
        this.used[last] = false;
    }

    @Override
    public double remove(double k) {
        int pos = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(k)) & this.mask;
        while (this.used[pos]) {
            if (k == this.key[pos]) {
                --this.size;
                double v = this.value[pos];
                this.shiftKeys(pos);
                return v;
            }
            pos = pos + 1 & this.mask;
        }
        return this.defRetValue;
    }

    @Override
    public Double remove(Object ok) {
        double k = (Double)ok;
        int pos = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(k)) & this.mask;
        while (this.used[pos]) {
            if (k == this.key[pos]) {
                --this.size;
                double v = this.value[pos];
                this.shiftKeys(pos);
                return v;
            }
            pos = pos + 1 & this.mask;
        }
        return null;
    }

    public Double get(Double ok) {
        double k = ok;
        int pos = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(k)) & this.mask;
        while (this.used[pos]) {
            if (k == this.key[pos]) {
                return this.value[pos];
            }
            pos = pos + 1 & this.mask;
        }
        return null;
    }

    @Override
    public double get(double k) {
        int pos = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(k)) & this.mask;
        while (this.used[pos]) {
            if (k == this.key[pos]) {
                return this.value[pos];
            }
            pos = pos + 1 & this.mask;
        }
        return this.defRetValue;
    }

    @Override
    public boolean containsKey(double k) {
        int pos = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(k)) & this.mask;
        while (this.used[pos]) {
            if (k == this.key[pos]) {
                return true;
            }
            pos = pos + 1 & this.mask;
        }
        return false;
    }

    @Override
    public boolean containsValue(double v) {
        double[] value = this.value;
        boolean[] used = this.used;
        int i = this.n;
        while (i-- != 0) {
            if (!used[i] || value[i] != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        BooleanArrays.fill(this.used, false);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Deprecated
    public void growthFactor(int growthFactor) {
    }

    @Deprecated
    public int growthFactor() {
        return 16;
    }

    public Double2DoubleMap.FastEntrySet double2DoubleEntrySet() {
        if (this.entries == null) {
            this.entries = new MapEntrySet();
        }
        return this.entries;
    }

    @Override
    public DoubleSet keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    @Override
    public DoubleCollection values() {
        if (this.values == null) {
            this.values = new AbstractDoubleCollection(){

                public DoubleIterator iterator() {
                    return new ValueIterator();
                }

                public int size() {
                    return Double2DoubleOpenHashMap.this.size;
                }

                public boolean contains(double v) {
                    return Double2DoubleOpenHashMap.this.containsValue(v);
                }

                public void clear() {
                    Double2DoubleOpenHashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    @Deprecated
    public boolean rehash() {
        return true;
    }

    public boolean trim() {
        int l = HashCommon.arraySize(this.size, this.f);
        if (l >= this.n) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n) {
        int l = HashCommon.nextPowerOfTwo((int)Math.ceil((float)n / this.f));
        if (this.n <= l) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(int newN) {
        int i = 0;
        boolean[] used = this.used;
        double[] key = this.key;
        double[] value = this.value;
        int newMask = newN - 1;
        double[] newKey = new double[newN];
        double[] newValue = new double[newN];
        boolean[] newUsed = new boolean[newN];
        int j = this.size;
        while (j-- != 0) {
            while (!used[i]) {
                ++i;
            }
            double k = key[i];
            int pos = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(k)) & newMask;
            while (newUsed[pos]) {
                pos = pos + 1 & newMask;
            }
            newUsed[pos] = true;
            newKey[pos] = k;
            newValue[pos] = value[i];
            ++i;
        }
        this.n = newN;
        this.mask = newMask;
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.key = newKey;
        this.value = newValue;
        this.used = newUsed;
    }

    public Double2DoubleOpenHashMap clone() {
        Double2DoubleOpenHashMap c;
        try {
            c = (Double2DoubleOpenHashMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.keys = null;
        c.values = null;
        c.entries = null;
        c.key = (double[])this.key.clone();
        c.value = (double[])this.value.clone();
        c.used = (boolean[])this.used.clone();
        return c;
    }

    @Override
    public int hashCode() {
        int h = 0;
        int j = this.size;
        int i = 0;
        int t = 0;
        while (j-- != 0) {
            while (!this.used[i]) {
                ++i;
            }
            t = HashCommon.double2int(this.key[i]);
            h += (t ^= HashCommon.double2int(this.value[i]));
            ++i;
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        double[] key = this.key;
        double[] value = this.value;
        MapIterator i = new MapIterator();
        s.defaultWriteObject();
        int j = this.size;
        while (j-- != 0) {
            int e = i.nextEntry();
            s.writeDouble(key[e]);
            s.writeDouble(value[e]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.n = HashCommon.arraySize(this.size, this.f);
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.mask = this.n - 1;
        this.key = new double[this.n];
        double[] key = this.key;
        this.value = new double[this.n];
        double[] value = this.value;
        this.used = new boolean[this.n];
        boolean[] used = this.used;
        int i = this.size;
        int pos = 0;
        while (i-- != 0) {
            double k = s.readDouble();
            double v = s.readDouble();
            pos = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(k)) & this.mask;
            while (used[pos]) {
                pos = pos + 1 & this.mask;
            }
            used[pos] = true;
            key[pos] = k;
            value[pos] = v;
        }
    }

    private void checkTable() {
    }

    private final class ValueIterator
    extends MapIterator
    implements DoubleIterator {
        public double nextDouble() {
            return Double2DoubleOpenHashMap.this.value[this.nextEntry()];
        }

        public Double next() {
            return Double2DoubleOpenHashMap.this.value[this.nextEntry()];
        }
    }

    private final class KeySet
    extends AbstractDoubleSet {
        private KeySet() {
        }

        public DoubleIterator iterator() {
            return new KeyIterator();
        }

        public int size() {
            return Double2DoubleOpenHashMap.this.size;
        }

        public boolean contains(double k) {
            return Double2DoubleOpenHashMap.this.containsKey(k);
        }

        public boolean remove(double k) {
            int oldSize = Double2DoubleOpenHashMap.this.size;
            Double2DoubleOpenHashMap.this.remove(k);
            return Double2DoubleOpenHashMap.this.size != oldSize;
        }

        public void clear() {
            Double2DoubleOpenHashMap.this.clear();
        }
    }

    private final class KeyIterator
    extends MapIterator
    implements DoubleIterator {
        public double nextDouble() {
            return Double2DoubleOpenHashMap.this.key[this.nextEntry()];
        }

        public Double next() {
            return Double2DoubleOpenHashMap.this.key[this.nextEntry()];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MapEntrySet
    extends AbstractObjectSet<Double2DoubleMap.Entry>
    implements Double2DoubleMap.FastEntrySet {
        private MapEntrySet() {
        }

        @Override
        public ObjectIterator<Double2DoubleMap.Entry> iterator() {
            return new EntryIterator();
        }

        @Override
        public ObjectIterator<Double2DoubleMap.Entry> fastIterator() {
            return new FastEntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            double k = (Double)e.getKey();
            int pos = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(k)) & Double2DoubleOpenHashMap.this.mask;
            while (Double2DoubleOpenHashMap.this.used[pos]) {
                if (k == Double2DoubleOpenHashMap.this.key[pos]) {
                    return Double2DoubleOpenHashMap.this.value[pos] == (Double)e.getValue();
                }
                pos = pos + 1 & Double2DoubleOpenHashMap.this.mask;
            }
            return false;
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            double k = (Double)e.getKey();
            int pos = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(k)) & Double2DoubleOpenHashMap.this.mask;
            while (Double2DoubleOpenHashMap.this.used[pos]) {
                if (k == Double2DoubleOpenHashMap.this.key[pos]) {
                    Double2DoubleOpenHashMap.this.remove(e.getKey());
                    return true;
                }
                pos = pos + 1 & Double2DoubleOpenHashMap.this.mask;
            }
            return false;
        }

        @Override
        public int size() {
            return Double2DoubleOpenHashMap.this.size;
        }

        @Override
        public void clear() {
            Double2DoubleOpenHashMap.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FastEntryIterator
    extends MapIterator
    implements ObjectIterator<Double2DoubleMap.Entry> {
        final AbstractDouble2DoubleMap.BasicEntry entry;

        private FastEntryIterator() {
            this.entry = new AbstractDouble2DoubleMap.BasicEntry(0.0, 0.0);
        }

        @Override
        public AbstractDouble2DoubleMap.BasicEntry next() {
            int e = this.nextEntry();
            this.entry.key = Double2DoubleOpenHashMap.this.key[e];
            this.entry.value = Double2DoubleOpenHashMap.this.value[e];
            return this.entry;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryIterator
    extends MapIterator
    implements ObjectIterator<Double2DoubleMap.Entry> {
        private EntryIterator() {
        }

        @Override
        public Double2DoubleMap.Entry next() {
            return new MapEntry(this.nextEntry());
        }
    }

    private class MapIterator {
        int pos;
        int last;
        int c;

        private MapIterator() {
            this.pos = Double2DoubleOpenHashMap.this.n;
            this.last = -1;
            this.c = Double2DoubleOpenHashMap.this.size;
            boolean[] used = Double2DoubleOpenHashMap.this.used;
            if (this.c != 0) {
                while (!used[--this.pos]) {
                }
            }
        }

        public boolean hasNext() {
            return this.c != 0;
        }

        public int nextEntry() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.last = this.pos;
            if (--this.c != 0) {
                boolean[] used = Double2DoubleOpenHashMap.this.used;
                while (!used[this.pos = this.pos - 1 & Double2DoubleOpenHashMap.this.mask]) {
                }
            }
            return this.last;
        }

        public void remove() {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            --Double2DoubleOpenHashMap.this.size;
            Double2DoubleOpenHashMap.this.shiftKeys(this.last);
            this.last = -1;
        }

        public int skip(int n) {
            int i = n;
            while (i-- != 0 && this.hasNext()) {
                this.nextEntry();
            }
            return n - i - 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MapEntry
    implements Double2DoubleMap.Entry,
    Map.Entry<Double, Double> {
        private int index;

        MapEntry(int index) {
            this.index = index;
        }

        @Override
        public Double getKey() {
            return Double2DoubleOpenHashMap.this.key[this.index];
        }

        @Override
        public double getDoubleKey() {
            return Double2DoubleOpenHashMap.this.key[this.index];
        }

        @Override
        public Double getValue() {
            return Double2DoubleOpenHashMap.this.value[this.index];
        }

        @Override
        public double getDoubleValue() {
            return Double2DoubleOpenHashMap.this.value[this.index];
        }

        @Override
        public double setValue(double v) {
            double oldValue = Double2DoubleOpenHashMap.this.value[this.index];
            Double2DoubleOpenHashMap.this.value[this.index] = v;
            return oldValue;
        }

        @Override
        public Double setValue(Double v) {
            return this.setValue((double)v);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Double2DoubleOpenHashMap.this.key[this.index] == (Double)e.getKey() && Double2DoubleOpenHashMap.this.value[this.index] == (Double)e.getValue();
        }

        @Override
        public int hashCode() {
            return HashCommon.double2int(Double2DoubleOpenHashMap.this.key[this.index]) ^ HashCommon.double2int(Double2DoubleOpenHashMap.this.value[this.index]);
        }

        public String toString() {
            return Double2DoubleOpenHashMap.this.key[this.index] + "=>" + Double2DoubleOpenHashMap.this.value[this.index];
        }
    }
}

