/*
 * Decompiled with CFR 0.152.
 */
package io.argoproj.workflow.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1LocalObjectReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="ScaleIOVolumeSource represents a persistent ScaleIO volume")
public class ScaleIOVolumeSource {
    public static final String SERIALIZED_NAME_FS_TYPE = "fsType";
    @SerializedName(value="fsType")
    private String fsType;
    public static final String SERIALIZED_NAME_GATEWAY = "gateway";
    @SerializedName(value="gateway")
    private String gateway;
    public static final String SERIALIZED_NAME_PROTECTION_DOMAIN = "protectionDomain";
    @SerializedName(value="protectionDomain")
    private String protectionDomain;
    public static final String SERIALIZED_NAME_READ_ONLY = "readOnly";
    @SerializedName(value="readOnly")
    private Boolean readOnly;
    public static final String SERIALIZED_NAME_SECRET_REF = "secretRef";
    @SerializedName(value="secretRef")
    private V1LocalObjectReference secretRef;
    public static final String SERIALIZED_NAME_SSL_ENABLED = "sslEnabled";
    @SerializedName(value="sslEnabled")
    private Boolean sslEnabled;
    public static final String SERIALIZED_NAME_STORAGE_MODE = "storageMode";
    @SerializedName(value="storageMode")
    private String storageMode;
    public static final String SERIALIZED_NAME_STORAGE_POOL = "storagePool";
    @SerializedName(value="storagePool")
    private String storagePool;
    public static final String SERIALIZED_NAME_SYSTEM = "system";
    @SerializedName(value="system")
    private String system;
    public static final String SERIALIZED_NAME_VOLUME_NAME = "volumeName";
    @SerializedName(value="volumeName")
    private String volumeName;

    public ScaleIOVolumeSource fsType(String fsType) {
        this.fsType = fsType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. \"ext4\", \"xfs\", \"ntfs\". Default is \"xfs\".")
    public String getFsType() {
        return this.fsType;
    }

    public void setFsType(String fsType) {
        this.fsType = fsType;
    }

    public ScaleIOVolumeSource gateway(String gateway) {
        this.gateway = gateway;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The host address of the ScaleIO API Gateway.")
    public String getGateway() {
        return this.gateway;
    }

    public void setGateway(String gateway) {
        this.gateway = gateway;
    }

    public ScaleIOVolumeSource protectionDomain(String protectionDomain) {
        this.protectionDomain = protectionDomain;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the ScaleIO Protection Domain for the configured storage.")
    public String getProtectionDomain() {
        return this.protectionDomain;
    }

    public void setProtectionDomain(String protectionDomain) {
        this.protectionDomain = protectionDomain;
    }

    public ScaleIOVolumeSource readOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.")
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public ScaleIOVolumeSource secretRef(V1LocalObjectReference secretRef) {
        this.secretRef = secretRef;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public V1LocalObjectReference getSecretRef() {
        return this.secretRef;
    }

    public void setSecretRef(V1LocalObjectReference secretRef) {
        this.secretRef = secretRef;
    }

    public ScaleIOVolumeSource sslEnabled(Boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Flag to enable/disable SSL communication with Gateway, default false")
    public Boolean getSslEnabled() {
        return this.sslEnabled;
    }

    public void setSslEnabled(Boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
    }

    public ScaleIOVolumeSource storageMode(String storageMode) {
        this.storageMode = storageMode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates whether the storage for a volume should be ThickProvisioned or ThinProvisioned. Default is ThinProvisioned.")
    public String getStorageMode() {
        return this.storageMode;
    }

    public void setStorageMode(String storageMode) {
        this.storageMode = storageMode;
    }

    public ScaleIOVolumeSource storagePool(String storagePool) {
        this.storagePool = storagePool;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ScaleIO Storage Pool associated with the protection domain.")
    public String getStoragePool() {
        return this.storagePool;
    }

    public void setStoragePool(String storagePool) {
        this.storagePool = storagePool;
    }

    public ScaleIOVolumeSource system(String system) {
        this.system = system;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The name of the storage system as configured in ScaleIO.")
    public String getSystem() {
        return this.system;
    }

    public void setSystem(String system) {
        this.system = system;
    }

    public ScaleIOVolumeSource volumeName(String volumeName) {
        this.volumeName = volumeName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of a volume already created in the ScaleIO system that is associated with this volume source.")
    public String getVolumeName() {
        return this.volumeName;
    }

    public void setVolumeName(String volumeName) {
        this.volumeName = volumeName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScaleIOVolumeSource scaleIOVolumeSource = (ScaleIOVolumeSource)o;
        return Objects.equals(this.fsType, scaleIOVolumeSource.fsType) && Objects.equals(this.gateway, scaleIOVolumeSource.gateway) && Objects.equals(this.protectionDomain, scaleIOVolumeSource.protectionDomain) && Objects.equals(this.readOnly, scaleIOVolumeSource.readOnly) && Objects.equals(this.secretRef, scaleIOVolumeSource.secretRef) && Objects.equals(this.sslEnabled, scaleIOVolumeSource.sslEnabled) && Objects.equals(this.storageMode, scaleIOVolumeSource.storageMode) && Objects.equals(this.storagePool, scaleIOVolumeSource.storagePool) && Objects.equals(this.system, scaleIOVolumeSource.system) && Objects.equals(this.volumeName, scaleIOVolumeSource.volumeName);
    }

    public int hashCode() {
        return Objects.hash(this.fsType, this.gateway, this.protectionDomain, this.readOnly, this.secretRef, this.sslEnabled, this.storageMode, this.storagePool, this.system, this.volumeName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScaleIOVolumeSource {\n");
        sb.append("    fsType: ").append(this.toIndentedString(this.fsType)).append("\n");
        sb.append("    gateway: ").append(this.toIndentedString(this.gateway)).append("\n");
        sb.append("    protectionDomain: ").append(this.toIndentedString(this.protectionDomain)).append("\n");
        sb.append("    readOnly: ").append(this.toIndentedString(this.readOnly)).append("\n");
        sb.append("    secretRef: ").append(this.toIndentedString(this.secretRef)).append("\n");
        sb.append("    sslEnabled: ").append(this.toIndentedString(this.sslEnabled)).append("\n");
        sb.append("    storageMode: ").append(this.toIndentedString(this.storageMode)).append("\n");
        sb.append("    storagePool: ").append(this.toIndentedString(this.storagePool)).append("\n");
        sb.append("    system: ").append(this.toIndentedString(this.system)).append("\n");
        sb.append("    volumeName: ").append(this.toIndentedString(this.volumeName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

