/*
 * Decompiled with CFR 0.152.
 */
package io.argoproj.workflow.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1LocalObjectReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="Represents a Rados Block Device mount that lasts the lifetime of a pod. RBD volumes support ownership management and SELinux relabeling.")
public class RBDVolumeSource {
    public static final String SERIALIZED_NAME_FS_TYPE = "fsType";
    @SerializedName(value="fsType")
    private String fsType;
    public static final String SERIALIZED_NAME_IMAGE = "image";
    @SerializedName(value="image")
    private String image;
    public static final String SERIALIZED_NAME_KEYRING = "keyring";
    @SerializedName(value="keyring")
    private String keyring;
    public static final String SERIALIZED_NAME_MONITORS = "monitors";
    @SerializedName(value="monitors")
    private List<String> monitors = new ArrayList<String>();
    public static final String SERIALIZED_NAME_POOL = "pool";
    @SerializedName(value="pool")
    private String pool;
    public static final String SERIALIZED_NAME_READ_ONLY = "readOnly";
    @SerializedName(value="readOnly")
    private Boolean readOnly;
    public static final String SERIALIZED_NAME_SECRET_REF = "secretRef";
    @SerializedName(value="secretRef")
    private V1LocalObjectReference secretRef;
    public static final String SERIALIZED_NAME_USER = "user";
    @SerializedName(value="user")
    private String user;

    public RBDVolumeSource fsType(String fsType) {
        this.fsType = fsType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: \"ext4\", \"xfs\", \"ntfs\". Implicitly inferred to be \"ext4\" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#rbd")
    public String getFsType() {
        return this.fsType;
    }

    public void setFsType(String fsType) {
        this.fsType = fsType;
    }

    public RBDVolumeSource image(String image) {
        this.image = image;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The rados image name. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it")
    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public RBDVolumeSource keyring(String keyring) {
        this.keyring = keyring;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Keyring is the path to key ring for RBDUser. Default is /etc/ceph/keyring. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it")
    public String getKeyring() {
        return this.keyring;
    }

    public void setKeyring(String keyring) {
        this.keyring = keyring;
    }

    public RBDVolumeSource monitors(List<String> monitors) {
        this.monitors = monitors;
        return this;
    }

    public RBDVolumeSource addMonitorsItem(String monitorsItem) {
        this.monitors.add(monitorsItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="A collection of Ceph monitors. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it")
    public List<String> getMonitors() {
        return this.monitors;
    }

    public void setMonitors(List<String> monitors) {
        this.monitors = monitors;
    }

    public RBDVolumeSource pool(String pool) {
        this.pool = pool;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The rados pool name. Default is rbd. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it")
    public String getPool() {
        return this.pool;
    }

    public void setPool(String pool) {
        this.pool = pool;
    }

    public RBDVolumeSource readOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ReadOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it")
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public RBDVolumeSource secretRef(V1LocalObjectReference secretRef) {
        this.secretRef = secretRef;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1LocalObjectReference getSecretRef() {
        return this.secretRef;
    }

    public void setSecretRef(V1LocalObjectReference secretRef) {
        this.secretRef = secretRef;
    }

    public RBDVolumeSource user(String user) {
        this.user = user;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The rados user name. Default is admin. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it")
    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RBDVolumeSource rbDVolumeSource = (RBDVolumeSource)o;
        return Objects.equals(this.fsType, rbDVolumeSource.fsType) && Objects.equals(this.image, rbDVolumeSource.image) && Objects.equals(this.keyring, rbDVolumeSource.keyring) && Objects.equals(this.monitors, rbDVolumeSource.monitors) && Objects.equals(this.pool, rbDVolumeSource.pool) && Objects.equals(this.readOnly, rbDVolumeSource.readOnly) && Objects.equals(this.secretRef, rbDVolumeSource.secretRef) && Objects.equals(this.user, rbDVolumeSource.user);
    }

    public int hashCode() {
        return Objects.hash(this.fsType, this.image, this.keyring, this.monitors, this.pool, this.readOnly, this.secretRef, this.user);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RBDVolumeSource {\n");
        sb.append("    fsType: ").append(this.toIndentedString(this.fsType)).append("\n");
        sb.append("    image: ").append(this.toIndentedString(this.image)).append("\n");
        sb.append("    keyring: ").append(this.toIndentedString(this.keyring)).append("\n");
        sb.append("    monitors: ").append(this.toIndentedString(this.monitors)).append("\n");
        sb.append("    pool: ").append(this.toIndentedString(this.pool)).append("\n");
        sb.append("    readOnly: ").append(this.toIndentedString(this.readOnly)).append("\n");
        sb.append("    secretRef: ").append(this.toIndentedString(this.secretRef)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

