/*
 * Decompiled with CFR 0.152.
 */
package io.argoproj.workflow.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="Represents a Quobyte mount that lasts the lifetime of a pod. Quobyte volumes do not support ownership management or SELinux relabeling.")
public class QuobyteVolumeSource {
    public static final String SERIALIZED_NAME_GROUP = "group";
    @SerializedName(value="group")
    private String group;
    public static final String SERIALIZED_NAME_READ_ONLY = "readOnly";
    @SerializedName(value="readOnly")
    private Boolean readOnly;
    public static final String SERIALIZED_NAME_REGISTRY = "registry";
    @SerializedName(value="registry")
    private String registry;
    public static final String SERIALIZED_NAME_TENANT = "tenant";
    @SerializedName(value="tenant")
    private String tenant;
    public static final String SERIALIZED_NAME_USER = "user";
    @SerializedName(value="user")
    private String user;
    public static final String SERIALIZED_NAME_VOLUME = "volume";
    @SerializedName(value="volume")
    private String volume;

    public QuobyteVolumeSource group(String group) {
        this.group = group;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Group to map volume access to Default is no group")
    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public QuobyteVolumeSource readOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ReadOnly here will force the Quobyte volume to be mounted with read-only permissions. Defaults to false.")
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public QuobyteVolumeSource registry(String registry) {
        this.registry = registry;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Registry represents a single or multiple Quobyte Registry services specified as a string as host:port pair (multiple entries are separated with commas) which acts as the central registry for volumes")
    public String getRegistry() {
        return this.registry;
    }

    public void setRegistry(String registry) {
        this.registry = registry;
    }

    public QuobyteVolumeSource tenant(String tenant) {
        this.tenant = tenant;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Tenant owning the given Quobyte volume in the Backend Used with dynamically provisioned Quobyte volumes, value is set by the plugin")
    public String getTenant() {
        return this.tenant;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public QuobyteVolumeSource user(String user) {
        this.user = user;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="User to map volume access to Defaults to serivceaccount user")
    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public QuobyteVolumeSource volume(String volume) {
        this.volume = volume;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Volume is a string that references an already created Quobyte volume by name.")
    public String getVolume() {
        return this.volume;
    }

    public void setVolume(String volume) {
        this.volume = volume;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QuobyteVolumeSource quobyteVolumeSource = (QuobyteVolumeSource)o;
        return Objects.equals(this.group, quobyteVolumeSource.group) && Objects.equals(this.readOnly, quobyteVolumeSource.readOnly) && Objects.equals(this.registry, quobyteVolumeSource.registry) && Objects.equals(this.tenant, quobyteVolumeSource.tenant) && Objects.equals(this.user, quobyteVolumeSource.user) && Objects.equals(this.volume, quobyteVolumeSource.volume);
    }

    public int hashCode() {
        return Objects.hash(this.group, this.readOnly, this.registry, this.tenant, this.user, this.volume);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class QuobyteVolumeSource {\n");
        sb.append("    group: ").append(this.toIndentedString(this.group)).append("\n");
        sb.append("    readOnly: ").append(this.toIndentedString(this.readOnly)).append("\n");
        sb.append("    registry: ").append(this.toIndentedString(this.registry)).append("\n");
        sb.append("    tenant: ").append(this.toIndentedString(this.tenant)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    volume: ").append(this.toIndentedString(this.volume)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

