/*
 * Decompiled with CFR 0.152.
 */
package io.argoproj.workflow.models;

import com.google.gson.annotations.SerializedName;
import io.argoproj.workflow.models.VolumeProjection;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Represents a projected volume source")
public class ProjectedVolumeSource {
    public static final String SERIALIZED_NAME_DEFAULT_MODE = "defaultMode";
    @SerializedName(value="defaultMode")
    private Integer defaultMode;
    public static final String SERIALIZED_NAME_SOURCES = "sources";
    @SerializedName(value="sources")
    private List<VolumeProjection> sources = null;

    public ProjectedVolumeSource defaultMode(Integer defaultMode) {
        this.defaultMode = defaultMode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Mode bits used to set permissions on created files by default. Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.")
    public Integer getDefaultMode() {
        return this.defaultMode;
    }

    public void setDefaultMode(Integer defaultMode) {
        this.defaultMode = defaultMode;
    }

    public ProjectedVolumeSource sources(List<VolumeProjection> sources) {
        this.sources = sources;
        return this;
    }

    public ProjectedVolumeSource addSourcesItem(VolumeProjection sourcesItem) {
        if (this.sources == null) {
            this.sources = new ArrayList<VolumeProjection>();
        }
        this.sources.add(sourcesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="list of volume projections")
    public List<VolumeProjection> getSources() {
        return this.sources;
    }

    public void setSources(List<VolumeProjection> sources) {
        this.sources = sources;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectedVolumeSource projectedVolumeSource = (ProjectedVolumeSource)o;
        return Objects.equals(this.defaultMode, projectedVolumeSource.defaultMode) && Objects.equals(this.sources, projectedVolumeSource.sources);
    }

    public int hashCode() {
        return Objects.hash(this.defaultMode, this.sources);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProjectedVolumeSource {\n");
        sb.append("    defaultMode: ").append(this.toIndentedString(this.defaultMode)).append("\n");
        sb.append("    sources: ").append(this.toIndentedString(this.sources)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

