/*
 * Decompiled with CFR 0.152.
 */
package io.argoproj.workflow.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="Represents a Photon Controller persistent disk resource.")
public class PhotonPersistentDiskVolumeSource {
    public static final String SERIALIZED_NAME_FS_TYPE = "fsType";
    @SerializedName(value="fsType")
    private String fsType;
    public static final String SERIALIZED_NAME_PD_I_D = "pdID";
    @SerializedName(value="pdID")
    private String pdID;

    public PhotonPersistentDiskVolumeSource fsType(String fsType) {
        this.fsType = fsType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. \"ext4\", \"xfs\", \"ntfs\". Implicitly inferred to be \"ext4\" if unspecified.")
    public String getFsType() {
        return this.fsType;
    }

    public void setFsType(String fsType) {
        this.fsType = fsType;
    }

    public PhotonPersistentDiskVolumeSource pdID(String pdID) {
        this.pdID = pdID;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="ID that identifies Photon Controller persistent disk")
    public String getPdID() {
        return this.pdID;
    }

    public void setPdID(String pdID) {
        this.pdID = pdID;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PhotonPersistentDiskVolumeSource photonPersistentDiskVolumeSource = (PhotonPersistentDiskVolumeSource)o;
        return Objects.equals(this.fsType, photonPersistentDiskVolumeSource.fsType) && Objects.equals(this.pdID, photonPersistentDiskVolumeSource.pdID);
    }

    public int hashCode() {
        return Objects.hash(this.fsType, this.pdID);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PhotonPersistentDiskVolumeSource {\n");
        sb.append("    fsType: ").append(this.toIndentedString(this.fsType)).append("\n");
        sb.append("    pdID: ").append(this.toIndentedString(this.pdID)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

