/*
 * Decompiled with CFR 0.152.
 */
package io.argoproj.workflow.models;

import com.google.gson.annotations.SerializedName;
import io.argoproj.workflow.models.LabelSelector;
import io.argoproj.workflow.models.TypedLocalObjectReference;
import io.kubernetes.client.openapi.models.V1ResourceRequirements;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="PersistentVolumeClaimSpec describes the common attributes of storage devices and allows a Source for provider-specific attributes")
public class PersistentVolumeClaimSpec {
    public static final String SERIALIZED_NAME_ACCESS_MODES = "accessModes";
    @SerializedName(value="accessModes")
    private List<String> accessModes = null;
    public static final String SERIALIZED_NAME_DATA_SOURCE = "dataSource";
    @SerializedName(value="dataSource")
    private TypedLocalObjectReference dataSource;
    public static final String SERIALIZED_NAME_DATA_SOURCE_REF = "dataSourceRef";
    @SerializedName(value="dataSourceRef")
    private TypedLocalObjectReference dataSourceRef;
    public static final String SERIALIZED_NAME_RESOURCES = "resources";
    @SerializedName(value="resources")
    private V1ResourceRequirements resources;
    public static final String SERIALIZED_NAME_SELECTOR = "selector";
    @SerializedName(value="selector")
    private LabelSelector selector;
    public static final String SERIALIZED_NAME_STORAGE_CLASS_NAME = "storageClassName";
    @SerializedName(value="storageClassName")
    private String storageClassName;
    public static final String SERIALIZED_NAME_VOLUME_MODE = "volumeMode";
    @SerializedName(value="volumeMode")
    private String volumeMode;
    public static final String SERIALIZED_NAME_VOLUME_NAME = "volumeName";
    @SerializedName(value="volumeName")
    private String volumeName;

    public PersistentVolumeClaimSpec accessModes(List<String> accessModes) {
        this.accessModes = accessModes;
        return this;
    }

    public PersistentVolumeClaimSpec addAccessModesItem(String accessModesItem) {
        if (this.accessModes == null) {
            this.accessModes = new ArrayList<String>();
        }
        this.accessModes.add(accessModesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="AccessModes contains the desired access modes the volume should have. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1")
    public List<String> getAccessModes() {
        return this.accessModes;
    }

    public void setAccessModes(List<String> accessModes) {
        this.accessModes = accessModes;
    }

    public PersistentVolumeClaimSpec dataSource(TypedLocalObjectReference dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public TypedLocalObjectReference getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(TypedLocalObjectReference dataSource) {
        this.dataSource = dataSource;
    }

    public PersistentVolumeClaimSpec dataSourceRef(TypedLocalObjectReference dataSourceRef) {
        this.dataSourceRef = dataSourceRef;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public TypedLocalObjectReference getDataSourceRef() {
        return this.dataSourceRef;
    }

    public void setDataSourceRef(TypedLocalObjectReference dataSourceRef) {
        this.dataSourceRef = dataSourceRef;
    }

    public PersistentVolumeClaimSpec resources(V1ResourceRequirements resources) {
        this.resources = resources;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1ResourceRequirements getResources() {
        return this.resources;
    }

    public void setResources(V1ResourceRequirements resources) {
        this.resources = resources;
    }

    public PersistentVolumeClaimSpec selector(LabelSelector selector) {
        this.selector = selector;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public LabelSelector getSelector() {
        return this.selector;
    }

    public void setSelector(LabelSelector selector) {
        this.selector = selector;
    }

    public PersistentVolumeClaimSpec storageClassName(String storageClassName) {
        this.storageClassName = storageClassName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of the StorageClass required by the claim. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#class-1")
    public String getStorageClassName() {
        return this.storageClassName;
    }

    public void setStorageClassName(String storageClassName) {
        this.storageClassName = storageClassName;
    }

    public PersistentVolumeClaimSpec volumeMode(String volumeMode) {
        this.volumeMode = volumeMode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="volumeMode defines what type of volume is required by the claim. Value of Filesystem is implied when not included in claim spec.")
    public String getVolumeMode() {
        return this.volumeMode;
    }

    public void setVolumeMode(String volumeMode) {
        this.volumeMode = volumeMode;
    }

    public PersistentVolumeClaimSpec volumeName(String volumeName) {
        this.volumeName = volumeName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="VolumeName is the binding reference to the PersistentVolume backing this claim.")
    public String getVolumeName() {
        return this.volumeName;
    }

    public void setVolumeName(String volumeName) {
        this.volumeName = volumeName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PersistentVolumeClaimSpec persistentVolumeClaimSpec = (PersistentVolumeClaimSpec)o;
        return Objects.equals(this.accessModes, persistentVolumeClaimSpec.accessModes) && Objects.equals(this.dataSource, persistentVolumeClaimSpec.dataSource) && Objects.equals(this.dataSourceRef, persistentVolumeClaimSpec.dataSourceRef) && Objects.equals(this.resources, persistentVolumeClaimSpec.resources) && Objects.equals(this.selector, persistentVolumeClaimSpec.selector) && Objects.equals(this.storageClassName, persistentVolumeClaimSpec.storageClassName) && Objects.equals(this.volumeMode, persistentVolumeClaimSpec.volumeMode) && Objects.equals(this.volumeName, persistentVolumeClaimSpec.volumeName);
    }

    public int hashCode() {
        return Objects.hash(this.accessModes, this.dataSource, this.dataSourceRef, this.resources, this.selector, this.storageClassName, this.volumeMode, this.volumeName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PersistentVolumeClaimSpec {\n");
        sb.append("    accessModes: ").append(this.toIndentedString(this.accessModes)).append("\n");
        sb.append("    dataSource: ").append(this.toIndentedString(this.dataSource)).append("\n");
        sb.append("    dataSourceRef: ").append(this.toIndentedString(this.dataSourceRef)).append("\n");
        sb.append("    resources: ").append(this.toIndentedString(this.resources)).append("\n");
        sb.append("    selector: ").append(this.toIndentedString(this.selector)).append("\n");
        sb.append("    storageClassName: ").append(this.toIndentedString(this.storageClassName)).append("\n");
        sb.append("    volumeMode: ").append(this.toIndentedString(this.volumeMode)).append("\n");
        sb.append("    volumeName: ").append(this.toIndentedString(this.volumeName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

