/*
 * Decompiled with CFR 0.152.
 */
package io.argoproj.workflow.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="ObjectFieldSelector selects an APIVersioned field of an object.")
public class ObjectFieldSelector {
    public static final String SERIALIZED_NAME_API_VERSION = "apiVersion";
    @SerializedName(value="apiVersion")
    private String apiVersion;
    public static final String SERIALIZED_NAME_FIELD_PATH = "fieldPath";
    @SerializedName(value="fieldPath")
    private String fieldPath;

    public ObjectFieldSelector apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Version of the schema the FieldPath is written in terms of, defaults to \"v1\".")
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public ObjectFieldSelector fieldPath(String fieldPath) {
        this.fieldPath = fieldPath;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Path of the field to select in the specified API version.")
    public String getFieldPath() {
        return this.fieldPath;
    }

    public void setFieldPath(String fieldPath) {
        this.fieldPath = fieldPath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectFieldSelector objectFieldSelector = (ObjectFieldSelector)o;
        return Objects.equals(this.apiVersion, objectFieldSelector.apiVersion) && Objects.equals(this.fieldPath, objectFieldSelector.fieldPath);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.fieldPath);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ObjectFieldSelector {\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    fieldPath: ").append(this.toIndentedString(this.fieldPath)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

